/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.invadermonky.justenoughmagiculture.util.BlockStateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemHelper {
    private static final List<PotionType> POTION_TYPES = ItemHelper.getPotions();

    public static ItemStack getItemStack(JsonObject jsonObject) {
        ItemStack stack = ItemStack.field_190927_a;
        try {
            Block block;
            if (jsonObject.has("item")) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get("item").getAsString()));
                if (item != null && item != Items.field_190931_a) {
                    int meta = jsonObject.has("meta") ? jsonObject.get("meta").getAsInt() : 0;
                    stack = new ItemStack(item, 1, meta);
                }
            } else if (jsonObject.has("itemBlock") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(jsonObject.get("itemBlock").getAsString()))) != null && block != Blocks.field_150350_a) {
                IBlockState state = block.func_176223_P();
                if (jsonObject.has("properties")) {
                    JsonObject properties = jsonObject.getAsJsonObject("properties");
                    for (Map.Entry prop : properties.entrySet()) {
                        Comparable propertyValue;
                        String propStr = "";
                        IProperty property = BlockStateHelper.getProperty(state, (String)prop.getKey());
                        if (property == null || (propertyValue = BlockStateHelper.getPropertyValue(property, ((JsonElement)prop.getValue()).getAsString())) == null) continue;
                        state = state.func_177226_a(property, propertyValue);
                    }
                }
                stack = new ItemStack(block, 1, block.func_176201_c(state));
            }
            if (!stack.func_190926_b()) {
                JsonArray enchantments;
                int count = 0;
                if (!jsonObject.has("minCount") && !jsonObject.has("maxCount")) {
                    if (jsonObject.has("count")) {
                        count = jsonObject.get("count").getAsInt();
                    }
                } else {
                    count = (jsonObject.get("minCount").getAsInt() + jsonObject.get("maxCount").getAsInt()) / 2;
                }
                stack.func_190920_e(count);
                if (jsonObject.has("displayName")) {
                    stack.func_151001_c(jsonObject.get("displayName").getAsString());
                }
                ArrayList<String> loreList = new ArrayList<String>();
                if (jsonObject.has("lore")) {
                    JsonArray loreArray = jsonObject.getAsJsonArray("lore");
                    for (JsonElement loreElement : loreArray) {
                        loreList.add(loreElement.getAsString());
                    }
                }
                if (loreList != null && loreList.size() > 0) {
                    ItemHelper.ensureTagExists(stack);
                    NBTTagList loreTagList = new NBTTagList();
                    for (String lore : loreList) {
                        loreTagList.func_74742_a((NBTBase)new NBTTagString(lore));
                    }
                    NBTTagCompound displayCompound = new NBTTagCompound();
                    displayCompound.func_74782_a("Lore", (NBTBase)loreTagList);
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74782_a("display", (NBTBase)displayCompound);
                    ItemHelper.setTagIfNotExistent(stack, compound);
                }
                JsonArray jsonArray = enchantments = jsonObject.has("enchantments") ? jsonObject.getAsJsonArray("enchantments") : null;
                if (enchantments != null) {
                    for (JsonElement enchant : enchantments) {
                        Enchantment enchantment = Enchantment.func_180305_b((String)enchant.getAsJsonObject().get("enchantment").getAsString());
                        if (enchantment == null) continue;
                        int level = 0;
                        if (!enchant.getAsJsonObject().has("minEnchantmentLevel") && !enchant.getAsJsonObject().has("maxEnchantmentLevel")) {
                            if (enchant.getAsJsonObject().has("enchantmentLevel")) {
                                level = enchant.getAsJsonObject().get("enchantmentLevel").getAsInt();
                            }
                        } else {
                            level = enchant.getAsJsonObject().get("maxEnchantmentLevel").getAsInt();
                        }
                        if (stack.func_77973_b() instanceof ItemEnchantedBook) {
                            ItemEnchantedBook.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, level));
                            continue;
                        }
                        stack.func_77966_a(enchantment, level);
                    }
                }
            }
        }
        catch (Exception ignored) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static NBTTagCompound ensureTagExists(ItemStack stack) {
        return ItemHelper.setTagIfNotExistent(stack, new NBTTagCompound());
    }

    public static NBTTagCompound setTagIfNotExistent(ItemStack stack, NBTTagCompound compound) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(compound);
        } else if (!compound.func_82582_d()) {
            stack.func_77978_p().func_179237_a(compound);
        }
        return stack.func_77978_p();
    }

    public static ItemStack getRandomlyEnchantedBook(int level) {
        Random rand = new Random();
        return EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack(Items.field_151122_aG), (int)(rand.nextInt(10) + 5 + level), (boolean)true);
    }

    public static ItemStack getRandomPotion() {
        Random rand = new Random();
        return PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)POTION_TYPES.get(rand.nextInt(POTION_TYPES.size())));
    }

    private static List<PotionType> getPotions() {
        ArrayList<PotionType> potionTypes = new ArrayList<PotionType>(ForgeRegistries.POTION_TYPES.getValuesCollection());
        potionTypes.remove(PotionTypes.field_185229_a);
        potionTypes.remove(PotionTypes.field_185230_b);
        potionTypes.remove(PotionTypes.field_185231_c);
        potionTypes.remove(PotionTypes.field_185232_d);
        potionTypes.remove(PotionTypes.field_185233_e);
        return potionTypes;
    }
}

