/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util;

import javax.annotation.Nullable;
import meldexun.entityculling.EntityCulling;
import meldexun.entityculling.integration.CubicChunks;
import meldexun.entityculling.util.function.ObjIntIntInt2ObjFunction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class CachedBlockAccess {
    private World world;
    private ObjIntIntInt2ObjFunction<World, ExtendedBlockStorage> sectionGetter;
    private ExtendedBlockStorage cachedSection;
    private int cachedSectionX = Integer.MAX_VALUE;
    private int cachedSectionY = Integer.MAX_VALUE;
    private int cachedSectionZ = Integer.MAX_VALUE;

    public void init(World world) {
        this.world = world;
        this.sectionGetter = world == null ? (world1, sectionX, sectionY, setionZ) -> null : (EntityCulling.isCubicChunksInstalled && CubicChunks.isCubicWorld(world) ? (world1, sectionX, sectionY, sectionZ) -> {
            if (CubicChunks.isOutsideBuildHeight(world1, sectionY << 4)) {
                return null;
            }
            return CubicChunks.getBlockStorage(world1, sectionX, sectionY, sectionZ);
        } : (world1, sectionX, sectionY, sectionZ) -> {
            if (sectionY < 0 || sectionY >= 16) {
                return null;
            }
            Chunk chunk = world1.func_72863_F().func_186026_b(sectionX, sectionZ);
            if (chunk == null) {
                return null;
            }
            return chunk.func_76587_i()[sectionY];
        });
        this.cachedSection = null;
        this.cachedSectionX = Integer.MAX_VALUE;
        this.cachedSectionY = Integer.MAX_VALUE;
        this.cachedSectionZ = Integer.MAX_VALUE;
    }

    public void clear() {
        this.world = null;
        this.sectionGetter = null;
        this.cachedSection = null;
        this.cachedSectionX = Integer.MAX_VALUE;
        this.cachedSectionY = Integer.MAX_VALUE;
        this.cachedSectionZ = Integer.MAX_VALUE;
    }

    public IBlockState getBlockState(int x, int y, int z) {
        try {
            ExtendedBlockStorage section = this.getChunkSection(x >> 4, y >> 4, z >> 4);
            if (section == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    @Nullable
    private ExtendedBlockStorage getChunkSection(int sectionX, int sectionY, int sectionZ) {
        if (this.cachedSectionX != sectionX || this.cachedSectionY != sectionY || this.cachedSectionZ != sectionZ) {
            this.cachedSection = this.sectionGetter.apply(this.world, sectionX, sectionY, sectionZ);
            this.cachedSectionX = sectionX;
            this.cachedSectionY = sectionY;
            this.cachedSectionZ = sectionZ;
        }
        return this.cachedSection;
    }
}

