/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.util.raytracing;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;

class Int2BoolMap
extends Int2BooleanOpenHashMap {
    public Int2BoolMap() {
    }

    public Int2BoolMap(int expected, float f) {
        super(expected, f);
    }

    public boolean computeIfAbsent(int k, IntPredicate mappingFunction) {
        int pos = this.find(k);
        if (pos >= 0) {
            return this.value[pos];
        }
        boolean newValue = mappingFunction.test(k);
        this.insert(-pos - 1, k, newValue);
        return newValue;
    }

    public boolean computeIfAbsent(int k, BooleanSupplier mappingFunction) {
        int pos = this.find(k);
        if (pos >= 0) {
            return this.value[pos];
        }
        boolean newValue = mappingFunction.getAsBoolean();
        this.insert(-pos - 1, k, newValue);
        return newValue;
    }

    private int find(int k) {
        if (k == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] key = this.key;
        int pos = HashCommon.mix((int)k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private void insert(int pos, int k, boolean v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)this.f));
        }
    }
}

