/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.localization;

import mystlibrary.MystLibrary;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import org.apache.logging.log4j.Logger;

public final class Localization {
    private static final Logger LOG = MystLibrary.logger;

    private Localization() {
    }

    public static String getLocalizedBiomeName(Biome biome) {
        String name = null;
        if (biome != null) {
            name = biome.func_185359_l();
        }
        return name;
    }

    public static String getLocalizedBlockStateName(IBlockState state) {
        String localized = null;
        if (state != null) {
            Block block = state.func_177230_c();
            ItemStack stack = Localization.getItemStackFromBlockState(state);
            if (stack != null) {
                localized = stack.func_82833_r();
            }
            if (localized == null) {
                try {
                    Item item = Item.func_150898_a((Block)block);
                    String unlocal = item.func_77658_a();
                    localized = MystLibrary.proxy.localize(unlocal, new Object[0]);
                    if (localized.equals(unlocal)) {
                        localized = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (localized == null) {
                localized = block.func_149732_F();
            }
        }
        return localized;
    }

    public static String getUnlocalizedBlockStateName(IBlockState state) {
        String name = null;
        if (state != null) {
            Block block = state.func_177230_c();
            ItemStack stack = Localization.getItemStackFromBlockState(state);
            if (stack != null) {
                name = stack.func_77977_a();
            }
            if (name == null) {
                try {
                    Item item = Item.func_150898_a((Block)block);
                    name = item.func_77658_a();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (name == null) {
                name = block.func_149739_a();
            }
        }
        return name;
    }

    public static ItemStack getItemStackFromBlockState(IBlockState state) {
        ItemStack stack = ItemStack.field_190927_a;
        Block block = state.func_177230_c();
        try {
            stack = block.getPickBlock(state, null, null, null, null);
        }
        catch (Exception ex) {
            LOG.error("Block::getPickBlock failed for IBlockState \"" + state.toString() + "\". Attempting to create new ItemStack instance.");
        }
        if (stack == null || stack.equals(ItemStack.field_190927_a)) {
            try {
                int meta = state.func_177230_c().func_176201_c(state);
                stack = new ItemStack(state.func_177230_c(), 1, meta);
            }
            catch (Exception ex) {
                LOG.error("Failed to create new ItemStack instance from IBlockState \"" + state.toString() + "\". Returning empty ItemStack.");
            }
        }
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }
}

