/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import java.util.ArrayList;
import mystlibrary.MystLibrary;
import mystlibrary.exception.ModMissingException;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.grammar.GrammarRule;
import mystlibrary.proxy.CommonProxy;
import mystlibrary.symbol.SymbolLoader;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.IAgeSymbolBehavior;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class AgeSymbol
implements IAgeSymbol {
    private final SymbolMetadata metadata;
    private final IAgeSymbolBehavior behavior;

    public static AgeSymbol fromJson(JsonObject json) throws SymbolBuildException, ModMissingException.BlockSymbol {
        AgeSymbol symbol = null;
        SymbolMetadata metadata = SymbolMetadata.fromJson(json);
        IAgeSymbolBehavior behavior = null;
        JsonObject behaviorJson = json.get("behavior").getAsJsonObject();
        String behaviorId = behaviorJson.get("behavior_id").getAsString();
        ResourceLocation behaviorName = new ResourceLocation(behaviorId);
        IAgeSymbolBehavior.BehaviorFactory factory = SymbolLoader.BEHAVIORS.get(behaviorName);
        if (factory == null) {
            factory = (j, m) -> new NoBehavior();
            MystLibrary.logger.error("Could not parse behavior \"" + behaviorName.toString() + "\". Replacing with dummy behavior.");
        }
        behavior = factory.fromJson(behaviorJson, metadata);
        symbol = new AgeSymbol(metadata, behavior);
        return symbol;
    }

    public JsonObject toJson() {
        JsonObject json = this.metadata.toJson();
        json.add("behavior", (JsonElement)this.behavior.toJson());
        return json;
    }

    public static JsonObject toJson(IAgeSymbol symbol) {
        if (symbol instanceof AgeSymbol) {
            return ((AgeSymbol)symbol).toJson();
        }
        return null;
    }

    public AgeSymbol(SymbolMetadata metadata, IAgeSymbolBehavior behavior) {
        this.metadata = new SymbolMetadata(metadata);
        this.behavior = behavior;
    }

    public void registerGrammarRules() {
        for (GrammarRule rule : this.metadata.grammarRules) {
            MystLibrary.mystcraft.grammar.registerGrammarRule(rule.parent, rule.rank, rule.getChildren());
        }
    }

    public void registerSymbolRank() {
        if (this.metadata.cardRank != null) {
            MystLibrary.mystcraft.symbolValues.setSymbolCardRank((IAgeSymbol)this, this.metadata.cardRank.intValue());
        }
    }

    public ResourceLocation getRegistryName() {
        return this.metadata.name;
    }

    public IAgeSymbol setRegistryName(ResourceLocation name) {
        this.metadata.name = name;
        return this;
    }

    public void registerLogic(AgeDirector controller, long seed) {
        this.behavior.registerLogic(controller, seed);
    }

    public int instabilityModifier(int count) {
        int instability = 0;
        if (this.metadata.maxCount != null && this.metadata.instabilityPerInstance != null && count > this.metadata.maxCount) {
            instability = this.metadata.instabilityPerInstance;
        }
        return instability;
    }

    public boolean generatesConfigOption() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        CommonProxy proxy = MystLibrary.proxy;
        ArrayList<String> localizedParameters = new ArrayList<String>();
        for (String param : this.metadata.localizationParameters) {
            localizedParameters.add(proxy.localize(param, new Object[0]));
        }
        return proxy.localize(this.metadata.unlocalName, localizedParameters.toArray(new Object[0]));
    }

    public String[] getPoem() {
        return this.metadata.poem.toArray(new String[0]);
    }

    private static final class NoBehavior
    implements IAgeSymbolBehavior {
        private NoBehavior() {
        }

        @Override
        public void registerLogic(AgeDirector controller, long seed) {
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("behavior_id", "unknown:unknown");
            return json;
        }
    }
}

