/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mystlibrary.MystLibrary;
import mystlibrary.localization.Localization;
import mystlibrary.symbol.util.SymbolConverter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;

public class PoemWord {
    private static List<String> knownWords = Arrays.asList("Balance", "Believe", "Celestial", "Chain", "Change", "Chaos", "Civilization", "Constraint", "Contradict", "Control", "Convey", "Creativity", "Cycle", "Dependence", "Discover", "Dynamic", "Elevate", "Encourage", "Energy", "Entropy", "Ethereal", "Exist", "Explore", "Flow", "Force", "Form", "Future", "Growth", "Harmony", "Honor", "Image", "Infinite", "Inhibit", "Intelligence", "Love", "Machine", "Merge", "Momentum", "Motion", "Mutual", "Nature", "Nurture", "Order", "Possibility", "Power", "Question", "Rebirth", "Remember", "Resilience", "Resurrect", "Sacrifice", "Society", "Spur", "Static", "Stimulate", "Survival", "Sustain", "System", "Terrain", "Time", "Tradition", "Transform", "Void", "Weave", "Wisdom");

    public static List<String> getKnownWords() {
        return new ArrayList<String>(knownWords);
    }

    public static String localizePoemWord(String poemWord, IAgeSymbol symbol) {
        String unlocalized = "mystcraft.poemword." + poemWord.trim().toLowerCase().replace(" ", "_") + ".name";
        String localized = MystLibrary.proxy.localize(unlocalized, new Object[0]);
        if (!localized.equals(unlocalized)) {
            return localized;
        }
        localized = PoemWord.localizeColorWord(poemWord, symbol);
        if (localized == null) {
            localized = PoemWord.localizeBiomeWord(poemWord, symbol);
        }
        if (localized == null) {
            localized = PoemWord.localizeBlockWord(poemWord, symbol);
        }
        if (localized == null) {
            localized = poemWord;
        }
        return localized;
    }

    private static String localizeColorWord(String poemWord, IAgeSymbol symbol) {
        Pattern pattern = Pattern.compile("^modcolor(.*)$");
        String localized = null;
        Matcher matcher = pattern.matcher(poemWord);
        if (matcher.matches()) {
            localized = MystLibrary.proxy.localize("mystcraft.poemword.color." + matcher.group(1) + ".name", new Object[0]);
        }
        return localized;
    }

    private static String localizeBiomeWord(String poemWord, IAgeSymbol symbol) {
        Pattern pattern = Pattern.compile("^.*?(\\d+)$");
        String localized = null;
        Matcher matcher = pattern.matcher(poemWord);
        if (matcher.matches()) {
            String biomeId = matcher.group(1);
            Biome biome = SymbolConverter.toBiome(symbol, false);
            if (biome != null && biomeId.endsWith(Integer.toString(Biome.func_185362_a((Biome)biome)))) {
                localized = Localization.getLocalizedBiomeName(biome);
            }
        }
        return localized;
    }

    private static String localizeBlockWord(String poemWord, IAgeSymbol symbol) {
        IBlockState blockState;
        Pattern pattern = Pattern.compile("^modmat_(.*?)_(\\d+)$");
        String localized = null;
        Matcher matcher = pattern.matcher(poemWord);
        if (matcher.matches() && (blockState = SymbolConverter.toBlockState(symbol, false)) != null) {
            localized = Localization.getLocalizedBlockStateName(blockState);
        }
        return localized;
    }
}

