/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.grammar.GrammarRule;
import mystlibrary.symbol.util.SymbolJsonParser;
import net.minecraft.util.ResourceLocation;

public final class SymbolMetadata {
    public static final String SYMBOL_ID = "symbol_id";
    public static final String POEM = "poem";
    public static final String GRAMMAR_RULES = "grammar_rules";
    public static final String CARD_RANK = "card_rank";
    public static final String INSTABILITY = "instability";
    public static final String MAX_COUNT = "max_count";
    public static final String PER_SYMBOL = "per_symbol";
    public static final String LOCALIZATION = "localization";
    public static final String UNLOCAL_NAME = "unlocal_name";
    public static final String PARAMETERS = "parameters";
    public ResourceLocation name;
    public List<String> poem = new ArrayList<String>();
    public List<GrammarRule> grammarRules = new ArrayList<GrammarRule>();
    public Integer cardRank = null;
    public Integer maxCount = null;
    public Integer instabilityPerInstance = null;
    public String unlocalName = "";
    public List<String> localizationParameters = new ArrayList<String>();

    public SymbolMetadata() {
    }

    public SymbolMetadata(SymbolMetadata metadata) {
        this.name = new ResourceLocation(metadata.name.toString());
        this.poem = new ArrayList<String>(metadata.poem);
        this.grammarRules = new ArrayList<GrammarRule>(metadata.grammarRules);
        this.cardRank = metadata.cardRank;
        this.unlocalName = metadata.unlocalName;
        this.localizationParameters = new ArrayList<String>(metadata.localizationParameters);
        if (metadata.maxCount != null) {
            this.maxCount = new Integer(metadata.maxCount);
        }
        if (metadata.instabilityPerInstance != null) {
            this.instabilityPerInstance = new Integer(metadata.instabilityPerInstance);
        }
    }

    public static SymbolMetadata fromJson(JsonObject json) throws SymbolBuildException {
        JsonObject localizationJson;
        SymbolMetadata data = new SymbolMetadata();
        String resource = SymbolJsonParser.parseString(json, SYMBOL_ID, data);
        data.name = new ResourceLocation(resource);
        JsonArray poemWords = SymbolJsonParser.parseJsonArray(json, POEM, data);
        ArrayList<String> wordList = new ArrayList<String>();
        for (Object word : poemWords) {
            wordList.add(word.getAsString());
        }
        data.poem = new ArrayList<String>(wordList);
        JsonArray rules = SymbolJsonParser.parseJsonArray(json, GRAMMAR_RULES, data);
        for (JsonElement rule : rules) {
            data.grammarRules.add(GrammarRule.fromJson(rule.getAsJsonObject(), data, data.name));
        }
        if (json.has(CARD_RANK)) {
            data.cardRank = SymbolJsonParser.parseInt(json, CARD_RANK, data);
        }
        if (json.has(INSTABILITY)) {
            JsonObject instability = SymbolJsonParser.parseJsonObject(json, INSTABILITY, data);
            if (instability.has(MAX_COUNT)) {
                data.maxCount = SymbolJsonParser.parseInt(instability, MAX_COUNT, data);
            }
            if (instability.has(PER_SYMBOL)) {
                data.instabilityPerInstance = SymbolJsonParser.parseInt(instability, PER_SYMBOL, data);
            }
        }
        if (json.has(LOCALIZATION) && (localizationJson = SymbolJsonParser.parseJsonObject(json, LOCALIZATION, data)).has(UNLOCAL_NAME)) {
            data.unlocalName = SymbolJsonParser.parseString(localizationJson, UNLOCAL_NAME, data);
            if (localizationJson.has(PARAMETERS)) {
                JsonArray parameters = SymbolJsonParser.parseJsonArray(localizationJson, PARAMETERS, data);
                ArrayList<String> parameterList = new ArrayList<String>();
                for (JsonElement parameter : parameters) {
                    parameterList.add(parameter.getAsString());
                }
                data.localizationParameters = new ArrayList<String>(parameterList);
            }
        }
        return data;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        String symbolId = this.name.toString();
        json.addProperty(SYMBOL_ID, symbolId);
        JsonArray poemArray = new JsonArray();
        json.add(POEM, (JsonElement)poemArray);
        for (String word : this.poem) {
            poemArray.add(word);
        }
        json.addProperty(CARD_RANK, (Number)this.cardRank);
        JsonObject instability = new JsonObject();
        instability.addProperty(MAX_COUNT, (Number)this.maxCount);
        instability.addProperty(PER_SYMBOL, (Number)this.instabilityPerInstance);
        json.add(INSTABILITY, (JsonElement)instability);
        JsonObject localization = new JsonObject();
        localization.addProperty(UNLOCAL_NAME, this.unlocalName);
        JsonArray params = new JsonArray();
        for (String parameter : this.localizationParameters) {
            params.add(parameter);
        }
        localization.add(PARAMETERS, (JsonElement)params);
        json.add(LOCALIZATION, (JsonElement)localization);
        JsonArray grammarRules = new JsonArray();
        for (GrammarRule rule : this.grammarRules) {
            JsonObject object = new JsonObject();
            object.addProperty("parent", rule.parent.toString());
            object.addProperty("rank", (Number)rule.rank);
            grammarRules.add((JsonElement)object);
        }
        json.add(GRAMMAR_RULES, (JsonElement)grammarRules);
        return json;
    }
}

