/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol.behavior;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.instability.InstabilityBlockManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mystlibrary.MystLibrary;
import mystlibrary.exception.ModMissingException;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.grammar.GrammarRule;
import mystlibrary.localization.Localization;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.IAgeSymbolBehavior;
import mystlibrary.symbol.util.SymbolJsonParser;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class BlockStateBehavior
implements IAgeSymbolBehavior {
    public final BlockDescriptor blockDescriptor;
    private static final String BLOCK_ID = "block_id";
    private static final String PROPERTIES = "properties";
    private static final String INSTABILITY_BASE = "instability_base";
    private static final String INSTABILITY_EXPOSED = "instablity_exposed";
    private static final String BLOCK_PLACEHOLDER = "BLOCK_NAME";
    public static final ResourceLocation NAME = MystLibrary.resource("block");

    public static IAgeSymbolBehavior fromJson(JsonObject json, SymbolMetadata metadata) throws SymbolBuildException, ModMissingException.BlockSymbol {
        BlockStateBehavior behavior = null;
        String blockId = json.get(BLOCK_ID).getAsString();
        Block block = Block.func_149684_b((String)blockId);
        if (!Loader.isModLoaded((String)new ResourceLocation(blockId).func_110624_b())) {
            throw new ModMissingException.BlockSymbol(blockId);
        }
        if (block == null) {
            throw new SymbolBuildException(metadata, "Block \"" + blockId + "\" not found.");
        }
        IBlockState state = block.func_176223_P();
        if (json.get(PROPERTIES) != null) {
            JsonObject blockProperties = json.get(PROPERTIES).getAsJsonObject();
            for (Map.Entry entry : blockProperties.entrySet()) {
                String propertyId = (String)entry.getKey();
                String propertyValue = ((JsonElement)entry.getValue()).getAsString();
                IProperty property = BlockStateBehavior.parseProperty(state, propertyId);
                if (property == null) {
                    MystLibrary.logger.error("Cannot find property \"" + (String)propertyId + "\" for block \"" + blockId + "\". Leaving in default state.");
                    continue;
                }
                Comparable value = null;
                Collection possibleValues = property.func_177700_c();
                ArrayList<String> acceptableValues = new ArrayList<String>();
                for (Object singleValue : possibleValues) {
                    if (singleValue instanceof IStringSerializable) {
                        String valueName = ((IStringSerializable)singleValue).func_176610_l().trim().toLowerCase();
                        if (valueName.equals(propertyValue)) {
                            value = (Comparable)property.func_185929_b(valueName).get();
                            break;
                        }
                        acceptableValues.add(valueName);
                    } else {
                        acceptableValues.add(singleValue.toString().trim().toLowerCase());
                    }
                    if (!singleValue.toString().equals(propertyValue)) continue;
                    value = (Comparable)singleValue;
                    break;
                }
                if (value == null) {
                    MystLibrary.logger.error("Cannot apply value \"" + propertyValue + "\" to property \"" + (String)propertyId + "\". Leaving in default state.");
                    MystLibrary.logger.error("Acceptable values are: " + String.join((CharSequence)", ", acceptableValues) + ".");
                    continue;
                }
                state = state.func_177226_a(property, value);
            }
        }
        float instabilityFactorBase = json.get(INSTABILITY_BASE) != null ? SymbolJsonParser.parseFloat(json, INSTABILITY_BASE, metadata) : 0.0f;
        float instabilityFactorExposed = json.get(INSTABILITY_EXPOSED) != null ? SymbolJsonParser.parseFloat(json, INSTABILITY_EXPOSED, metadata) : 0.0f;
        ArrayList<BlockCategory> categories = new ArrayList<BlockCategory>();
        for (GrammarRule rule : metadata.grammarRules) {
            BlockCategory category = BlockCategory.getBlockCategory((ResourceLocation)rule.parent);
            categories.add(category);
        }
        if (metadata.unlocalName.isEmpty()) {
            metadata.unlocalName = Localization.getUnlocalizedBlockStateName(state).endsWith(".name") ? Localization.getUnlocalizedBlockStateName(state) : Localization.getUnlocalizedBlockStateName(state) + ".name";
        }
        for (int i = 0; i < metadata.poem.size(); ++i) {
            if (!metadata.poem.get(i).equals(BLOCK_PLACEHOLDER)) continue;
            metadata.poem.set(i, Localization.getLocalizedBlockStateName(state));
        }
        behavior = new BlockStateBehavior(state, categories, instabilityFactorBase, instabilityFactorExposed);
        return behavior;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        IBlockState state = this.blockDescriptor.blockstate;
        json.addProperty("behavior_id", NAME.toString());
        json.addProperty(BLOCK_ID, state.func_177230_c().getRegistryName().toString());
        JsonObject properties = new JsonObject();
        json.add(PROPERTIES, (JsonElement)properties);
        Collection propertiesCollection = state.func_177227_a();
        for (IProperty property : propertiesCollection) {
            Comparable value = state.func_177229_b(property);
            if (value instanceof Number) {
                properties.addProperty(property.func_177701_a(), (Number)((Object)value));
                continue;
            }
            if (value instanceof Boolean) {
                properties.addProperty(property.func_177701_a(), (Boolean)value);
                continue;
            }
            if (value instanceof String) {
                properties.addProperty(property.func_177701_a(), (String)((Object)value));
                continue;
            }
            if (!(value instanceof IStringSerializable)) continue;
            properties.addProperty(property.func_177701_a(), ((IStringSerializable)value).func_176610_l());
        }
        return json;
    }

    public BlockStateBehavior(IBlockState state, List<BlockCategory> categories, float instabilityBase, float instabilityExposed) {
        this(new BlockDescriptor(state), categories, instabilityBase, instabilityExposed);
    }

    public BlockStateBehavior(BlockDescriptor block, List<BlockCategory> categories, float instabilityBase, float instabilityExposed) {
        this.blockDescriptor = block;
        for (BlockCategory category : categories) {
            this.blockDescriptor.setUsable(category, true);
        }
        InstabilityBlockManager.setInstabilityFactors((IBlockState)this.blockDescriptor.blockstate, (float)instabilityExposed, (float)instabilityBase);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        ModifierUtils.pushBlock((AgeDirector)controller, (BlockDescriptor)this.blockDescriptor);
    }

    protected static IProperty parseProperty(IBlockState state, String propertyName) {
        Collection propertyCollection = state.func_177227_a();
        for (IProperty property : propertyCollection) {
            if (!property.func_177701_a().equals(propertyName)) continue;
            return property;
        }
        return null;
    }
}

