/*
 * Decompiled with CFR 0.152.
 */
package mystlibrary.symbol.util;

import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.api.world.logic.ICelestial;
import com.xcompwiz.mystcraft.api.world.logic.IEnvironmentalEffect;
import com.xcompwiz.mystcraft.api.world.logic.ILightingController;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.api.world.logic.Modifier;
import java.util.List;
import mystlibrary.MystLibrary;
import mystlibrary.dummy.AgeDirectorDummy;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;

public final class SymbolConverter {
    private SymbolConverter() {
    }

    public static Color toColor(IAgeSymbol symbol, boolean logFailure) {
        Color color;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            color = null;
            try {
                ageDirector.register(symbol);
                Modifier colorModifier = ageDirector.popModifier("color");
                if (colorModifier != null) {
                    color = colorModifier.asColor();
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return color;
    }

    public static Number toLength(IAgeSymbol symbol, boolean logFailure) {
        Number length;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            length = null;
            try {
                ageDirector.register(symbol);
                Modifier lengthModifier = ageDirector.popModifier("wavelength");
                if (lengthModifier != null) {
                    length = lengthModifier.asNumber();
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return length;
    }

    public static Number toDirection(IAgeSymbol symbol, boolean logFailure) {
        Number direction;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            direction = null;
            try {
                ageDirector.register(symbol);
                Modifier directionModifier = ageDirector.popModifier("angle");
                if (directionModifier != null) {
                    direction = directionModifier.asNumber();
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return direction;
    }

    public static Number toPhase(IAgeSymbol symbol, boolean logFailure) {
        Number phase;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            phase = null;
            try {
                ageDirector.register(symbol);
                Modifier phaseModifier = ageDirector.popModifier("phase");
                if (phaseModifier != null) {
                    phase = phaseModifier.asNumber();
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return phase;
    }

    public static IBlockState toBlockState(IAgeSymbol symbol, boolean logFailure) {
        IBlockState state;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            state = null;
            try {
                ageDirector.register(symbol);
                BlockDescriptor descriptor = ModifierUtils.popBlockMatching((AgeDirector)ageDirector, (BlockCategory[])new BlockCategory[]{BlockCategory.ANY});
                if (descriptor != null) {
                    state = descriptor.blockstate;
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return state;
    }

    public static Biome toBiome(IAgeSymbol symbol, boolean logFailure) {
        Biome biome;
        block3: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            biome = null;
            try {
                ageDirector.register(symbol);
                biome = ModifierUtils.popBiome((AgeDirector)ageDirector);
            }
            catch (Exception e) {
                if (!logFailure) break block3;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return biome;
    }

    public static ColorGradient toGradient(IAgeSymbol symbol, boolean logFailure) {
        ColorGradient gradient;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            gradient = null;
            try {
                ageDirector.register(symbol);
                gradient = ModifierUtils.popGradient((AgeDirector)ageDirector);
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        if (gradient.getLength() <= 0.0f) {
            return null;
        }
        return gradient;
    }

    public static ICelestial toCelestial(IAgeSymbol symbol, boolean logFailure) {
        ICelestial celestial;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            celestial = null;
            try {
                ageDirector.register(symbol);
                List<ICelestial> celestials = ageDirector.celestials;
                if (celestials.size() > 0) {
                    celestial = celestials.get(0);
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return celestial;
    }

    public static IBiomeController toBiomeController(IAgeSymbol symbol, boolean logFailure) {
        IBiomeController biomeController;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            biomeController = null;
            try {
                ageDirector.register(symbol);
                List<IBiomeController> biomeControllers = ageDirector.biomeControllers;
                if (biomeControllers.size() > 0) {
                    biomeController = biomeControllers.get(0);
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return biomeController;
    }

    public static IEnvironmentalEffect toEnvironmentalEffect(IAgeSymbol symbol, boolean logFailure) {
        IEnvironmentalEffect environmentalEffect;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            environmentalEffect = null;
            try {
                ageDirector.register(symbol);
                List<IEnvironmentalEffect> environmentalEffects = ageDirector.environmentalEffects;
                if (environmentalEffects.size() > 0) {
                    environmentalEffect = environmentalEffects.get(0);
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return environmentalEffect;
    }

    public static ILightingController toLightingController(IAgeSymbol symbol, boolean logFailure) {
        ILightingController lightingController;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            lightingController = null;
            try {
                ageDirector.register(symbol);
                List<ILightingController> lightingControllers = ageDirector.lightingControllers;
                if (lightingControllers.size() > 0) {
                    lightingController = lightingControllers.get(0);
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return lightingController;
    }

    public static IPopulate toPopulator(IAgeSymbol symbol, boolean logFailure) {
        IPopulate populator;
        block4: {
            if (symbol == null) {
                return null;
            }
            AgeDirectorDummy ageDirector = new AgeDirectorDummy();
            populator = null;
            try {
                ageDirector.register(symbol);
                List<IPopulate> populators = ageDirector.populators;
                if (populators.size() > 0) {
                    populator = populators.get(0);
                }
            }
            catch (Exception e) {
                if (!logFailure) break block4;
                MystLibrary.logger.warn((Object)e);
            }
        }
        return populator;
    }
}

