/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm;

import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.AccessTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;

public class ModAccessTransformerRemapper {
    private final Map<String, Map<String, String>> fieldMappings;
    private final Map<String, Map<String, String>> methodMappings;
    private final Field modifiersField;
    private Field modifierDesc;
    private Field modifierName;

    public ModAccessTransformerRemapper() {
        boolean wasAccessible;
        try {
            Field rawFieldMaps = FMLDeobfuscatingRemapper.class.getDeclaredField("rawFieldMaps");
            wasAccessible = rawFieldMaps.isAccessible();
            if (!wasAccessible) {
                rawFieldMaps.setAccessible(true);
            }
            this.fieldMappings = (Map)rawFieldMaps.get(FMLDeobfuscatingRemapper.INSTANCE);
            if (!wasAccessible) {
                rawFieldMaps.setAccessible(false);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Could not access rawFieldMaps of FMLDeobfuscatingRemapper", e);
        }
        try {
            Field rawMethodMaps = FMLDeobfuscatingRemapper.class.getDeclaredField("rawMethodMaps");
            wasAccessible = rawMethodMaps.isAccessible();
            if (!wasAccessible) {
                rawMethodMaps.setAccessible(true);
            }
            this.methodMappings = (Map)rawMethodMaps.get(FMLDeobfuscatingRemapper.INSTANCE);
            if (!wasAccessible) {
                rawMethodMaps.setAccessible(false);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Could not access rawMethodMaps of FMLDeobfuscatingRemapper", e);
        }
        try {
            this.modifiersField = AccessTransformer.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Could not access modifiers field of AccessTransformer", e);
        }
    }

    public void apply(IClassTransformer modAT) {
        Multimap<String, ?> modifiersMap = this.getModifiers(modAT);
        if (modifiersMap.isEmpty()) {
            return;
        }
        modifiersMap.forEach(this::applySingleModifier);
        if (this.modifierDesc != null) {
            this.modifierDesc.setAccessible(false);
            this.modifierDesc = null;
        }
        if (this.modifierName != null) {
            this.modifierName.setAccessible(false);
            this.modifierName = null;
        }
    }

    @Nonnull
    private Multimap<String, ?> getModifiers(IClassTransformer modAT) {
        Multimap modifiersMap;
        boolean wasAccessible = this.modifiersField.isAccessible();
        if (!wasAccessible) {
            this.modifiersField.setAccessible(true);
        }
        try {
            modifiersMap = (Multimap)this.modifiersField.get(modAT);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw new IllegalStateException("Could not access modifiers field of " + modAT, e);
        }
        finally {
            if (!wasAccessible) {
                this.modifiersField.setAccessible(false);
            }
        }
        return modifiersMap;
    }

    private void applySingleModifier(String className, Object modifier) {
        String desc;
        String name;
        String classKey = className.replaceAll("\\.", "/");
        try {
            name = this.getName(modifier);
            if (name.equals("*")) {
                return;
            }
            desc = this.getDesc(modifier);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return;
        }
        if (desc.isEmpty() && this.fieldMappings.containsKey(classKey)) {
            Map<String, String> classFieldMappings = this.fieldMappings.get(classKey);
            classFieldMappings.keySet().stream().filter(obfNameWithType -> obfNameWithType.startsWith(name + ":")).findAny().ifPresent(obfNameWithType -> {
                String newName = (String)classFieldMappings.get(obfNameWithType);
                System.out.printf("Remapping class %s field %s -> %s%n", className, name, newName);
                this.setName(modifier, newName);
            });
        } else if (this.methodMappings.containsKey(classKey)) {
            Map<String, String> classMethodMappings = this.methodMappings.get(classKey);
            classMethodMappings.keySet().stream().filter(obfNameWithType -> obfNameWithType.startsWith(name + "(") && obfNameWithType.endsWith(desc)).findAny().ifPresent(obfNameWithType -> {
                String newName = (String)classMethodMappings.get(obfNameWithType);
                System.out.printf("Remapping class %s method %s %s -> %s%n", className, name, desc, newName);
                this.setName(modifier, newName);
            });
        }
    }

    private String getDesc(Object modifier) {
        Objects.requireNonNull(modifier, "Modifier may not be null");
        this.ensureModifierDesc(modifier);
        try {
            return (String)this.modifierDesc.get(modifier);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access desc field", e);
        }
    }

    private void ensureModifierDesc(@Nonnull Object modifier) {
        if (this.modifierDesc == null) {
            try {
                this.modifierDesc = modifier.getClass().getDeclaredField("desc");
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Could not find desc field", e);
            }
        }
        if (!this.modifierDesc.isAccessible()) {
            this.modifierDesc.setAccessible(true);
        }
    }

    private String getName(Object modifier) {
        Objects.requireNonNull(modifier, "Modifier may not be null");
        this.ensureModifierName(modifier);
        try {
            return (String)this.modifierName.get(modifier);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access name field", e);
        }
    }

    private void setName(Object modifier, String newName) {
        Objects.requireNonNull(modifier, "Modifier may not be null");
        this.ensureModifierName(modifier);
        try {
            this.modifierName.set(modifier, newName);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access name field", e);
        }
    }

    private void ensureModifierName(@Nonnull Object modifier) {
        if (this.modifierName == null) {
            try {
                this.modifierName = modifier.getClass().getDeclaredField("name");
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Could not find name field", e);
            }
        }
        if (!this.modifierName.isAccessible()) {
            this.modifierName.setAccessible(true);
        }
    }
}

