/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.util.LinkedList;
import java.util.List;
import logisticspipes.config.Configs;
import logisticspipes.items.ItemModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.guis.pipe.ChassisGuiProvider;
import logisticspipes.network.packets.chassis.ChassisGUI;
import logisticspipes.network.packets.gui.GuiClosePacket;
import logisticspipes.network.packets.gui.OpenUpgradePacket;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.upgrades.ModuleUpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.module.Gui;

public class GuiChassisPipe
extends LogisticsBaseGuiScreen {
    private final PipeLogisticsChassis chassisPipe;
    private final IInventory _moduleInventory;
    private final List<SmallGuiButton> moduleConfigButtons = new LinkedList<SmallGuiButton>();
    private final Slot[] upgradeSlots = new Slot[2 * Configs.CHASSIS_SLOTS_ARRAY[4]];
    private GuiButton[] upgradeConfig;
    private final boolean hasUpgradeModuleUpgrade;

    public GuiChassisPipe(EntityPlayer player, PipeLogisticsChassis chassis, boolean hasUpgradeModuleUpgrade) {
        super(null);
        int i;
        this.chassisPipe = chassis;
        this._moduleInventory = chassis.getModuleInventory();
        this.hasUpgradeModuleUpgrade = hasUpgradeModuleUpgrade;
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, this._moduleInventory);
        dummy.addNormalSlotsForPlayerInventory(18, 9 + 20 * this.chassisPipe.getChassisSize());
        for (i = 0; i < this.chassisPipe.getChassisSize(); ++i) {
            dummy.addModuleSlot(i, this._moduleInventory, 18, 9 + 20 * i, this.chassisPipe);
        }
        if (hasUpgradeModuleUpgrade) {
            for (i = 0; i < this.chassisPipe.getChassisSize(); ++i) {
                int fI = i;
                ModuleUpgradeManager upgradeManager = this.chassisPipe.getModuleUpgradeManager(i);
                this.upgradeSlots[i * 2] = dummy.addUpgradeSlot(0, upgradeManager, 0, 145, 9 + i * 20, itemStack -> ChassisGuiProvider.checkStack(itemStack, this.chassisPipe, fI));
                this.upgradeSlots[i * 2 + 1] = dummy.addUpgradeSlot(1, upgradeManager, 1, 165, 9 + i * 20, itemStack -> ChassisGuiProvider.checkStack(itemStack, this.chassisPipe, fI));
            }
        }
        this.field_147002_h = dummy;
        int playerInventoryWidth = 162;
        int playerInventoryHeight = 76;
        this.field_146999_f = playerInventoryWidth + 26;
        this.field_147000_g = playerInventoryHeight + 14 + 20 * this.chassisPipe.getChassisSize();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int left = this.field_146294_l / 2 - this.field_146999_f / 2;
        int top = this.field_146295_m / 2 - this.field_147000_g / 2;
        this.field_146292_n.clear();
        this.moduleConfigButtons.clear();
        this.upgradeConfig = new GuiButton[this.chassisPipe.getChassisSize() * 2];
        for (int i = 0; i < this.chassisPipe.getChassisSize(); ++i) {
            this.moduleConfigButtons.add(this.func_189646_b(new SmallGuiButton(i, left + 5, top + 12 + 20 * i, 10, 10, "!")));
            if (this._moduleInventory == null) continue;
            this.updateModuleConfigButtonVisibility(i);
            if (!this.hasUpgradeModuleUpgrade) continue;
            this.upgradeConfig[i * 2] = this.func_189646_b(new SmallGuiButton(100 + i, this.field_147003_i + 134, this.field_147009_r + 12 + i * 20, 10, 10, "!"));
            this.upgradeConfig[i * 2].field_146125_m = this.chassisPipe.getModuleUpgradeManager(i).hasGuiUpgrade(0);
            this.upgradeConfig[i * 2 + 1] = this.func_189646_b(new SmallGuiButton(120 + i, this.field_147003_i + 182, this.field_147009_r + 12 + i * 20, 10, 10, "!"));
            this.upgradeConfig[i * 2 + 1].field_146125_m = this.chassisPipe.getModuleUpgradeManager(i).hasGuiUpgrade(1);
        }
    }

    private void updateModuleConfigButtonVisibility(int slot) {
        ItemStack module = this._moduleInventory.func_70301_a(slot);
        LogisticsModule subModule = this.chassisPipe.getSubModule(slot);
        this.moduleConfigButtons.get((int)slot).field_146125_m = module.func_190926_b() || subModule == null ? false : subModule instanceof Gui;
    }

    public void func_146281_b() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(GuiClosePacket.class).setTilePos(this.chassisPipe.container));
        super.func_146281_b();
    }

    protected void func_146284_a(GuiButton guibutton) {
        LogisticsModule module;
        if (guibutton.field_146127_k >= 0 && guibutton.field_146127_k <= this.chassisPipe.getChassisSize() && (module = this.chassisPipe.getSubModule(guibutton.field_146127_k)) != null) {
            CoordinatesPacket packet = PacketHandler.getPacket(ChassisGUI.class).setButtonID(guibutton.field_146127_k).setPosX(this.chassisPipe.getX()).setPosY(this.chassisPipe.getY()).setPosZ(this.chassisPipe.getZ());
            MainProxy.sendPacketToServer(packet);
        }
        for (int i = 0; i < this.upgradeConfig.length; ++i) {
            if (this.upgradeConfig[i] != guibutton) continue;
            MainProxy.sendPacketToServer(PacketHandler.getPacket(OpenUpgradePacket.class).setSlot(this.upgradeSlots[i]));
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        int i;
        super.func_146979_b(par1, par2);
        for (i = 0; i < this.chassisPipe.getChassisSize(); ++i) {
            this.updateModuleConfigButtonVisibility(i);
        }
        if (this.hasUpgradeModuleUpgrade) {
            for (i = 0; i < this.upgradeConfig.length; ++i) {
                this.upgradeConfig[i].field_146125_m = this.chassisPipe.getModuleUpgradeManager(i / 2).hasGuiUpgrade(i % 2);
            }
        }
        for (i = 0; i < this.chassisPipe.getChassisSize(); ++i) {
            this.field_146297_k.field_71466_p.func_78276_b(this.getModuleName(i), 40, 14 + 20 * i, 0x404040);
        }
    }

    private String getModuleName(int slot) {
        if (this._moduleInventory == null) {
            return "";
        }
        if (this._moduleInventory.func_70301_a(slot).func_190926_b()) {
            return "";
        }
        if (!(this._moduleInventory.func_70301_a(slot).func_77973_b() instanceof ItemModule)) {
            return "";
        }
        String name = this._moduleInventory.func_70301_a(slot).func_77973_b().func_77653_i(this._moduleInventory.func_70301_a(slot));
        if (!this.hasUpgradeModuleUpgrade) {
            return name;
        }
        return StringUtils.getWithMaxWidth(name, 100, this.field_146289_q);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        int i;
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
        for (i = 0; i < this.chassisPipe.getChassisSize(); ++i) {
            GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 17, this.field_147009_r + 8 + 20 * i);
        }
        GuiGraphics.drawPlayerInventoryBackground(this.field_146297_k, this.field_147003_i + 18, this.field_147009_r + 9 + 20 * this.chassisPipe.getChassisSize());
        if (this.hasUpgradeModuleUpgrade) {
            for (i = 0; i < this.chassisPipe.getChassisSize(); ++i) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 144, this.field_147009_r + 8 + i * 20);
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.field_147003_i + 164, this.field_147009_r + 8 + i * 20);
            }
        }
    }
}

