/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.kotlinx.serialization.internal;

import java.util.Arrays;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.PublishedApi;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.ranges.RangesKt;
import logisticspipes.kotlinx.serialization.internal.PrimitiveArrayBuilder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\r\u0010\u000f\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0090\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Llogisticspipes/kotlinx/serialization/internal/IntArrayBuilder;", "Llogisticspipes/kotlinx/serialization/internal/PrimitiveArrayBuilder;", "", "bufferWithData", "([I)V", "buffer", "<set-?>", "", "position", "getPosition$kotlinx_serialization_core", "()I", "append", "", "c", "append$kotlinx_serialization_core", "build", "build$kotlinx_serialization_core", "ensureCapacity", "requiredCapacity", "ensureCapacity$kotlinx_serialization_core", "logisticspipes.kotlinx-serialization-core"})
@PublishedApi
public final class IntArrayBuilder
extends PrimitiveArrayBuilder<int[]> {
    @NotNull
    private int[] buffer;
    private int position;

    public IntArrayBuilder(@NotNull int[] bufferWithData) {
        Intrinsics.checkNotNullParameter(bufferWithData, "bufferWithData");
        this.buffer = bufferWithData;
        this.position = bufferWithData.length;
        this.ensureCapacity$kotlinx_serialization_core(10);
    }

    @Override
    public int getPosition$kotlinx_serialization_core() {
        return this.position;
    }

    @Override
    public void ensureCapacity$kotlinx_serialization_core(int requiredCapacity) {
        if (this.buffer.length < requiredCapacity) {
            int[] nArray = Arrays.copyOf(this.buffer, RangesKt.coerceAtLeast(requiredCapacity, this.buffer.length * 2));
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
            this.buffer = nArray;
        }
    }

    public final void append$kotlinx_serialization_core(int c) {
        PrimitiveArrayBuilder.ensureCapacity$kotlinx_serialization_core$default(this, 0, 1, null);
        int n = this.getPosition$kotlinx_serialization_core();
        this.position = n + 1;
        this.buffer[n] = c;
    }

    @Override
    @NotNull
    public int[] build$kotlinx_serialization_core() {
        int[] nArray = Arrays.copyOf(this.buffer, this.getPosition$kotlinx_serialization_core());
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(this, newSize)");
        return nArray;
    }
}

