/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.modules.HUDStringBasedItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IStringBasedModule;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.StringBasedItemSinkModuleGuiInHand;
import logisticspipes.network.guis.module.inpipe.StringBasedItemSinkModuleGuiSlot;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleBasedItemSinkList;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.property.Property;
import network.rs485.logisticspipes.property.StringListProperty;

public class ModuleCreativeTabBasedItemSink
extends LogisticsModule
implements IStringBasedModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
Gui {
    public final StringListProperty tabList = new StringListProperty("");
    private final IHUDModuleRenderer HUD = new HUDStringBasedItemSink(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private SinkReply _sinkReply;

    public static String getName() {
        return "item_sink_creativetab";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModuleCreativeTabBasedItemSink.getName();
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return Collections.singletonList(this.tabList);
    }

    @Override
    public void registerPosition(@Nonnull LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ModBasedItemSink, 0, true, false, 5, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return null;
        }
        if (this.tabList.contains(item.getCreativeTabName()) && service.canUseEnergy(5)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < this.tabList.size(); ++i) {
            String val;
            String key = "Mod" + i;
            if (!tag.func_74764_b(key) || (val = tag.func_74779_i(key)).isEmpty()) continue;
            this.tabList.set(i, val);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mods: ");
        list.addAll(this.tabList);
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleBasedItemSinkList.class).setNbt(nbt).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void listChanged() {
        IWorldProvider worldProvider = this._world;
        if (worldProvider == null) {
            return;
        }
        if (MainProxy.isServer((IBlockAccess)worldProvider.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleBasedItemSinkList.class).setNbt(nbt).setModulePos(this), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(PacketHandler.getPacket(ModuleBasedItemSinkList.class).setNbt(nbt).setModulePos(this));
        }
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean receivePassive() {
        return true;
    }

    @Override
    public StringListProperty stringListProperty() {
        return this.tabList;
    }

    @Override
    public String getStringForItem(ItemIdentifier ident) {
        return ident.getCreativeTabName();
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return NewGuiHandler.getGui(StringBasedItemSinkModuleGuiSlot.class).setNbt(nbt);
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(StringBasedItemSinkModuleGuiInHand.class);
    }
}

