/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.modules.HUDSimpleFilterModule;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.inventory.IItemIdentifierInventory;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.module.SimpleFilter;
import network.rs485.logisticspipes.property.ItemIdentifierInventoryProperty;
import network.rs485.logisticspipes.property.Property;

@CCType(name="EnchantmentSink Module MK2")
public class ModuleEnchantmentSinkMK2
extends LogisticsModule
implements SimpleFilter,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive,
Gui {
    public final ItemIdentifierInventoryProperty filterInventory = new ItemIdentifierInventoryProperty(new ItemIdentifierInventory(9, "Requested Enchanted items", 1), "");
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final IHUDModuleRenderer HUD = new HUDSimpleFilterModule(this);
    private SinkReply _sinkReply;

    public ModuleEnchantmentSinkMK2() {
        this.filterInventory.addListener(this);
    }

    public static String getName() {
        return "enchantment_sink_mk2";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModuleEnchantmentSinkMK2.getName();
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return Collections.singletonList(this.filterInventory);
    }

    @Override
    @CCCommand(description="Returns the FilterInventory of this Module")
    @Nonnull
    public IItemIdentifierInventory getFilterInventory() {
        return this.filterInventory;
    }

    @Override
    public void registerPosition(@Nonnull LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.EnchantmentItemSink, 1, true, false, 1, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        if (this.filterInventory.containsExcludeNBTItem(item.getUndamaged().getIgnoringNBT())) {
            if (stack.func_77948_v()) {
                return this._sinkReply;
            }
            return null;
        }
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(this.filterInventory)).setModulePos(this), player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        MainProxy.runOnServer((IBlockAccess)this.getWorld(), () -> () -> MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ModuleInventory.class).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setModulePos(this), this.localModeWatchers));
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(@Nonnull Collection<ItemIdentifierStack> list) {
        this.filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemIdentifiers) {
        Map<ItemIdentifier, Integer> mapIC = this.filterInventory.getItemsAndCount();
        itemIdentifiers.addAll(mapIC.keySet());
        for (ItemIdentifier id : mapIC.keySet()) {
            itemIdentifiers.add(id.getUndamaged());
            itemIdentifiers.add(id.getUndamaged().getIgnoringNBT());
        }
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean receivePassive() {
        return true;
    }

    @Override
    public boolean hasEffect() {
        return true;
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return SimpleFilter.getPipeGuiProvider();
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return SimpleFilter.getInHandGuiProvider();
    }
}

