/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.pipe;

import java.util.Objects;
import java.util.UUID;
import logisticspipes.LPItems;
import logisticspipes.gui.GuiPipeController;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgradeConfig;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

@StaticResolve
public class PipeController
extends CoordinatesGuiProvider {
    public PipeController(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getTileAs(player.field_70170_p, LogisticsTileGenericPipe.class);
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        return new GuiPipeController(player, (CoreRoutedPipe)pipe.pipe);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        int pipeSlot;
        LogisticsTileGenericPipe tile = this.getTileAs(player.field_70170_p, LogisticsTileGenericPipe.class);
        if (!(tile.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        final CoreRoutedPipe pipe = (CoreRoutedPipe)tile.pipe;
        DummyContainer dummy = new DummyContainer(player, null, pipe.getOriginalUpgradeManager().getGuiController(), new IGuiOpenControler(){

            @Override
            public void guiOpenedByPlayer(EntityPlayer player) {
                pipe.playerStartWatching(player, 0);
            }

            @Override
            public void guiClosedByPlayer(EntityPlayer player) {
                pipe.playerStopWatching(player, 0);
            }
        });
        dummy.addNormalSlotsForPlayerInventory(0, 0);
        for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            dummy.addUpgradeSlot(pipeSlot, pipe.getOriginalUpgradeManager(), pipeSlot, 8 + pipeSlot * 18, 18, itemStack -> !itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemUpgrade && ((ItemUpgrade)itemStack.func_77973_b()).getUpgradeForItem(itemStack, null).isAllowedForPipe(pipe));
        }
        for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            dummy.addSneakyUpgradeSlot(pipeSlot, pipe.getOriginalUpgradeManager(), pipeSlot + 9, 8 + pipeSlot * 18, 48, itemStack -> {
                if (itemStack.func_190926_b()) {
                    return false;
                }
                if (itemStack.func_77973_b() instanceof ItemUpgrade) {
                    IPipeUpgrade upgrade = ((ItemUpgrade)itemStack.func_77973_b()).getUpgradeForItem(itemStack, null);
                    return upgrade instanceof SneakyUpgradeConfig && upgrade.isAllowedForPipe(pipe);
                }
                return false;
            });
        }
        dummy.addStaticRestrictedSlot(0, (IInventory)pipe.getOriginalUpgradeManager().secInv, 152, 18, itemStack -> {
            if (itemStack.func_190926_b()) {
                return false;
            }
            if (itemStack.func_77973_b() != LPItems.itemCard) {
                return false;
            }
            if (itemStack.func_77952_i() != 1) {
                return false;
            }
            NBTTagCompound tag = Objects.requireNonNull(itemStack.func_77978_p());
            return SimpleServiceLocator.securityStationManager.isAuthorized(UUID.fromString(tag.func_74779_i("UUID")));
        }, 1);
        dummy.addRestrictedSlot(0, (IInventory)tile.logicController.diskInv, 14, 36, LPItems.disk);
        return dummy;
    }

    @Override
    public GuiProvider template() {
        return new PipeController(this.getId());
    }
}

