/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.UUID;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.abstractpackets.IntegerModuleCoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CraftingPipeSetSatellitePacket
extends IntegerModuleCoordinatesPacket {
    private UUID pipeID;

    public CraftingPipeSetSatellitePacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.pipeID = input.readUUID();
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeUUID(this.pipeID);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ModuleCrafter module = this.getLogisticsModule(player, ModuleCrafter.class);
        if (module == null) {
            return;
        }
        if (this.getInteger() == 0) {
            module.setSatelliteUUID(this.getPipeID());
        } else if (this.getInteger() >= 10 && this.getInteger() < 20) {
            module.setAdvancedSatelliteUUID(this.getInteger() - 10, this.getPipeID());
        } else if (this.getInteger() == 100) {
            module.setFluidSatelliteUUID(this.getPipeID());
        } else if (this.getInteger() >= 110 && this.getInteger() <= 120) {
            module.setAdvancedFluidSatelliteUUID(this.getInteger() - 110, this.getPipeID());
        }
    }

    @Override
    public ModernPacket template() {
        return new CraftingPipeSetSatellitePacket(this.getId());
    }

    public UUID getPipeID() {
        return this.pipeID;
    }

    public CraftingPipeSetSatellitePacket setPipeID(UUID pipeID) {
        this.pipeID = pipeID;
        return this;
    }
}

