/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LPItems;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IClientState;
import logisticspipes.interfaces.ILPPositionProvider;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IPipeUpgradeManager;
import logisticspipes.interfaces.IQueueCCEvent;
import logisticspipes.interfaces.ISecurityProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.ISpawnParticles;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.IWatchingHandler;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.ItemPipeSignCreator;
import logisticspipes.kotlin.Unit;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.ITrackStatistics;
import logisticspipes.logisticspipes.PipeTransportLayer;
import logisticspipes.logisticspipes.RouteLayer;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.pipe.PipeController;
import logisticspipes.network.packets.pipe.ParticleFX;
import logisticspipes.network.packets.pipe.PipeSignTypes;
import logisticspipes.network.packets.pipe.RequestSignPacket;
import logisticspipes.network.packets.pipe.StatUpdate;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.PowerSupplierHandler;
import logisticspipes.pipes.basic.debug.DebugLogController;
import logisticspipes.pipes.basic.debug.StatusEntry;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCDirectCall;
import logisticspipes.proxy.computers.interfaces.CCSecurtiyCheck;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.renderer.LogisticsRenderPipe;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrderManager;
import logisticspipes.routing.order.LogisticsOrderManager;
import logisticspipes.security.PermissionException;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.EnumFacingUtil;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.Adjacent;
import network.rs485.logisticspipes.connection.AdjacentFactory;
import network.rs485.logisticspipes.connection.NoAdjacent;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.property.PropertyHolder;
import network.rs485.logisticspipes.property.UtilKt;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

@CCType(name="LogisticsPipes:Normal")
public abstract class CoreRoutedPipe
extends CoreUnroutedPipe
implements IClientState,
IRequestItems,
ITrackStatistics,
IWorldProvider,
IWatchingHandler,
IPipeServiceProvider,
IQueueCCEvent,
ILPPositionProvider {
    private static int pipecount = 0;
    public final PlayerCollectionList watchers = new PlayerCollectionList();
    protected final PriorityBlockingQueue<ItemRoutingInformation> _inTransitToMe = new PriorityBlockingQueue<ItemRoutingInformation>(10, new ItemRoutingInformation.DelayComparator());
    protected final LinkedList<Triplet<IRoutedItem, EnumFacing, ItemSendMode>> _sendQueue = new LinkedList();
    protected final Map<ItemIdentifier, Queue<Pair<Integer, ItemRoutingInformation>>> queuedDataForUnroutedItems = Collections.synchronizedMap(new TreeMap());
    public boolean _textureBufferPowered;
    public long delayTo = 0L;
    public int repeatFor = 0;
    public int stat_session_sent;
    public int stat_session_recieved;
    public int stat_session_relayed;
    public long stat_lifetime_sent;
    public long stat_lifetime_recieved;
    public long stat_lifetime_relayed;
    public int server_routing_table_size = 0;
    protected boolean stillNeedReplace = true;
    protected IRouter router;
    protected String routerId;
    protected final Object routerIdLock = new Object();
    protected int _delayOffset;
    protected boolean _initialInit = true;
    protected RouteLayer _routeLayer;
    protected TransportLayer _transportLayer;
    @Nonnull
    protected final UpgradeManager upgradeManager = new UpgradeManager(this);
    protected LogisticsItemOrderManager _orderItemManager = null;
    protected int throttleTime = 20;
    protected IPipeSign[] signItem = new IPipeSign[6];
    private boolean recheckConnections = false;
    private boolean enabled = true;
    private boolean preventRemove = false;
    private boolean destroyByPlayer = false;
    private final PowerSupplierHandler powerHandler = new PowerSupplierHandler(this);
    private final List<IOrderInfoProvider> clientSideOrderManager = new ArrayList<IOrderInfoProvider>();
    private int throttleTimeLeft = 20 + new Random().nextInt(Configs.LOGISTICS_DETECTION_FREQUENCY);
    private final int[] queuedParticles = new int[Particles.values().length];
    private boolean hasQueuedParticles = false;
    private boolean isOpaqueClientSide = false;
    @Nonnull
    private Adjacent adjacent = NoAdjacent.INSTANCE;
    private CacheHolder cacheHolder;

    @Nonnull
    protected Adjacent getAdjacent() {
        return this.adjacent;
    }

    @Override
    @Nonnull
    public Adjacent getAvailableAdjacent() {
        return this.getAdjacent();
    }

    @Override
    @Nullable
    public EnumFacing getPointedOrientation() {
        return null;
    }

    @Override
    protected void updateAdjacentCache() {
        this.adjacent = AdjacentFactory.INSTANCE.createAdjacentCache(this);
    }

    public CoreRoutedPipe(Item item) {
        this(new PipeTransportLogistics(true), item);
    }

    public CoreRoutedPipe(PipeTransportLogistics transport, Item item) {
        super(transport, item);
        this._delayOffset = ++pipecount % Configs.LOGISTICS_DETECTION_FREQUENCY;
    }

    @Override
    public void markTileDirty() {
        if (this.container != null) {
            this.container.func_70296_d();
        }
    }

    @Nonnull
    public RouteLayer getRouteLayer() {
        if (this._routeLayer == null) {
            this._routeLayer = new RouteLayer(this.getRouter(), this.getTransportLayer(), this);
        }
        return this._routeLayer;
    }

    @Nonnull
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new PipeTransportLayer(this, this, this.getRouter());
        }
        return this._transportLayer;
    }

    @Override
    @Nonnull
    public ISlotUpgradeManager getUpgradeManager(LogisticsModule.ModulePositionType slot, int positionInt) {
        return this.upgradeManager;
    }

    @Override
    public IPipeUpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public UpgradeManager getOriginalUpgradeManager() {
        return this.upgradeManager;
    }

    @Override
    public void queueRoutedItem(IRoutedItem routedItem, EnumFacing from) {
        if (from == null) {
            throw new NullPointerException();
        }
        this._sendQueue.addLast(new Triplet<IRoutedItem, EnumFacing, ItemSendMode>(routedItem, from, ItemSendMode.Normal));
        this.sendQueueChanged(false);
    }

    public void queueRoutedItem(IRoutedItem routedItem, @Nonnull EnumFacing from, ItemSendMode mode) {
        if (from == null) {
            throw new NullPointerException();
        }
        this._sendQueue.addLast(new Triplet<IRoutedItem, EnumFacing, ItemSendMode>(routedItem, from, mode));
        this.sendQueueChanged(false);
    }

    public int sendQueueChanged(boolean force) {
        return 0;
    }

    private void sendRoutedItem(IRoutedItem routedItem, EnumFacing from) {
        CoreRoutedPipe pipe;
        if (from == null) {
            throw new NullPointerException();
        }
        this.transport.injectItem(routedItem, from.func_176734_d());
        ServerRouter r = SimpleServiceLocator.routerManager.getServerRouter(routedItem.getDestination());
        if (r != null && (pipe = r.getCachedPipe()) != null) {
            pipe.notifyOfSend(routedItem.getInfo());
        }
        this.spawnParticle(Particles.OrangeParticle, 2);
        ++this.stat_lifetime_sent;
        ++this.stat_session_sent;
        this.updateStats();
    }

    private void notifyOfSend(ItemRoutingInformation routedItem) {
        this._inTransitToMe.add(routedItem);
    }

    public void notifyOfReroute(ItemRoutingInformation routedItem) {
        this._inTransitToMe.remove(routedItem);
    }

    public void refreshItem(ItemRoutingInformation routedItem) {
        if (this._inTransitToMe.contains(routedItem)) {
            this._inTransitToMe.remove(routedItem);
            this._inTransitToMe.add(routedItem);
        }
    }

    public abstract ItemSendMode getItemSendMode();

    public boolean isOnSameContainer(CoreRoutedPipe other) {
        return this.adjacent.connectedPos().keySet().stream().anyMatch(other.adjacent.connectedPos().keySet()::contains);
    }

    public void firstInitialiseTick() {
        this.getRouter();
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestSignPacket.class).setTilePos(this.container));
        }
    }

    public void enabledUpdateEntity() {
        this.powerHandler.update();
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null) continue;
            this.signItem[i].updateServerSide();
        }
    }

    public void ignoreDisableUpdateEntity() {
    }

    @Override
    public final void updateEntity() {
        boolean doFullRefresh;
        this.debug.tick();
        this.spawnParticleTick();
        if (this.stillNeedReplace) {
            this.stillNeedReplace = false;
            this.firstInitialiseTick();
            return;
        }
        if (this.repeatFor > 0 && this.delayTo < System.currentTimeMillis()) {
            this.delayTo = System.currentTimeMillis() + 200L;
            --this.repeatFor;
            this.getWorld().func_175685_c(this.getPos(), this.getWorld().func_180495_p(this.getPos()).func_177230_c(), true);
        }
        while (this._inTransitToMe.peek() != null && this._inTransitToMe.peek().getTickToTimeOut() <= 0L) {
            ItemRoutingInformation polledInfo = this._inTransitToMe.poll();
            if (polledInfo == null) continue;
            if (LogisticsPipes.isDEBUG()) {
                LogisticsPipes.log.info("Timed Out: " + polledInfo.getItem().getFriendlyName() + " (" + polledInfo.hashCode() + ")");
            }
            this.debug.log("Timed Out: " + polledInfo.getItem().getFriendlyName() + " (" + polledInfo.hashCode() + ")");
        }
        boolean bl = doFullRefresh = this.getWorld().func_82737_E() % (long)Configs.LOGISTICS_DETECTION_FREQUENCY == (long)this._delayOffset || this._initialInit || this.recheckConnections;
        if (doFullRefresh) {
            this.updateAdjacentCache();
        }
        this.getRouter().update(doFullRefresh, this);
        this.recheckConnections = false;
        this.getOriginalUpgradeManager().securityTick();
        super.updateEntity();
        if (this.isNthTick(200)) {
            this.getCacheHolder().trigger(null);
        }
        if (--this.throttleTimeLeft <= 0) {
            this.throttledUpdateEntity();
            this.throttleTimeLeft = this.throttleTime;
        }
        this.ignoreDisableUpdateEntity();
        this._initialInit = false;
        if (!this._sendQueue.isEmpty()) {
            if (this.getItemSendMode() == ItemSendMode.Normal) {
                Triplet<IRoutedItem, EnumFacing, ItemSendMode> itemToSend = this._sendQueue.getFirst();
                this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (EnumFacing)itemToSend.getValue2());
                this._sendQueue.removeFirst();
                for (int i = 0; i < 16 && !this._sendQueue.isEmpty() && this._sendQueue.getFirst().getValue3() == ItemSendMode.Fast; ++i) {
                    if (this._sendQueue.isEmpty()) continue;
                    itemToSend = this._sendQueue.getFirst();
                    this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (EnumFacing)itemToSend.getValue2());
                    this._sendQueue.removeFirst();
                }
                this.sendQueueChanged(false);
            } else if (this.getItemSendMode() == ItemSendMode.Fast) {
                for (int i = 0; i < 16; ++i) {
                    if (this._sendQueue.isEmpty()) continue;
                    Triplet<IRoutedItem, EnumFacing, ItemSendMode> itemToSend = this._sendQueue.getFirst();
                    this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (EnumFacing)itemToSend.getValue2());
                    this._sendQueue.removeFirst();
                }
                this.sendQueueChanged(false);
            } else {
                if (this.getItemSendMode() == null) {
                    throw new UnsupportedOperationException("getItemSendMode() can't return null. " + this.getClass().getName());
                }
                throw new UnsupportedOperationException("getItemSendMode() returned unhandled value. " + this.getItemSendMode().name() + " in " + this.getClass().getName());
            }
        }
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        this.checkTexturePowered();
        if (!this.isEnabled()) {
            return;
        }
        this.enabledUpdateEntity();
        if (this.getLogisticsModule() == null) {
            return;
        }
        this.getLogisticsModule().tick();
    }

    protected void onAllowedRemoval() {
    }

    public void throttledUpdateEntity() {
    }

    protected void delayThrottle() {
        if (this.throttleTimeLeft < 7) {
            this.throttleTimeLeft = 7;
        }
    }

    @Override
    public boolean isNthTick(int n) {
        return (this.getWorld().func_82737_E() + (long)this._delayOffset) % (long)n == 0L;
    }

    /*
     * WARNING - void declaration
     */
    private void doDebugStuff(EntityPlayer entityplayer) {
        void var5_11;
        if (!MainProxy.isServer((IBlockAccess)entityplayer.field_70170_p)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ServerRouter router = (ServerRouter)this.getRouter();
        sb.append("***\n");
        sb.append("---------Interests---------------\n");
        ServerRouter.forEachGlobalSpecificInterest((itemIdentifier, serverRouters) -> {
            sb.append(itemIdentifier.getFriendlyName()).append(":");
            for (IRouter j : serverRouters) {
                sb.append(j.getSimpleID()).append(",");
            }
            sb.append('\n');
        });
        sb.append("ALL ITEMS:");
        for (IRouter iRouter : ServerRouter.getInterestedInGeneral()) {
            sb.append(iRouter.getSimpleID()).append(",");
        }
        sb.append('\n');
        sb.append(router).append('\n');
        sb.append("---------CONNECTED TO---------------\n");
        for (CoreRoutedPipe coreRoutedPipe : router._adjacent.keySet()) {
            sb.append(coreRoutedPipe.getRouter().getSimpleID()).append('\n');
        }
        sb.append('\n');
        sb.append("========DISTANCE TABLE==============\n");
        for (ExitRoute exitRoute : router.getIRoutersByCost()) {
            sb.append(exitRoute.destination.getSimpleID()).append(" @ ").append(exitRoute.distanceToDestination).append(" -> ").append(exitRoute.connectionDetails).append("(").append(exitRoute.destination.getId()).append(")").append('\n');
        }
        sb.append('\n');
        sb.append("*******EXIT ROUTE TABLE*************\n");
        List<List<ExitRoute>> table = router.getRouteTable();
        boolean bl = false;
        while (var5_11 < table.size()) {
            if (table.get((int)var5_11) != null && table.get((int)var5_11).size() > 0) {
                sb.append((int)var5_11).append(" -> ").append(table.get((int)var5_11).get((int)0).destination.getSimpleID()).append('\n');
                for (ExitRoute route : table.get((int)var5_11)) {
                    sb.append("\t\t via ").append(route.exitOrientation).append("(").append(route.distanceToDestination).append(" distance)").append('\n');
                }
            }
            ++var5_11;
        }
        sb.append('\n');
        sb.append("++++++++++CONNECTIONS+++++++++++++++\n");
        sb.append(Arrays.toString(EnumFacing.field_82609_l)).append('\n');
        sb.append(Arrays.toString(router.sideDisconnected)).append('\n');
        if (this.container != null) {
            sb.append(Arrays.toString(this.container.pipeConnectionsBuffer)).append('\n');
        }
        sb.append("+++++++++++++ADJACENT+++++++++++++++\n");
        sb.append(this.adjacent).append('\n');
        sb.append("pointing: ").append(this.getPointedOrientation()).append('\n');
        sb.append("~~~~~~~~~~~~~~~POWER~~~~~~~~~~~~~~~~\n");
        sb.append(router.getPowerProvider()).append('\n');
        sb.append("~~~~~~~~~~~SUBSYSTEMPOWER~~~~~~~~~~~\n");
        sb.append(router.getSubSystemPowerProvider()).append('\n');
        if (this._orderItemManager != null) {
            sb.append("################ORDERDUMP#################\n");
            this._orderItemManager.dump(sb);
        }
        sb.append("################END#################\n");
        this.refreshConnectionAndRender(true);
        System.out.print(sb);
        router.CreateRouteTable(Integer.MAX_VALUE);
    }

    @Override
    public final void onBlockRemoval() {
        try {
            this.onAllowedRemoval();
            super.onBlockRemoval();
            pipecount = Math.max(pipecount - 1, 0);
            if (this.transport != null) {
                this.transport.dropBuffer();
            }
            this.getOriginalUpgradeManager().dropUpgrades();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.router != null) {
            this.router.destroy();
            this.router = null;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.router != null) {
            this.router.clearPipeCache();
            this.router.clearInterests();
        }
    }

    public void checkTexturePowered() {
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return;
        }
        if (!this.isNthTick(10)) {
            return;
        }
        if (this.stillNeedReplace || this._initialInit || this.router == null) {
            return;
        }
        boolean flag = this.canUseEnergy(1);
        if (flag != this._textureBufferPowered) {
            this._textureBufferPowered = flag;
            this.refreshRender(false);
            this.spawnParticle(Particles.RedParticle, 3);
        }
    }

    @Override
    public int getTextureIndex() {
        return this.getCenterTexture().newTexture;
    }

    public abstract Textures.TextureType getCenterTexture();

    public Textures.TextureType getTextureType(EnumFacing connection) {
        if (this.stillNeedReplace || this._initialInit) {
            return this.getCenterTexture();
        }
        if (connection == null) {
            return this.getCenterTexture();
        }
        if (this.router != null && this.getRouter().isRoutedExit(connection)) {
            return this.getRoutedTexture(connection);
        }
        Textures.TextureType texture = this.getNonRoutedTexture(connection);
        if (this.getUpgradeManager().hasRFPowerSupplierUpgrade() || this.getUpgradeManager().getIC2PowerLevel() > 0) {
            if (texture.fileName.equals(Textures.LOGISTICSPIPE_NOTROUTED_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_NOTROUTED_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_LIQUID_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_LIQUID_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_POWERED_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_POWERED_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_NOTROUTED_POWERED_TEXTURE;
            } else if (texture.fileName.equals(Textures.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE.fileName)) {
                texture = Textures.LOGISTICSPIPE_DIRECTION_POWERED_TEXTURE;
            } else {
                System.out.println("Unknown texture to power, :" + texture.fileName);
                System.out.println(this.getClass());
                System.out.println(connection);
            }
        }
        return texture;
    }

    public Textures.TextureType getRoutedTexture(EnumFacing connection) {
        if (this.getRouter().isSubPoweredExit(connection)) {
            return Textures.LOGISTICSPIPE_SUBPOWER_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_ROUTED_TEXTURE;
    }

    public Textures.TextureType getNonRoutedTexture(EnumFacing connection) {
        if (this.isPowerProvider(connection)) {
            return Textures.LOGISTICSPIPE_POWERED_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_NOTROUTED_TEXTURE;
    }

    @Override
    public void spawnParticle(Particles particle, int amount) {
        if (!Configs.ENABLE_PARTICLE_FX) {
            return;
        }
        int n = particle.ordinal();
        this.queuedParticles[n] = this.queuedParticles[n] + amount;
        this.hasQueuedParticles = true;
    }

    private void spawnParticleTick() {
        if (!this.hasQueuedParticles) {
            return;
        }
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            ArrayList<ISpawnParticles.ParticleCount> tosend = new ArrayList<ISpawnParticles.ParticleCount>(this.queuedParticles.length);
            for (int i = 0; i < this.queuedParticles.length; ++i) {
                if (this.queuedParticles[i] <= 0) continue;
                tosend.add(new ISpawnParticles.ParticleCount(Particles.values()[i], this.queuedParticles[i]));
            }
            MainProxy.sendPacketToAllWatchingChunk(this.container, (ModernPacket)PacketHandler.getPacket(ParticleFX.class).setParticles(tosend).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
        } else if (Minecraft.func_71375_t()) {
            for (int i = 0; i < this.queuedParticles.length; ++i) {
                if (this.queuedParticles[i] <= 0) continue;
                PipeFXRenderHandler.spawnGenericParticle(Particles.values()[i], this.getX(), this.getY(), this.getZ(), this.queuedParticles[i]);
            }
        }
        Arrays.fill(this.queuedParticles, 0);
        this.hasQueuedParticles = false;
    }

    protected boolean isPowerProvider(@Nullable EnumFacing direction) {
        if (direction == null) {
            return false;
        }
        TileEntity tilePipe = this.container.getTile(direction);
        if (tilePipe == null || !this.container.canPipeConnect(tilePipe, direction)) {
            return false;
        }
        return tilePipe instanceof ILogisticsPowerProvider || tilePipe instanceof ISubSystemPowerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            if (this.routerId == null || this.routerId.isEmpty()) {
                this.routerId = this.router != null ? this.router.getId().toString() : UUID.randomUUID().toString();
            }
        }
        nbttagcompound.func_74778_a("routerId", this.routerId);
        nbttagcompound.func_74772_a("stat_lifetime_sent", this.stat_lifetime_sent);
        nbttagcompound.func_74772_a("stat_lifetime_recieved", this.stat_lifetime_recieved);
        nbttagcompound.func_74772_a("stat_lifetime_relayed", this.stat_lifetime_relayed);
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().writeToNBT(nbttagcompound);
        }
        NBTTagCompound upgradeNBT = new NBTTagCompound();
        this.upgradeManager.writeToNBT(upgradeNBT);
        nbttagcompound.func_74782_a("upgradeManager", (NBTBase)upgradeNBT);
        NBTTagCompound powerNBT = new NBTTagCompound();
        this.powerHandler.writeToNBT(powerNBT);
        if (!powerNBT.func_82582_d()) {
            nbttagcompound.func_74782_a("powerHandler", (NBTBase)powerNBT);
        }
        NBTTagList sendqueue = new NBTTagList();
        for (Triplet triplet : this._sendQueue) {
            NBTTagCompound tagentry = new NBTTagCompound();
            NBTTagCompound tagentityitem = new NBTTagCompound();
            ((IRoutedItem)triplet.getValue1()).writeToNBT(tagentityitem);
            tagentry.func_74782_a("entityitem", (NBTBase)tagentityitem);
            tagentry.func_74774_a("from", (byte)((EnumFacing)triplet.getValue2()).ordinal());
            tagentry.func_74774_a("mode", (byte)((ItemSendMode)((Object)triplet.getValue3())).ordinal());
            sendqueue.func_74742_a((NBTBase)tagentry);
        }
        nbttagcompound.func_74782_a("sendqueue", (NBTBase)sendqueue);
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] != null) {
                nbttagcompound.func_74757_a("PipeSign_" + i, true);
                int n = -1;
                List<Class<? extends IPipeSign>> typeClasses = ItemPipeSignCreator.signTypes;
                for (int j = 0; j < typeClasses.size(); ++j) {
                    if (typeClasses.get(j) != this.signItem[i].getClass()) continue;
                    n = j;
                    break;
                }
                nbttagcompound.func_74768_a("PipeSign_" + i + "_type", n);
                NBTTagCompound tag = new NBTTagCompound();
                this.signItem[i].writeToNBT(tag);
                nbttagcompound.func_74782_a("PipeSign_" + i + "_tags", (NBTBase)tag);
                continue;
            }
            nbttagcompound.func_74757_a("PipeSign_" + i, false);
        }
        if (this instanceof PropertyHolder) {
            PropertyHolder.writeToNBT(nbttagcompound, (PropertyHolder)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            this.routerId = nbttagcompound.func_74779_i("routerId");
        }
        this.stat_lifetime_sent = nbttagcompound.func_74763_f("stat_lifetime_sent");
        this.stat_lifetime_recieved = nbttagcompound.func_74763_f("stat_lifetime_recieved");
        this.stat_lifetime_relayed = nbttagcompound.func_74763_f("stat_lifetime_relayed");
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().readFromNBT(nbttagcompound);
        }
        this.upgradeManager.readFromNBT(nbttagcompound.func_74775_l("upgradeManager"));
        this.powerHandler.readFromNBT(nbttagcompound.func_74775_l("powerHandler"));
        this._sendQueue.clear();
        NBTTagList sendqueue = nbttagcompound.func_150295_c("sendqueue", (int)nbttagcompound.func_74732_a());
        for (i = 0; i < sendqueue.func_74745_c(); ++i) {
            NBTTagCompound tagentry = sendqueue.func_150305_b(i);
            NBTTagCompound tagentityitem = tagentry.func_74775_l("entityitem");
            LPTravelingItem.LPTravelingItemServer item = new LPTravelingItem.LPTravelingItemServer(tagentityitem);
            EnumFacing from = EnumFacing.values()[tagentry.func_74771_c("from")];
            ItemSendMode mode = ItemSendMode.values()[tagentry.func_74771_c("mode")];
            this._sendQueue.add(new Triplet<LPTravelingItem.LPTravelingItemServer, EnumFacing, ItemSendMode>(item, from, mode));
        }
        for (i = 0; i < 6; ++i) {
            if (!nbttagcompound.func_74767_n("PipeSign_" + i)) continue;
            int type = nbttagcompound.func_74762_e("PipeSign_" + i + "_type");
            Class<? extends IPipeSign> typeClass = ItemPipeSignCreator.signTypes.get(type);
            try {
                this.signItem[i] = typeClass.newInstance();
                this.signItem[i].init(this, EnumFacingUtil.getOrientation(i));
                this.signItem[i].readFromNBT(nbttagcompound.func_74775_l("PipeSign_" + i + "_tags"));
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        if (this instanceof PropertyHolder) {
            PropertyHolder.readFromNBT(nbttagcompound, (PropertyHolder)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public IRouter getRouter() {
        if (this.stillNeedReplace) {
            System.out.format("Hey, don't get routers for pipes that aren't ready (%d, %d, %d, '%s')", this.getX(), this.getY(), this.getZ(), this.getWorld().func_72912_H().func_76065_j());
            new Throwable().printStackTrace();
        }
        if (this.router == null) {
            Object object = this.routerIdLock;
            synchronized (object) {
                UUID routerIntId = null;
                if (this.routerId != null && !this.routerId.isEmpty()) {
                    routerIntId = UUID.fromString(this.routerId);
                }
                this.router = SimpleServiceLocator.routerManager.getOrCreateRouter(routerIntId, this.getWorld(), this.getX(), this.getY(), this.getZ());
            }
        }
        return this.router;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @CCCommand(description="Returns the Internal LogisticsModule for this pipe")
    @Nullable
    public abstract LogisticsModule getLogisticsModule();

    @Override
    public final boolean blockActivated(EntityPlayer entityplayer) {
        LogisticsSecurityTileEntity station;
        if (this.container == null) {
            return super.blockActivated(entityplayer);
        }
        SecuritySettings settings = null;
        if (MainProxy.isServer((IBlockAccess)entityplayer.field_70170_p) && (station = SimpleServiceLocator.securityStationManager.getStation(this.getOriginalUpgradeManager().getSecurityID())) != null) {
            settings = station.getSecuritySettingsForPlayer(entityplayer, true);
        }
        if (MainProxy.isPipeControllerEquipped(entityplayer)) {
            if (MainProxy.isServer((IBlockAccess)entityplayer.field_70170_p)) {
                if (settings == null || settings.openNetworkMonitor) {
                    NewGuiHandler.getGui(PipeController.class).setTilePos(this.container).open(entityplayer);
                } else {
                    entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            return true;
        }
        if (this.handleClick(entityplayer, settings)) {
            return true;
        }
        if (entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
            if (!entityplayer.func_70093_af()) {
                return false;
            }
            if (LogisticsPipes.isDEBUG()) {
                this.doDebugStuff(entityplayer);
            }
            return true;
        }
        if (entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == LPItems.remoteOrderer) {
            if (MainProxy.isServer((IBlockAccess)entityplayer.field_70170_p)) {
                if (settings == null || settings.openRequest) {
                    entityplayer.openGui((Object)LogisticsPipes.instance, 31, this.getWorld(), this.getX(), this.getY(), this.getZ());
                } else {
                    entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            return true;
        }
        if (SimpleServiceLocator.configToolHandler.canWrench(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), this.container)) {
            if (MainProxy.isServer((IBlockAccess)entityplayer.field_70170_p)) {
                if (settings == null || settings.openGui) {
                    LogisticsModule module = this.getLogisticsModule();
                    if (module instanceof Gui) {
                        Gui.getPipeGuiProvider((Gui)((Object)module)).setTilePos(this.container).open(entityplayer);
                    } else {
                        this.onWrenchClicked(entityplayer);
                    }
                } else {
                    entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            SimpleServiceLocator.configToolHandler.wrenchUsed(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), this.container);
            return true;
        }
        if (!entityplayer.func_70093_af() && this.getOriginalUpgradeManager().tryIserting(this.getWorld(), entityplayer)) {
            return true;
        }
        return super.blockActivated(entityplayer);
    }

    protected boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        return false;
    }

    public void refreshRender(boolean spawnPart) {
        this.container.scheduleRenderUpdate();
        if (spawnPart) {
            this.spawnParticle(Particles.GreenParticle, 3);
        }
    }

    public void refreshConnectionAndRender(boolean spawnPart) {
        this.container.scheduleNeighborChange();
        if (spawnPart) {
            this.spawnParticle(Particles.GreenParticle, 3);
        }
    }

    @Override
    public void receivedItem(int count2) {
        this.stat_session_recieved += count2;
        this.stat_lifetime_recieved += (long)count2;
        this.updateStats();
    }

    @Override
    public void relayedItem(int count2) {
        this.stat_session_relayed += count2;
        this.stat_lifetime_relayed += (long)count2;
        this.updateStats();
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 0) {
            this.watchers.add(player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(StatUpdate.class).setPipe(this), player);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        if (mode == 0) {
            this.watchers.remove(player);
        }
    }

    public void updateStats() {
        if (this.watchers.size() > 0) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(StatUpdate.class).setPipe(this), this.watchers);
        }
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (this instanceof IRequireReliableTransport) {
            ((IRequireReliableTransport)((Object)this)).itemLost(item, info);
        }
    }

    public boolean isLockedExit(EnumFacing orientation) {
        return false;
    }

    public boolean logisitcsIsPipeConnected(TileEntity tile, EnumFacing dir) {
        return false;
    }

    @Override
    public final boolean canPipeConnect(TileEntity tile, EnumFacing dir) {
        return this.canPipeConnect(tile, dir, false);
    }

    @Override
    public final boolean canPipeConnect(TileEntity tile, EnumFacing dir, boolean ignoreSystemDisconnection) {
        EnumFacing side = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile);
        if (this.isSideBlocked(side, ignoreSystemDisconnection)) {
            return false;
        }
        return super.canPipeConnect(tile, dir) || this.logisitcsIsPipeConnected(tile, dir);
    }

    @Override
    public final boolean isSideBlocked(EnumFacing side, boolean ignoreSystemDisconnection) {
        if (this.getUpgradeManager().isSideDisconnected(side)) {
            return true;
        }
        return !this.stillNeedReplace && this.getRouter().isSideDisconnected(side) && !ignoreSystemDisconnection;
    }

    public void connectionUpdate() {
        if (this.container != null && !this.stillNeedReplace) {
            if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
                throw new IllegalStateException("Wont do connectionUpdate on client-side");
            }
            this.container.scheduleNeighborChange();
            IBlockState state = this.getWorld().func_180495_p(this.getPos());
            this.getWorld().func_175685_c(this.getPos(), state.func_177230_c(), true);
        }
    }

    public UUID getSecurityID() {
        return this.getOriginalUpgradeManager().getSecurityID();
    }

    public void insetSecurityID(UUID id) {
        this.getOriginalUpgradeManager().insetSecurityID(id);
    }

    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> getRoutedPowerProviders() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return null;
        }
        if (this.stillNeedReplace) {
            return null;
        }
        return this.getRouter().getPowerProvider();
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, null, true);
    }

    public boolean useEnergy(int amount, boolean sparkles) {
        return this.useEnergy(amount, null, sparkles);
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, null);
    }

    @Override
    public boolean canUseEnergy(int amount, List<Object> providersToIgnore) {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return false;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return true;
        }
        if (amount == 0) {
            return true;
        }
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        List<Pair<ILogisticsPowerProvider, List<IFilter>>> list = this.getRoutedPowerProviders();
        if (list == null) {
            return false;
        }
        block0: for (Pair<ILogisticsPowerProvider, List<IFilter>> provider : list) {
            for (IFilter filter2 : provider.getValue2()) {
                if (!filter2.blockPower()) continue;
                continue block0;
            }
            if (!provider.getValue1().canUseEnergy(amount, providersToIgnore)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useEnergy(int amount, List<Object> providersToIgnore) {
        return this.useEnergy(amount, providersToIgnore, false);
    }

    private boolean useEnergy(int amount, List<Object> providersToIgnore, boolean sparkles) {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return false;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return true;
        }
        if (amount == 0) {
            return true;
        }
        if (providersToIgnore == null) {
            providersToIgnore = new ArrayList<Object>();
        }
        if (providersToIgnore.contains(this)) {
            return false;
        }
        providersToIgnore.add(this);
        List<Pair<ILogisticsPowerProvider, List<IFilter>>> list = this.getRoutedPowerProviders();
        if (list == null) {
            return false;
        }
        block0: for (Pair<ILogisticsPowerProvider, List<IFilter>> provider : list) {
            for (IFilter filter2 : provider.getValue2()) {
                if (!filter2.blockPower()) continue;
                continue block0;
            }
            if (!provider.getValue1().canUseEnergy(amount, providersToIgnore) || !provider.getValue1().useEnergy(amount, providersToIgnore)) continue;
            if (sparkles) {
                int particlecount = amount;
                if (particlecount > 10) {
                    particlecount = 10;
                }
                this.spawnParticle(Particles.GoldParticle, particlecount);
            }
            return true;
        }
        return false;
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        if (this.container != null) {
            this.container.queueEvent(event, arguments);
        }
    }

    public boolean stillNeedReplace() {
        return this.stillNeedReplace;
    }

    public boolean initialInit() {
        return this._initialInit;
    }

    @Override
    public int compareTo(@Nonnull IRequestItems other) {
        return Integer.compare(this.getID(), other.getID());
    }

    @Override
    public int getID() {
        return this.getRouter().getSimpleID();
    }

    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemIdentifiers) {
    }

    public boolean hasGenericInterests() {
        return false;
    }

    @Nullable
    public ISecurityProvider getSecurityProvider() {
        return SimpleServiceLocator.securityStationManager.getStation(this.getOriginalUpgradeManager().getSecurityID());
    }

    public boolean canBeDestroyedByPlayer(EntityPlayer entityPlayer) {
        LogisticsSecurityTileEntity station = SimpleServiceLocator.securityStationManager.getStation(this.getOriginalUpgradeManager().getSecurityID());
        return station == null || station.getSecuritySettingsForPlayer((EntityPlayer)entityPlayer, (boolean)true).removePipes;
    }

    @Override
    public boolean canBeDestroyed() {
        ISecurityProvider sec = this.getSecurityProvider();
        return sec == null || sec.canAutomatedDestroy();
    }

    public void setDestroyByPlayer() {
        this.destroyByPlayer = true;
    }

    @Override
    public boolean destroyByPlayer() {
        return this.destroyByPlayer;
    }

    @Override
    public boolean preventRemove() {
        return this.preventRemove;
    }

    @CCSecurtiyCheck
    public void checkCCAccess() throws PermissionException {
        ISecurityProvider sec = this.getSecurityProvider();
        if (sec != null) {
            int id = -1;
            if (this.container != null) {
                id = this.container.getLastCCID();
            }
            if (!sec.getAllowCC(id)) {
                throw new PermissionException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUnroutedItemInformation(ItemIdentifierStack item, ItemRoutingInformation information) {
        if (item != null) {
            Map<ItemIdentifier, Queue<Pair<Integer, ItemRoutingInformation>>> map2 = this.queuedDataForUnroutedItems;
            synchronized (map2) {
                Queue queue = this.queuedDataForUnroutedItems.computeIfAbsent(item.getItem(), k -> new LinkedList());
                queue.add(new Pair<Integer, ItemRoutingInformation>(item.getStackSize(), information));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemRoutingInformation getQueuedForItemStack(ItemIdentifierStack item) {
        Map<ItemIdentifier, Queue<Pair<Integer, ItemRoutingInformation>>> map2 = this.queuedDataForUnroutedItems;
        synchronized (map2) {
            Queue<Pair<Integer, ItemRoutingInformation>> queue = this.queuedDataForUnroutedItems.get(item.getItem());
            if (queue == null || queue.isEmpty()) {
                return null;
            }
            Pair<Integer, ItemRoutingInformation> pair = queue.peek();
            int wantItem = pair.getValue1();
            if (wantItem <= item.getStackSize()) {
                if (queue.remove() != pair) {
                    LogisticsPipes.log.fatal("Item queue mismatch");
                    return null;
                }
                if (queue.isEmpty()) {
                    this.queuedDataForUnroutedItems.remove(item.getItem());
                }
                item.setStackSize(wantItem);
                return pair.getValue2();
            }
        }
        return null;
    }

    public double getLoadFactor() {
        return 0.0;
    }

    public void notifyOfItemArival(ItemRoutingInformation information) {
        FluidIdentifierStack liquid;
        ItemIdentifierStack stack;
        this._inTransitToMe.remove(information);
        if (this instanceof IRequireReliableTransport) {
            ((IRequireReliableTransport)((Object)this)).itemArrived(information.getItem(), information.targetInfo);
        }
        if (this instanceof IRequireReliableFluidTransport && (stack = information.getItem()).getItem().isFluidContainer() && (liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(stack)) != null) {
            ((IRequireReliableFluidTransport)((Object)this)).liquidArrived(liquid.getFluid(), liquid.getAmount());
        }
    }

    @Override
    public int countOnRoute(ItemIdentifier it) {
        int count2 = 0;
        for (ItemRoutingInformation next : this._inTransitToMe) {
            if (!next.getItem().getItem().equals(it)) continue;
            count2 += next.getItem().getStackSize();
        }
        return count2;
    }

    @Override
    public final int getIconIndex(EnumFacing connection) {
        Textures.TextureType texture = this.getTextureType(connection);
        if (this._textureBufferPowered) {
            return texture.powered;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return texture.normal;
        }
        return texture.unpowered;
    }

    public void addCrashReport(CrashReportCategory crashReportCategory) {
        this.addRouterCrashReport(crashReportCategory);
        crashReportCategory.func_71507_a("stillNeedReplace", (Object)this.stillNeedReplace);
    }

    protected void addRouterCrashReport(CrashReportCategory crashReportCategory) {
        crashReportCategory.func_71507_a("Router", (Object)this.getRouter().toString());
    }

    @CCCommand(description="Returns the Router UUID as an integer; all pipes have a unique ID (runtime stable)")
    public int getRouterId() {
        return this.getRouter().getSimpleID();
    }

    @CCCommand(description="Returns the Router UUID; all pipes have a unique ID (lifetime stable)")
    public String getRouterUUID() {
        return this.getRouter().getId().toString();
    }

    @CCCommand(description="Returns the Router UUID for the givvin router Id")
    public String getRouterUUID(Double id) {
        IRouter router = SimpleServiceLocator.routerManager.getRouter(id.intValue());
        if (router == null) {
            return null;
        }
        return router.getId().toString();
    }

    @CCCommand(description="Returns the TurtleConnect targeted for this Turtle on this LogisticsPipe")
    @CCDirectCall
    public boolean getTurtleConnect() {
        if (this.container != null) {
            return this.container.getTurtleConnect();
        }
        return false;
    }

    @CCCommand(description="Sets the TurtleConnect targeted for this Turtle on this LogisticsPipe")
    @CCDirectCall
    public void setTurtleConnect(Boolean flag) {
        if (this.container != null) {
            this.container.setTurtleConnect(flag);
        }
    }

    @CCCommand(description="Returns true if the computer is allowed to interact with the connected pipe.", needPermission=false)
    public boolean canAccess() {
        ISecurityProvider sec = this.getSecurityProvider();
        if (sec != null) {
            int id = -1;
            if (this.container != null) {
                id = this.container.getLastCCID();
            }
            return sec.getAllowCC(id);
        }
        return true;
    }

    @CCCommand(description="Sends a message to the given computerId over the LP network. Event: LP_MESSAGE")
    @CCDirectCall
    public void sendMessage(Double computerId, Object message) {
        int sourceId = -1;
        if (this.container != null) {
            sourceId = SimpleServiceLocator.ccProxy.getLastCCID(this.container);
        }
        int fSourceId = sourceId;
        BitSet set = new BitSet(ServerRouter.getBiggestSimpleID());
        this.getRouter().getIRoutersByCost().stream().filter(exit -> !set.get(exit.destination.getSimpleID())).forEach(exit -> {
            exit.destination.queueTask(10, (pipe, router1) -> pipe.handleMesssage(computerId.intValue(), message, fSourceId));
            set.set(exit.destination.getSimpleID());
        });
    }

    @CCCommand(description="Sends a broadcast message to all Computer connected to this LP network. Event: LP_BROADCAST")
    @CCDirectCall
    public void sendBroadcast(String message) {
        int sourceId = -1;
        if (this.container != null) {
            sourceId = SimpleServiceLocator.ccProxy.getLastCCID(this.container);
        }
        int fSourceId = sourceId;
        BitSet set = new BitSet(ServerRouter.getBiggestSimpleID());
        this.getRouter().getIRoutersByCost().stream().filter(exit -> !set.get(exit.destination.getSimpleID())).forEach(exit -> {
            exit.destination.queueTask(10, (pipe, router1) -> pipe.handleBroadcast(message, fSourceId));
            set.set(exit.destination.getSimpleID());
        });
    }

    @CCCommand(description="Returns the access to the pipe of the given router UUID")
    @ModDependentMethod(modId="computercraft")
    @CCDirectCall
    public Object getPipeForUUID(String sUuid) throws PermissionException {
        if (!this.getUpgradeManager().hasCCRemoteControlUpgrade()) {
            throw new PermissionException();
        }
        UUID uuid = UUID.fromString(sUuid);
        int id = SimpleServiceLocator.routerManager.getIDforUUID(uuid);
        IRouter router = SimpleServiceLocator.routerManager.getRouter(id);
        if (router == null) {
            return null;
        }
        return router.getPipe();
    }

    @CCCommand(description="Returns the global LP object which is used to access general LP methods.", needPermission=false)
    @CCDirectCall
    public Object getLP() throws PermissionException {
        return LogisticsPipes.getComputerLP();
    }

    @CCCommand(description="Returns true if the pipe has an internal module")
    public boolean hasLogisticsModule() {
        return this.getLogisticsModule() != null;
    }

    private void handleMesssage(int computerId, Object message, int sourceId) {
        if (this.container != null) {
            this.container.handleMesssage(computerId, message, sourceId);
        }
    }

    private void handleBroadcast(String message, int sourceId) {
        this.queueEvent("LP_BROADCAST", new Object[]{sourceId, message});
    }

    public void onWrenchClicked(EntityPlayer entityplayer) {
    }

    public void handleRFPowerArival(double toSend) {
        this.powerHandler.addRFPower(toSend);
    }

    public void handleIC2PowerArival(double toSend) {
        this.powerHandler.addIC2Power(toSend);
    }

    @Override
    public IRoutedItem sendStack(@Nonnull ItemStack stack, Pair<Integer, SinkReply> reply, ItemSendMode mode, @Nonnull EnumFacing direction) {
        LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
        itemToSend.setDestination(reply.getValue1());
        if (reply.getValue2().isPassive) {
            if (reply.getValue2().isDefault) {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Default);
            } else {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Passive);
            }
        }
        itemToSend.setAdditionalTargetInformation(reply.getValue2().addInfo);
        this.queueRoutedItem(itemToSend, direction, mode);
        return itemToSend;
    }

    @Override
    public IRoutedItem sendStack(@Nonnull ItemStack stack, int destination, ItemSendMode mode, IAdditionalTargetInformation info, @Nonnull EnumFacing direction) {
        LPTravelingItem.LPTravelingItemServer itemToSend = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Active);
        itemToSend.setAdditionalTargetInformation(info);
        this.queueRoutedItem(itemToSend, direction, mode);
        return itemToSend;
    }

    @Override
    public LogisticsItemOrderManager getItemOrderManager() {
        this._orderItemManager = this._orderItemManager != null ? this._orderItemManager : new LogisticsItemOrderManager(this);
        return this._orderItemManager;
    }

    public LogisticsOrderManager<?, ?> getOrderManager() {
        return this.getItemOrderManager();
    }

    public void addPipeSign(EnumFacing dir, IPipeSign type, EntityPlayer player) {
        if (dir.ordinal() < 6) {
            if (this.signItem[dir.ordinal()] == null) {
                this.signItem[dir.ordinal()] = type;
                this.signItem[dir.ordinal()].init(this, dir);
            }
            if (this.container != null) {
                this.sendSignData(player, true);
                this.refreshRender(false);
            }
        }
    }

    public void sendSignData(EntityPlayer player, boolean sendToAll) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        block0: for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null) {
                types.add(-1);
                continue;
            }
            List<Class<? extends IPipeSign>> typeClasses = ItemPipeSignCreator.signTypes;
            for (int j = 0; j < typeClasses.size(); ++j) {
                if (typeClasses.get(j) != this.signItem[i].getClass()) continue;
                types.add(j);
                continue block0;
            }
        }
        ModernPacket packet = PacketHandler.getPacket(PipeSignTypes.class).setTypes(types).setTilePos(this.container);
        if (sendToAll) {
            MainProxy.sendPacketToAllWatchingChunk(this.container, packet);
        }
        MainProxy.sendPacketToPlayer(packet, player);
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null || (packet = this.signItem[i].getPacket()) == null) continue;
            MainProxy.sendPacketToAllWatchingChunk(this.container, packet);
            MainProxy.sendPacketToPlayer(packet, player);
        }
    }

    public void removePipeSign(EnumFacing dir, EntityPlayer player) {
        if (dir.ordinal() < 6) {
            this.signItem[dir.ordinal()] = null;
        }
        this.sendSignData(player, true);
        this.refreshRender(false);
    }

    public boolean hasPipeSign(EnumFacing dir) {
        if (dir.ordinal() < 6) {
            return this.signItem[dir.ordinal()] != null;
        }
        return false;
    }

    public void activatePipeSign(EnumFacing dir, EntityPlayer player) {
        if (dir.ordinal() < 6 && this.signItem[dir.ordinal()] != null) {
            this.signItem[dir.ordinal()].activate(player);
        }
    }

    public List<Pair<EnumFacing, IPipeSign>> getPipeSigns() {
        ArrayList<Pair<EnumFacing, IPipeSign>> list = new ArrayList<Pair<EnumFacing, IPipeSign>>();
        for (int i = 0; i < 6; ++i) {
            if (this.signItem[i] == null) continue;
            list.add(new Pair<EnumFacing, IPipeSign>(EnumFacingUtil.getOrientation(i), this.signItem[i]));
        }
        return list;
    }

    public void handleSignPacket(List<Integer> types) {
        if (!MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int integer = types.get(i);
            if (integer >= 0) {
                Class<? extends IPipeSign> type = ItemPipeSignCreator.signTypes.get(integer);
                if (this.signItem[i] != null && this.signItem[i].getClass() == type) continue;
                try {
                    this.signItem[i] = type.newInstance();
                    this.signItem[i].init(this, EnumFacingUtil.getOrientation(i));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
            this.signItem[i] = null;
        }
    }

    @Nullable
    public IPipeSign getPipeSign(@Nullable EnumFacing dir) {
        if (dir == null) {
            return null;
        }
        return this.signItem[dir.ordinal()];
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeBoolean(this.isOpaque());
    }

    @Override
    public void readData(LPDataInput input) {
        this.isOpaqueClientSide = input.readBoolean();
    }

    @Override
    public boolean isOpaque() {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return Configs.OPAQUE || this.isOpaqueClientSide;
        }
        return Configs.OPAQUE || this.getUpgradeManager().isOpaque();
    }

    @Override
    public void addStatusInformation(List<StatusEntry> status) {
        StatusEntry subEntry;
        StatusEntry entry = new StatusEntry();
        entry.name = "Send Queue";
        entry.subEntry = new ArrayList<StatusEntry>();
        for (Triplet triplet : this._sendQueue) {
            subEntry = new StatusEntry();
            subEntry.name = triplet.toString();
            entry.subEntry.add(subEntry);
        }
        status.add(entry);
        entry = new StatusEntry();
        entry.name = "In Transit To Me";
        entry.subEntry = new ArrayList<StatusEntry>();
        for (ItemRoutingInformation itemRoutingInformation : this._inTransitToMe) {
            subEntry = new StatusEntry();
            subEntry.name = itemRoutingInformation.toString();
            entry.subEntry.add(subEntry);
        }
        status.add(entry);
    }

    @Override
    public int getSourceID() {
        return this.getRouterId();
    }

    @Override
    @Nonnull
    public DebugLogController getDebug() {
        return this.debug;
    }

    @Override
    public void setPreventRemove(boolean flag) {
        this.preventRemove = flag;
    }

    @Override
    public boolean isRoutedPipe() {
        return true;
    }

    @Override
    public double getDistanceTo(int destinationint, EnumFacing ignore, ItemIdentifier ident, boolean isActive, double traveled, double max, List<DoubleCoordinates> visited) {
        if (!this.stillNeedReplace) {
            if (this.getRouterId() == destinationint) {
                return 0.0;
            }
            ExitRoute route = this.getRouter().getExitFor(destinationint, isActive, ident);
            if (route != null && route.exitOrientation != ignore) {
                if (route.distanceToDestination + traveled >= max) {
                    return 2.147483647E9;
                }
                return route.distanceToDestination;
            }
        }
        return 2.147483647E9;
    }

    @Override
    protected void triggerConnectionCheck() {
        this.recheckConnections = true;
    }

    @Override
    public CacheHolder getCacheHolder() {
        if (this.cacheHolder == null) {
            this.cacheHolder = this.container instanceof ILPTEInformation && ((ILPTEInformation)((Object)this.container)).getLPTileEntityObject() != null ? ((ILPTEInformation)((Object)this.container)).getLPTileEntityObject().getCacheHolder() : new CacheHolder();
        }
        return this.cacheHolder;
    }

    @Override
    public IHighlightPlacementRenderer getHighlightRenderer() {
        return LogisticsRenderPipe.secondRenderer;
    }

    @Override
    public void finishInit() {
        super.finishInit();
        if (this.isInitialized()) {
            MainProxy.runOnServer((IBlockAccess)this.getWorld(), () -> () -> {
                if (this instanceof PropertyHolder) {
                    UtilKt.addObserver(((PropertyHolder)((Object)this)).getProperties(), prop -> {
                        this.markTileDirty();
                        return Unit.INSTANCE;
                    });
                }
            });
            if (this.getLogisticsModule() != null) {
                this.getLogisticsModule().finishInit();
            }
        }
    }

    public List<IOrderInfoProvider> getClientSideOrderManager() {
        return this.clientSideOrderManager;
    }

    public static enum ItemSendMode {
        Normal,
        Fast;

    }
}

