/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.interfaces.ISecurityStationManager;
import logisticspipes.interfaces.routing.IChannelConnectionManager;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.SecurityStationAuthorizedList;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ClientRouter;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.channels.ChannelConnection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RouterManager
implements IChannelConnectionManager,
ISecurityStationManager {
    private final ArrayList<IRouter> _routersClient = new ArrayList();
    private final ArrayList<ServerRouter> _routersServer = new ArrayList();
    private final Map<UUID, Integer> _uuidMap = new HashMap<UUID, Integer>();
    private final WeakHashMap<LogisticsSecurityTileEntity, Void> _security = new WeakHashMap();
    private List<String> _authorized = new LinkedList<String>();
    private final ArrayList<ChannelConnection> channelConnectedPipes = new ArrayList();

    @Nullable
    public IRouter getRouter(int id) {
        if (id <= 0 || MainProxy.isClient()) {
            return null;
        }
        return this._routersServer.get(id);
    }

    @Nullable
    public ServerRouter getServerRouter(int id) {
        if (id <= 0) {
            return null;
        }
        return this._routersServer.get(id);
    }

    public int getIDforUUID(UUID id) {
        if (id == null) {
            return -1;
        }
        Integer iId = this._uuidMap.get(id);
        if (iId == null) {
            return -1;
        }
        return iId;
    }

    public void removeRouter(int id) {
        if (!MainProxy.isClient()) {
            this._routersServer.set(id, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public IRouter getOrCreateRouter(UUID UUid, World world, int xCoord, int yCoord, int zCoord) {
        IRouter r;
        int id = this.getIDforUUID(UUid);
        if (id > 0) {
            this.getRouter(id);
        }
        if (MainProxy.isClient((IBlockAccess)world)) {
            ArrayList<IRouter> arrayList = this._routersClient;
            synchronized (arrayList) {
                for (IRouter iRouter : this._routersClient) {
                    if (!iRouter.isAt(world.field_73011_w.getDimension(), xCoord, yCoord, zCoord)) continue;
                    return iRouter;
                }
                r = new ClientRouter(UUid, world.field_73011_w.getDimension(), xCoord, yCoord, zCoord);
                this._routersClient.add(r);
            }
        }
        ArrayList<ServerRouter> arrayList = this._routersServer;
        synchronized (arrayList) {
            for (IRouter iRouter : this._routersServer) {
                if (iRouter == null || !iRouter.isAt(world.field_73011_w.getDimension(), xCoord, yCoord, zCoord)) continue;
                return iRouter;
            }
            ServerRouter serverRouter = new ServerRouter(UUid, world.field_73011_w.getDimension(), xCoord, yCoord, zCoord);
            int n = serverRouter.getSimpleID();
            if (this._routersServer.size() <= n) {
                this._routersServer.ensureCapacity(n + 1);
                while (this._routersServer.size() <= n) {
                    this._routersServer.add(null);
                }
            }
            this._routersServer.set(n, serverRouter);
            this._uuidMap.put(serverRouter.getId(), serverRouter.getSimpleID());
            r = serverRouter;
        }
        return r;
    }

    public boolean isRouterUnsafe(int id, boolean side) {
        if (side) {
            return true;
        }
        return this._routersServer.get(id) != null;
    }

    public List<IRouter> getRouters() {
        if (MainProxy.isClient()) {
            return Collections.unmodifiableList(this._routersClient);
        }
        return Collections.unmodifiableList(this._routersServer);
    }

    @Override
    public boolean hasChannelConnection(IRouter router) {
        return this.channelConnectedPipes.stream().filter(con -> con.routers.size() > 1).anyMatch(con -> con.routers.contains(router.getSimpleID()));
    }

    @Override
    public boolean addChannelConnection(UUID ident, IRouter router) {
        if (MainProxy.isClient()) {
            return false;
        }
        int routerSimpleID = router.getSimpleID();
        this.channelConnectedPipes.forEach(con -> con.routers.remove(routerSimpleID));
        Optional<ChannelConnection> channel = this.channelConnectedPipes.stream().filter(con -> con.identifier.equals(ident)).findFirst();
        if (channel.isPresent()) {
            channel.get().routers.add(routerSimpleID);
        } else {
            ChannelConnection newChannel = new ChannelConnection();
            this.channelConnectedPipes.add(newChannel);
            newChannel.identifier = ident;
            newChannel.routers.add(routerSimpleID);
        }
        return true;
    }

    @Override
    public List<CoreRoutedPipe> getConnectedPipes(IRouter router) {
        Optional<ChannelConnection> channel = this.channelConnectedPipes.stream().filter(con -> con.routers.contains(router.getSimpleID())).findFirst();
        return channel.map(channelConnection -> channelConnection.routers.stream().filter(r -> r.intValue() != router.getSimpleID()).map(this::getRouter).filter(Objects::nonNull).map(IRouter::getPipe).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public void removeChannelConnection(IRouter router) {
        if (MainProxy.isClient()) {
            return;
        }
        Optional<ChannelConnection> channel = this.channelConnectedPipes.stream().filter(con -> con.routers.contains(router.getSimpleID())).findFirst();
        channel.ifPresent(chan -> chan.routers.remove(router.getSimpleID()));
        if (channel.filter(chan -> chan.routers.isEmpty()).isPresent()) {
            this.channelConnectedPipes.remove(channel.get());
        }
    }

    public void serverStopClean() {
        this.channelConnectedPipes.clear();
        this._routersServer.clear();
        this._uuidMap.clear();
        this._security.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearClientRouters() {
        ArrayList<IRouter> arrayList = this._routersClient;
        synchronized (arrayList) {
            this._routersClient.clear();
        }
    }

    @Override
    public void add(LogisticsSecurityTileEntity tile) {
        this._security.put(tile, null);
        this.authorizeUUID(tile.getSecId());
    }

    @Override
    public LogisticsSecurityTileEntity getStation(UUID id) {
        if (id == null) {
            return null;
        }
        for (LogisticsSecurityTileEntity tile : this._security.keySet()) {
            if (!id.equals(tile.getSecId())) continue;
            return tile;
        }
        return null;
    }

    @Override
    public void remove(LogisticsSecurityTileEntity tile) {
        this._security.remove(tile);
        this.deauthorizeUUID(tile.getSecId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dimensionUnloaded(int dim) {
        ArrayList<ServerRouter> arrayList = this._routersServer;
        synchronized (arrayList) {
            this._routersServer.stream().filter(r -> r != null && r.isInDim(dim)).forEach(r -> {
                r.clearPipeCache();
                r.clearInterests();
            });
        }
    }

    @Override
    public void deauthorizeUUID(UUID id) {
        this._authorized.remove(id.toString());
        this.sendClientAuthorizationList();
    }

    @Override
    public void authorizeUUID(UUID id) {
        if (!this._authorized.contains(id.toString())) {
            this._authorized.add(id.toString());
        }
        this.sendClientAuthorizationList();
    }

    @Override
    public boolean isAuthorized(UUID id) {
        if (this._authorized.isEmpty() || id == null) {
            return false;
        }
        return this._authorized.contains(id.toString());
    }

    @Override
    public boolean isAuthorized(String id) {
        if (this._authorized.isEmpty() || id == null) {
            return false;
        }
        return this._authorized.contains(id);
    }

    @Override
    public void setClientAuthorizationList(List<String> list) {
        this._authorized = list;
    }

    @Override
    public void sendClientAuthorizationList() {
        MainProxy.sendToAllPlayers(PacketHandler.getPacket(SecurityStationAuthorizedList.class).setStringList(this._authorized));
    }

    @Override
    public void sendClientAuthorizationList(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SecurityStationAuthorizedList.class).setStringList(this._authorized), player);
    }

    public void printAllRouters() {
        this._routersServer.stream().filter(router -> router != null).forEach(router -> System.out.println(router.toString()));
    }
}

