/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.pathfinder;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.routing.pathfinder.ISubMultiBlockPipeInformationProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.connection.ConnectionType;

public class PipeInformationManager {
    private Map<Class<?>, Class<? extends IPipeInformationProvider>> infoProvider = new HashMap();

    public IPipeInformationProvider getInformationProviderFor(TileEntity tile) {
        if (tile == null) {
            return null;
        }
        if (tile instanceof IPipeInformationProvider) {
            return (IPipeInformationProvider)tile;
        }
        if (tile instanceof ISubMultiBlockPipeInformationProvider) {
            return ((ISubMultiBlockPipeInformationProvider)tile).getMainTile();
        }
        for (Class<?> type : this.infoProvider.keySet()) {
            if (!type.isAssignableFrom(tile.getClass())) continue;
            try {
                IPipeInformationProvider provider = this.infoProvider.get(type).getDeclaredConstructor(type).newInstance(type.cast(tile));
                if (!provider.isCorrect(ConnectionType.UNDEFINED)) continue;
                return provider;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void registerProvider(Class<?> source, Class<? extends IPipeInformationProvider> provider) {
        try {
            provider.getDeclaredConstructor(source);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        this.infoProvider.put(source, provider);
    }

    public boolean canConnect(IPipeInformationProvider startPipe, IPipeInformationProvider provider, EnumFacing direction, boolean flag) {
        return startPipe.canConnect(provider.getTile(), direction, flag) && provider.canConnect(startPipe.getTile(), direction.func_176734_d(), flag);
    }

    public boolean isItemPipe(TileEntity tile) {
        return this.isPipe(tile, true, ConnectionType.ITEM);
    }

    public boolean isPipe(TileEntity tile) {
        return this.isPipe(tile, true, ConnectionType.UNDEFINED);
    }

    public boolean isPipe(TileEntity tile, boolean check, ConnectionType pipeType) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IPipeInformationProvider) {
            return true;
        }
        if (tile instanceof ISubMultiBlockPipeInformationProvider) {
            return pipeType == ConnectionType.MULTIBLOCK;
        }
        for (Class<?> type : this.infoProvider.keySet()) {
            if (!type.isAssignableFrom(tile.getClass())) continue;
            try {
                IPipeInformationProvider provider = this.infoProvider.get(type).getDeclaredConstructor(type).newInstance(type.cast(tile));
                if (check && !provider.isCorrect(pipeType)) continue;
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isNotAPipe(TileEntity tile) {
        if (tile instanceof IPipeInformationProvider) {
            return false;
        }
        if (tile instanceof ISubMultiBlockPipeInformationProvider) {
            return false;
        }
        for (Class<?> type : this.infoProvider.keySet()) {
            if (!type.isAssignableFrom(tile.getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean isFluidPipe(TileEntity tile) {
        IPipeInformationProvider info = this.getInformationProviderFor(tile);
        if (info == null) {
            return false;
        }
        return info.isFluidPipe();
    }
}

