/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.pathfinder.changedetection;

import java.util.ArrayList;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.asm.te.ITileEntityChangeListener;
import logisticspipes.asm.te.LPTileEntityObject;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.ticks.LPTickHandler;
import logisticspipes.ticks.QueuedTasks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.connection.ConnectionType;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class TEControl {
    public static void validate(TileEntity tile) {
        World world = tile.func_145831_w();
        if (!MainProxy.isServer((IBlockAccess)world)) {
            return;
        }
        if (tile.getClass().getName().startsWith("net.minecraft.tileentity")) {
            return;
        }
        DoubleCoordinates pos = new DoubleCoordinates(tile);
        if (pos.getXInt() == 0 && pos.getYInt() <= 0 && pos.getZInt() == 0) {
            return;
        }
        if (SimpleServiceLocator.pipeInformationManager.isPipe(tile, false, ConnectionType.UNDEFINED) || SimpleServiceLocator.specialtileconnection.isType(tile)) {
            ((ILPTEInformation)tile).setLPTileEntityObject(new LPTileEntityObject());
            ((ILPTEInformation)tile).getLPTileEntityObject().initialised = LPTickHandler.getWorldInfo(world).getWorldTick();
            if (((ILPTEInformation)tile).getLPTileEntityObject().initialised < 5L) {
                return;
            }
            QueuedTasks.queueTask(() -> {
                if (!SimpleServiceLocator.pipeInformationManager.isPipe(tile, true, ConnectionType.UNDEFINED)) {
                    return null;
                }
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    TileEntity nextTile;
                    DoubleCoordinates newPos = CoordinateUtils.sum(pos, dir);
                    if (!newPos.blockExists(world) || (nextTile = newPos.getTileEntity((IBlockAccess)world)) == null || ((ILPTEInformation)nextTile).getLPTileEntityObject() == null) continue;
                    if (SimpleServiceLocator.pipeInformationManager.isItemPipe(nextTile)) {
                        SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(nextTile).refreshTileCacheOnSide(dir.func_176734_d());
                    }
                    if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
                        SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile).refreshTileCacheOnSide(dir);
                        SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile).refreshTileCacheOnSide(dir.func_176734_d());
                    }
                    for (ITileEntityChangeListener listener : new ArrayList<ITileEntityChangeListener>(((ILPTEInformation)nextTile).getLPTileEntityObject().changeListeners)) {
                        listener.pipeAdded(pos, dir.func_176734_d());
                    }
                }
                return null;
            });
        }
    }

    public static void invalidate(TileEntity tile) {
        World world = tile.func_145831_w();
        if (!MainProxy.isServer((IBlockAccess)world)) {
            return;
        }
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).isRoutingPipe()) {
            return;
        }
        if (((ILPTEInformation)tile).getLPTileEntityObject() != null) {
            QueuedTasks.queueTask(() -> {
                DoubleCoordinates pos = new DoubleCoordinates(tile);
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    TileEntity nextTile;
                    DoubleCoordinates newPos = CoordinateUtils.sum(pos, dir);
                    if (!newPos.blockExists(world) || (nextTile = newPos.getTileEntity((IBlockAccess)world)) == null || ((ILPTEInformation)nextTile).getLPTileEntityObject() == null || !SimpleServiceLocator.pipeInformationManager.isItemPipe(nextTile)) continue;
                    SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(nextTile).refreshTileCacheOnSide(dir.func_176734_d());
                }
                for (ITileEntityChangeListener listener : new ArrayList<ITileEntityChangeListener>(((ILPTEInformation)tile).getLPTileEntityObject().changeListeners)) {
                    listener.pipeRemoved(pos);
                }
                return null;
            });
        }
    }
}

