/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui;

import logisticspipes.utils.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class SimpleGraphics {
    private SimpleGraphics() {
    }

    public static void drawHorizontalLine(int x1, int x2, int y, Color color, int thickness) {
        SimpleGraphics.drawHorizontalLine(x1, x2, y, Color.getValue(color), thickness);
    }

    public static void drawHorizontalLine(int x1, int x2, int y, int color, int thickness) {
        if (x2 < x1) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        Gui.func_73734_a((int)x1, (int)y, (int)(x2 + 1), (int)(y + thickness), (int)color);
    }

    public static void drawVerticalLine(int x, int y1, int y2, Color color, int thickness) {
        SimpleGraphics.drawVerticalLine(x, y1, y2, Color.getValue(color), thickness);
    }

    public static void drawVerticalLine(int x, int y1, int y2, int color, int thickness) {
        if (y2 < y1) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        Gui.func_73734_a((int)x, (int)(y1 + 1), (int)(x + thickness), (int)y2, (int)color);
    }

    public static void drawRectNoBlend(int x1, int y1, int x2, int y2, Color color, double zLevel) {
        SimpleGraphics.drawRectNoBlend(x1, y1, x2, y2, Color.getValue(color), zLevel);
    }

    public static void drawRectNoBlend(int x1, int y1, int x2, int y2, int color, double zLevel) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        GlStateManager.func_179090_x();
        GL11.glColor4f((float)Color.getRed(color), (float)Color.getGreen(color), (float)Color.getBlue(color), (float)Color.getAlpha(color));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buf.func_181662_b((double)x1, (double)y2, zLevel).func_181675_d();
        buf.func_181662_b((double)x2, (double)y2, zLevel).func_181675_d();
        buf.func_181662_b((double)x2, (double)y1, zLevel).func_181675_d();
        buf.func_181662_b((double)x1, (double)y1, zLevel).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void drawGradientRect(int x1, int y1, int x2, int y2, Color colorA, Color colorB, double zLevel) {
        SimpleGraphics.drawGradientRect(x1, y1, x2, y2, Color.getValue(colorA), Color.getValue(colorB), zLevel);
    }

    public static void drawGradientRect(int x1, int y1, int x2, int y2, int colorA, int colorB, double zLevel) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b((double)x2, (double)y1, zLevel).func_181666_a(Color.getRed(colorA), Color.getGreen(colorA), Color.getBlue(colorA), Color.getAlpha(colorA)).func_181675_d();
        buf.func_181662_b((double)x1, (double)y1, zLevel).func_181666_a(Color.getRed(colorA), Color.getGreen(colorA), Color.getBlue(colorA), Color.getAlpha(colorA)).func_181675_d();
        buf.func_181662_b((double)x1, (double)y2, zLevel).func_181666_a(Color.getRed(colorB), Color.getGreen(colorB), Color.getBlue(colorB), Color.getAlpha(colorB)).func_181675_d();
        buf.func_181662_b((double)x2, (double)y2, zLevel).func_181666_a(Color.getRed(colorB), Color.getGreen(colorB), Color.getBlue(colorB), Color.getAlpha(colorB)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b((double)x, (double)(y + height), zLevel).func_187315_a((double)((float)u * f), (double)((float)(v + height) * f1));
        buf.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        buf.func_181662_b((double)(x + width), (double)y, zLevel).func_187315_a((double)((float)(u + width) * f), (double)((float)v * f1));
        buf.func_181662_b((double)x, (double)y, zLevel).func_187315_a((double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }

    public static int drawStringWithTranslatedShadow(FontRenderer fontRenderer, String s, int x, int y, int color) {
        int grayColor = (color & 0xFCFCFC) >> 2 | color & 0xFF000000;
        int endX = fontRenderer.func_78276_b(s, x + 1, y + 1, grayColor);
        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
        endX = Math.max(endX, fontRenderer.func_78276_b(s, x, y, color));
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
        return endX;
    }

    public static void drawQuad(Tessellator tessellator, int x, int y, int width, int height, Color color, double zLevel) {
        SimpleGraphics.drawQuad(tessellator, x, y, width, height, Color.getValue(color), zLevel);
    }

    public static void drawQuad(Tessellator tessellator, int x, int y, int width, int height, int color, double zLevel) {
        BufferBuilder buf = tessellator.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float a = Color.getAlpha(color);
        float r = Color.getRed(color);
        float g = Color.getGreen(color);
        float b = Color.getBlue(color);
        buf.func_181662_b((double)x, (double)y, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b((double)x, (double)(y + height), zLevel).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b((double)(x + width), (double)y, zLevel).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }
}

