/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui.sideconfig;

import java.awt.Rectangle;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.textures.Textures;
import logisticspipes.utils.LPPositionSet;
import logisticspipes.utils.math.BoundingBox;
import logisticspipes.utils.math.Camera;
import logisticspipes.utils.math.Matrix4d;
import logisticspipes.utils.math.VecmathUtil;
import logisticspipes.utils.math.Vector2d;
import logisticspipes.utils.math.Vector3d;
import logisticspipes.utils.math.Vertex;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public abstract class SideConfigDisplay {
    private boolean draggingRotate = false;
    private boolean draggingMove = false;
    private float pitch;
    private float yaw;
    private double distance;
    private long initTime;
    private Minecraft mc = Minecraft.func_71410_x();
    private World world;
    private final Vector3d origin = new Vector3d();
    private final Vector3d eye = new Vector3d();
    private final Camera camera = new Camera();
    private final Matrix4d pitchRot = new Matrix4d();
    private final Matrix4d yawRot = new Matrix4d();
    public DoubleCoordinates originBC;
    private List<DoubleCoordinates> configurables = new ArrayList<DoubleCoordinates>();
    private List<DoubleCoordinates> neighbours = new ArrayList<DoubleCoordinates>();
    private SelectedFace selection;
    public boolean renderNeighbours = true;

    public SideConfigDisplay(CoreRoutedPipe configurables) {
        this(Collections.singletonList(configurables.getLPPosition()));
    }

    public SideConfigDisplay(LPPositionSet<DoubleCoordinates> configurables) {
        this(Arrays.asList(configurables.toArray((DoubleCoordinates[])new DoubleCoordinates[0])));
    }

    public SideConfigDisplay(List<DoubleCoordinates> configurables) {
        Vector3d size;
        Vector3d c;
        this.configurables.addAll(configurables);
        if (configurables.size() == 1) {
            DoubleCoordinates bc = this.configurables.get(0);
            c = new Vector3d(bc.getXDouble() + 0.5, bc.getYDouble() + 0.5, bc.getZDouble() + 0.5);
            size = new Vector3d(1.0, 1.0, 1.0);
        } else {
            Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
            for (DoubleCoordinates bc : configurables) {
                min.set(Math.min(bc.getXDouble(), min.x), Math.min(bc.getYDouble(), min.y), Math.min(bc.getZDouble(), min.z));
                max.set(Math.max(bc.getXDouble(), max.x), Math.max(bc.getYDouble(), max.y), Math.max(bc.getZDouble(), max.z));
            }
            size = new Vector3d(max);
            size.sub(min);
            size.multiply(0.5);
            c = new Vector3d(min.x + size.x, min.y + size.y, min.z + size.z);
            size.multiply(2.0);
        }
        this.originBC = new DoubleCoordinates((int)c.x, (int)c.y, (int)c.z);
        this.origin.set(c);
        this.pitchRot.setIdentity();
        this.yawRot.setIdentity();
        this.pitch = -this.mc.field_71439_g.field_70125_A;
        this.yaw = 180.0f - this.mc.field_71439_g.field_70177_z;
        this.distance = Math.max(Math.max(size.x, size.y), size.z) + 4.0;
        for (DoubleCoordinates bc : configurables) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                DoubleCoordinates loc = CoordinateUtils.add(new DoubleCoordinates(bc), dir);
                if (configurables.contains(loc)) continue;
                this.neighbours.add(loc);
            }
        }
        this.world = this.mc.field_71439_g.field_70170_p;
    }

    public abstract void handleSelection(SelectedFace var1);

    public void init() {
        this.initTime = System.currentTimeMillis();
    }

    public SelectedFace getSelection() {
        return this.selection;
    }

    public void handleMouseInput() {
        Vector3d end;
        Vector3d start;
        int y;
        double dy;
        double dx;
        if (Mouse.getEventButton() == 0) {
            this.draggingRotate = Mouse.getEventButtonState();
        }
        if (Mouse.getEventButton() == 2) {
            this.draggingMove = Mouse.getEventButtonState();
        }
        if (this.draggingRotate) {
            dx = (double)Mouse.getEventDX() / (double)this.mc.field_71443_c;
            dy = (double)Mouse.getEventDY() / (double)this.mc.field_71440_d;
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)42)) {
                this.distance -= dy * 15.0;
            } else {
                this.yaw = (float)((double)this.yaw - 4.0 * dx * 180.0);
                this.pitch = (float)((double)this.pitch + 2.0 * dy * 180.0);
                this.pitch = (float)VecmathUtil.clamp(this.pitch, -80.0, 80.0);
            }
        }
        if (this.draggingMove) {
            dx = Mouse.getEventDX();
            dy = -Mouse.getEventDY();
            Vector3d orivec = this.camera.getWorldPoint(new Vector2d(0.0, 0.0));
            Vector3d newvec = this.camera.getWorldPoint(new Vector2d(dx * this.distance, dy * this.distance)).negate();
            this.origin.add(orivec).add(newvec);
        }
        this.distance -= (double)Mouse.getEventDWheel() * 0.01;
        this.distance = VecmathUtil.clamp(this.distance, 0.01, 200.0);
        long elapsed = System.currentTimeMillis() - this.initTime;
        int x = Mouse.getEventX();
        if (this.camera.getRayForPixel(x, y = Mouse.getEventY(), start = new Vector3d(), end = new Vector3d())) {
            end.multiply(this.distance * 2.0);
            end.add(start);
            this.updateSelection(start, end);
        }
        if (!Mouse.getEventButtonState() && this.camera.isValid() && elapsed > 500L) {
            boolean inNeigButBounds = false;
            if (Mouse.getEventButton() == 1) {
                if (this.selection != null) {
                    this.handleSelection(this.selection);
                }
            } else if (Mouse.getEventButton() == 0 && inNeigButBounds) {
                this.renderNeighbours = !this.renderNeighbours;
            }
        }
    }

    private void updateSelection(Vector3d start, Vector3d end) {
        TileEntity te;
        start.add(this.origin);
        end.add(this.origin);
        ArrayList<RayTraceResult> hits = new ArrayList<RayTraceResult>();
        LogisticsBlockGenericPipe.ignoreSideRayTrace = true;
        for (DoubleCoordinates bc : this.configurables) {
            RayTraceResult hit;
            IBlockState blockState = bc.getBlockState((IBlockAccess)this.world);
            if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.world, bc.getBlockPos()) || (hit = blockState.func_185910_a(this.world, bc.getBlockPos(), start.toVec3d(), end.toVec3d())) == null || hit.field_72313_a == RayTraceResult.Type.MISS) continue;
            hits.add(hit);
        }
        LogisticsBlockGenericPipe.ignoreSideRayTrace = false;
        this.selection = null;
        RayTraceResult hit = SideConfigDisplay.getClosestHit(start.toVec3d(), hits);
        if (hit != null && (te = this.world.func_175625_s(hit.func_178782_a())) != null) {
            this.selection = new SelectedFace(te, hit.field_178784_b, hit);
        }
    }

    public static RayTraceResult getClosestHit(Vec3d origin2, Collection<RayTraceResult> candidates) {
        double minLengthSquared = Double.POSITIVE_INFINITY;
        RayTraceResult closest = null;
        for (RayTraceResult hit : candidates) {
            double lengthSquared;
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin2)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            closest = hit;
        }
        return closest;
    }

    public void drawScreen(int par1, int par2, float partialTick, Rectangle vp, Rectangle parentBounds) {
        if (!this.updateCamera(partialTick, vp.x, vp.y, vp.width, vp.height)) {
            return;
        }
        this.applyCamera(partialTick);
        this.renderScene();
        this.renderSelection();
        this.renderOverlay(par1, par2);
    }

    private void renderSelection() {
        if (this.selection == null) {
            return;
        }
        BoundingBox bb = new BoundingBox(new DoubleCoordinates(this.selection.config));
        TextureAtlasSprite icon = (TextureAtlasSprite)Textures.LOGISTICS_SIDE_SELECTION;
        List<Vertex> corners = bb.getCornersWithUvForFace(this.selection.face, icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h());
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        RenderUtil.bindBlockTexture();
        BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
        tes.func_178969_c(trans.x, trans.y, trans.z);
        RenderUtil.addVerticesToTessellator(corners, DefaultVertexFormats.field_181707_g, true);
        Tessellator.func_178181_a().func_78381_a();
        tes.func_178969_c(0.0, 0.0, 0.0);
    }

    private void renderOverlay(int mx, int my) {
        Rectangle vp = this.camera.getViewport();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int vpx = vp.x / scaledresolution.func_78325_e();
        int vph = vp.height / scaledresolution.func_78325_e();
        int vpw = vp.width / scaledresolution.func_78325_e();
        int vpy = (int)((float)(vp.y + vp.height - 4) / (float)scaledresolution.func_78325_e());
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)vpx, (float)vpy, (float)-2000.0f);
        GlStateManager.func_179140_f();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderScene() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        RenderHelper.func_74518_a();
        this.mc.field_71460_t.func_175072_h();
        RenderUtil.bindBlockTexture();
        GlStateManager.func_179140_f();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        try {
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                this.setGlStateForPass(layer, false);
                this.doWorldRenderPass(trans, this.configurables, layer);
            }
            if (this.renderNeighbours) {
                for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                    this.setGlStateForPass(layer, true);
                    this.doWorldRenderPass(trans, this.neighbours, layer);
                }
            }
        }
        finally {
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
        }
        RenderHelper.func_74519_b();
        GlStateManager.func_179145_e();
        TileEntityRendererDispatcher.field_147556_a.field_147560_j = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147556_a.field_147561_k = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147556_a.field_147558_l = this.origin.z - this.eye.z;
        TileEntityRendererDispatcher.field_147554_b = this.origin.x - this.eye.x;
        TileEntityRendererDispatcher.field_147555_c = this.origin.y - this.eye.y;
        TileEntityRendererDispatcher.field_147552_d = this.origin.z - this.eye.z;
        for (int pass = 0; pass < 2; ++pass) {
            ForgeHooksClient.setRenderPass((int)pass);
            this.setGlStateForPass(pass, false);
            this.doTileEntityRenderPass(this.configurables, pass);
            if (!this.renderNeighbours) continue;
            this.setGlStateForPass(pass, true);
            this.doTileEntityRenderPass(this.neighbours, pass);
        }
        ForgeHooksClient.setRenderPass((int)-1);
        this.setGlStateForPass(0, false);
    }

    private void doTileEntityRenderPass(List<DoubleCoordinates> blocks, int pass) {
        for (DoubleCoordinates bc : blocks) {
            TileEntity tile = this.world.func_175625_s(bc.getBlockPos());
            if (tile == null || !tile.shouldRenderInPass(pass)) continue;
            Vector3d at = new Vector3d(this.eye.x, this.eye.y, this.eye.z);
            at.x += bc.getXCoord() - this.origin.x;
            at.y += bc.getYCoord() - this.origin.y;
            at.z += bc.getZCoord() - this.origin.z;
            if (tile.getClass() == TileEntityChest.class) {
                TileEntityChest chest = (TileEntityChest)tile;
                if (chest.field_145991_k != null) {
                    tile = chest.field_145991_k;
                    at.x -= 1.0;
                } else if (chest.field_145992_i != null) {
                    tile = chest.field_145992_i;
                    at.z -= 1.0;
                }
            }
            TileEntityRendererDispatcher.field_147556_a.func_192854_a(tile, at.x, at.y, at.z, 0.0f, -1, 0.0f);
        }
    }

    private void doWorldRenderPass(Vector3d trans, List<DoubleCoordinates> blocks, BlockRenderLayer layer) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Tessellator.func_178181_a().func_178180_c().func_178969_c(trans.x, trans.y, trans.z);
        for (DoubleCoordinates bc : blocks) {
            IBlockState blockState = this.world.func_180495_p(bc.getBlockPos()).func_185899_b((IBlockAccess)this.world, bc.getBlockPos());
            if (!blockState.func_177230_c().canRenderInLayer(blockState, layer)) continue;
            this.renderBlock(blockState, bc.getBlockPos(), (IBlockAccess)this.world, Tessellator.func_178181_a().func_178180_c());
        }
        Tessellator.func_178181_a().func_78381_a();
        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
    }

    public void renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder worldRendererIn) {
        try {
            BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
            EnumBlockRenderType type = state.func_185901_i();
            if (type != EnumBlockRenderType.MODEL) {
                blockrendererdispatcher.func_175018_a(state, pos, blockAccess, worldRendererIn);
                return;
            }
            IBakedModel ibakedmodel = blockrendererdispatcher.func_184389_a(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)this.world, pos);
            blockrendererdispatcher.func_175019_b().func_178267_a(blockAccess, ibakedmodel, state, pos, worldRendererIn, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setGlStateForPass(BlockRenderLayer layer, boolean isNeighbour) {
        int pass = layer == BlockRenderLayer.TRANSLUCENT ? 1 : 0;
        this.setGlStateForPass(pass, isNeighbour);
    }

    private void setGlStateForPass(int layer, boolean isNeighbour) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        if (isNeighbour) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            float alpha = 1.0f;
            float col = 1.0f;
            GlStateManager.func_179112_b((int)770, (int)32769);
            GL14.glBlendColor((float)col, (float)col, (float)col, (float)alpha);
            return;
        }
        if (layer == 0) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179132_a((boolean)false);
        }
    }

    private boolean updateCamera(float partialTick, int vpx, int vpy, int vpw, int vph) {
        if (vpw <= 0 || vph <= 0) {
            return false;
        }
        this.camera.setViewport(vpx, vpy, vpw, vph);
        this.camera.setProjectionMatrixAsPerspective(30.0, 0.05, 50.0, vpw, vph);
        this.eye.set(0.0, 0.0, this.distance);
        this.pitchRot.makeRotationX(Math.toRadians(this.pitch));
        this.yawRot.makeRotationY(Math.toRadians(this.yaw));
        this.pitchRot.transform(this.eye);
        this.yawRot.transform(this.eye);
        this.camera.setViewMatrixAsLookAt(this.eye, RenderUtil.ZERO_V, RenderUtil.UP_V);
        return this.camera.isValid();
    }

    private void applyCamera(float partialTick) {
        Rectangle vp = this.camera.getViewport();
        GL11.glViewport((int)vp.x, (int)vp.y, (int)vp.width, (int)vp.height);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        RenderUtil.loadMatrix(this.camera.getTransposeProjectionMatrix());
        GL11.glMatrixMode((int)5888);
        RenderUtil.loadMatrix(this.camera.getTransposeViewMatrix());
        GL11.glTranslatef((float)(-((float)this.eye.x)), (float)(-((float)this.eye.y)), (float)(-((float)this.eye.z)));
    }

    private static class RenderUtil {
        public static final Vector3d UP_V = new Vector3d(0.0, 1.0, 0.0);
        public static final Vector3d ZERO_V = new Vector3d(0.0, 0.0, 0.0);
        private static final FloatBuffer MATRIX_BUFFER = GLAllocation.func_74529_h((int)16);
        public static final ResourceLocation BLOCK_TEX = TextureMap.field_110575_b;

        private RenderUtil() {
        }

        public static void loadMatrix(Matrix4d mat) {
            MATRIX_BUFFER.rewind();
            MATRIX_BUFFER.put((float)mat.m00);
            MATRIX_BUFFER.put((float)mat.m01);
            MATRIX_BUFFER.put((float)mat.m02);
            MATRIX_BUFFER.put((float)mat.m03);
            MATRIX_BUFFER.put((float)mat.m10);
            MATRIX_BUFFER.put((float)mat.m11);
            MATRIX_BUFFER.put((float)mat.m12);
            MATRIX_BUFFER.put((float)mat.m13);
            MATRIX_BUFFER.put((float)mat.m20);
            MATRIX_BUFFER.put((float)mat.m21);
            MATRIX_BUFFER.put((float)mat.m22);
            MATRIX_BUFFER.put((float)mat.m23);
            MATRIX_BUFFER.put((float)mat.m30);
            MATRIX_BUFFER.put((float)mat.m31);
            MATRIX_BUFFER.put((float)mat.m32);
            MATRIX_BUFFER.put((float)mat.m33);
            MATRIX_BUFFER.rewind();
            GL11.glLoadMatrix((FloatBuffer)MATRIX_BUFFER);
        }

        public static void bindBlockTexture() {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BLOCK_TEX);
        }

        public static void addVerticesToTessellator(List<Vertex> vertices, VertexFormat format, boolean doBegin) {
            if (vertices == null || vertices.isEmpty()) {
                return;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder tes = tessellator.func_178180_c();
            if (doBegin) {
                tes.func_181668_a(7, format);
            }
            for (Vertex v : vertices) {
                for (VertexFormatElement el : format.func_177343_g()) {
                    switch (el.func_177375_c()) {
                        case COLOR: {
                            if (el.func_177367_b() != VertexFormatElement.EnumType.FLOAT) break;
                            tes.func_181666_a(v.r(), v.g(), v.b(), v.a());
                            break;
                        }
                        case NORMAL: {
                            tes.func_181663_c(v.nx(), v.ny(), v.nz());
                            break;
                        }
                        case POSITION: {
                            tes.func_181662_b(v.x(), v.y(), v.z());
                            break;
                        }
                        case UV: {
                            if (el.func_177367_b() != VertexFormatElement.EnumType.FLOAT || v.uv == null) break;
                            tes.func_187315_a((double)v.u(), (double)v.v());
                            break;
                        }
                        case GENERIC: {
                            break;
                        }
                        case PADDING: {
                            break;
                        }
                    }
                }
                tes.func_181675_d();
            }
        }
    }

    public static class SelectedFace {
        public TileEntity config;
        public EnumFacing face;
        public RayTraceResult hit;

        public SelectedFace(TileEntity config, EnumFacing face, RayTraceResult hit) {
            this.config = config;
            this.face = face;
            this.hit = hit;
        }
    }
}

