/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.DrawableWord;
import network.rs485.logisticspipes.gui.guidebook.DrawableWordKt;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.GuideBookMouseInteractable;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\tJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J.\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0018\u00010\"R\u00020#H\u0016J\b\u0010$\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuGroup;", "T", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuideBookMouseInteractable;", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableParagraph;", "groupTitle", "", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "groupTiles", "(Ljava/util/List;Ljava/util/List;)V", "parent", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "drawChildren", "getHovered", "inBookMouseClicked", "", "mouseButton", "", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "setChildrenPos", "logisticspipes"})
public final class DrawableMenuGroup<T extends Drawable & GuideBookMouseInteractable>
extends DrawableParagraph {
    @NotNull
    private final List<DrawableWord> groupTitle;
    @NotNull
    private final List<T> groupTiles;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;

    public DrawableMenuGroup(@NotNull List<? extends DrawableWord> groupTitle, @NotNull List<? extends T> groupTiles) {
        Intrinsics.checkNotNullParameter(groupTitle, "groupTitle");
        Intrinsics.checkNotNullParameter(groupTiles, "groupTiles");
        this.groupTitle = groupTitle;
        this.groupTiles = groupTiles;
        this.relativeBody = new MutableRectangle();
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        this.drawChildren(mouseX, mouseY, delta, visibleArea);
    }

    @Override
    public boolean inBookMouseClicked(float mouseX, float mouseY, int mouseButton, @Nullable GuiGuideBook.ActionListener guideActionListener) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.groupTiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Drawable it = (Drawable)element$iv;
                boolean bl = false;
                if (!((GuideBookMouseInteractable)((Object)it)).isMouseHovering(mouseX, mouseY)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Drawable drawable = v0;
        return drawable != null ? ((GuideBookMouseInteractable)((Object)drawable)).inBookMouseClicked(mouseX, mouseY, mouseButton, guideActionListener) : false;
    }

    @Override
    public int setChildrenPos() {
        int currentY = 0;
        int currentX = 5;
        currentY += DrawableWordKt.splitAndInitialize(this.groupTitle, currentX, currentY, this.getWidth(), false);
        for (Drawable tile : this.groupTiles) {
            if (currentX + tile.getWidth() + 5 > this.getWidth()) {
                currentX = 5;
                currentY += tile.getHeight() + 5;
            }
            tile.setPos(currentX, currentY);
            currentX += tile.getWidth() + 5;
            if (!Intrinsics.areEqual(tile, CollectionsKt.last(this.groupTiles))) continue;
            currentY += tile.getHeight() + 5;
        }
        return currentY;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawChildren(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)this.groupTitle, (Iterable)this.groupTiles);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((Drawable)it).visible(visibleArea)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv;
            Object it = element$iv = object.next();
            boolean bl = false;
            ((Drawable)it).draw(mouseX, mouseY, delta, visibleArea);
        }
    }

    @Override
    @Nullable
    public Drawable getHovered(float mouseX, float mouseY) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.plus((Collection)this.groupTitle, (Iterable)this.groupTiles);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Drawable it = (Drawable)element$iv;
                boolean bl = false;
                if (!((GuideBookMouseInteractable)((Object)it)).isMouseHovering(mouseX, mouseY)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

