/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.List;
import logisticspipes.LPItems;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Lazy;
import logisticspipes.kotlin.LazyKt;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.DefaultConstructorMarker;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableMenuTile;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.GuideBookMouseInteractable;
import network.rs485.logisticspipes.gui.widget.Tooltipped;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001*B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dH\u0016J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0018\u00010#R\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0016J$\u0010&\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0'2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020!H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuTile;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuideBookMouseInteractable;", "Lnetwork/rs485/logisticspipes/gui/widget/Tooltipped;", "linkedPage", "", "pageName", "icon", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "iconBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "iconScale", "", "parent", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "getTooltipText", "", "inBookMouseClicked", "", "mouseButton", "", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "isMouseHovering", "setPos", "Llogisticspipes/kotlin/Pair;", "x", "y", "Companion", "logisticspipes"})
public final class DrawableMenuTile
implements Drawable,
GuideBookMouseInteractable,
Tooltipped {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String linkedPage;
    @NotNull
    private final String pageName;
    @NotNull
    private final String icon;
    private final float iconScale;
    @NotNull
    private final MutableRectangle iconBody;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;
    @NotNull
    private static final Lazy<ItemStackRenderer> itemStackRenderer$delegate = LazyKt.lazy(Companion.itemStackRenderer.2.INSTANCE);

    public DrawableMenuTile(@NotNull String linkedPage, @NotNull String pageName, @NotNull String icon) {
        Intrinsics.checkNotNullParameter(linkedPage, "linkedPage");
        Intrinsics.checkNotNullParameter(pageName, "pageName");
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.linkedPage = linkedPage;
        this.pageName = pageName;
        this.icon = icon;
        this.iconScale = 1.5f;
        this.iconBody = new MutableRectangle();
        this.relativeBody = new MutableRectangle();
        this.getRelativeBody().setSize(40, 40);
        this.iconBody.setSize((int)((float)16 * this.iconScale), (int)((float)16 * this.iconScale));
        this.iconBody.setPos(((float)40 - this.iconBody.getWidth()) / (float)2, ((float)40 - this.iconBody.getHeight()) / (float)2);
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    @Override
    @NotNull
    public List<String> getTooltipText() {
        return CollectionsKt.listOf(this.pageName);
    }

    @Override
    public boolean isMouseHovering(float mouseX, float mouseY) {
        return this.getAbsoluteBody().contains(mouseX, mouseY);
    }

    @Override
    public boolean inBookMouseClicked(float mouseX, float mouseY, int mouseButton, @Nullable GuiGuideBook.ActionListener guideActionListener) {
        Unit unit;
        GuiGuideBook.ActionListener actionListener = guideActionListener;
        if (actionListener != null) {
            actionListener.onMenuButtonClick(this.linkedPage);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit != null;
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        IRectangle itemRect;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        boolean hovered = this.isMouseHovering(mouseX, mouseY);
        GuiDrawer.INSTANCE.drawBorderedTile(this.getAbsoluteBody(), hovered, true, true, false);
        if (hovered) {
            GuiDrawer.INSTANCE.drawInteractionIndicator(mouseX, mouseY);
        }
        if (visibleArea.intersects(itemRect = this.iconBody.translated(this.getAbsoluteBody()))) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.icon));
            if (item == null) {
                item = LPItems.brokenItem;
            }
            Item item2 = item;
            Companion.getItemStackRenderer().renderItemInGui(itemRect.getLeft(), itemRect.getTop(), item2, 0.0f, this.iconScale);
        }
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> setPos(int x, int y) {
        this.getRelativeBody().setPos(x, y);
        return Drawable.super.setPos(x, y);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuTile$Companion;", "", "()V", "itemStackRenderer", "Llogisticspipes/utils/item/ItemStackRenderer;", "getItemStackRenderer", "()Llogisticspipes/utils/item/ItemStackRenderer;", "itemStackRenderer$delegate", "Llogisticspipes/kotlin/Lazy;", "logisticspipes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ItemStackRenderer getItemStackRenderer() {
            Lazy lazy = itemStackRenderer$delegate;
            return (ItemStackRenderer)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

