/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.guidebook;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kaml.Yaml;
import logisticspipes.kaml.YamlException;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.MapsKt;
import logisticspipes.kotlin.io.TextStreamsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.text.Charsets;
import logisticspipes.kotlin.text.Regex;
import logisticspipes.kotlin.text.RegexOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.guidebook.LoadedPage;
import network.rs485.logisticspipes.guidebook.PageInfoProvider;
import network.rs485.logisticspipes.guidebook.YamlPageMetadata;
import network.rs485.logisticspipes.util.TextUtil;
import network.rs485.markdown.HeaderParagraph;
import network.rs485.markdown.ImageParagraph;
import network.rs485.markdown.MarkdownParser;
import network.rs485.markdown.Paragraph;
import org.apache.commons.io.FilenameUtils;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u001a\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\t\u001a\u0014\u0010\u0012\u001a\u00020\t*\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"MISSING_META", "Lnetwork/rs485/logisticspipes/guidebook/YamlPageMetadata;", "getMISSING_META", "()Lnetwork/rs485/logisticspipes/guidebook/YamlPageMetadata;", "metadataRegex", "Llogisticspipes/kotlin/text/Regex;", "loadPage", "Lnetwork/rs485/logisticspipes/guidebook/PageInfoProvider;", "path", "", "lang", "parseMetadata", "metadataString", "markdownFile", "resolveAbsoluteLocation", "Ljava/nio/file/Path;", "resolvedLocation", "language", "toLocation", "absolute", "", "logisticspipes"})
public final class BookContentsKt {
    @NotNull
    private static final YamlPageMetadata MISSING_META = new YamlPageMetadata("[404] the metadata was not found :P", "logisticspipes:pipe_transport_basic", null, 4, null);
    @NotNull
    private static final Regex metadataRegex = new Regex("^\\s*<!---\\s*\\n(.*?)\\n\\s*--->\\s*(.*)$", RegexOption.DOT_MATCHES_ALL);

    @NotNull
    public static final YamlPageMetadata getMISSING_META() {
        return MISSING_META;
    }

    @NotNull
    public static final PageInfoProvider loadPage(@NotNull String path, @NotNull String lang) {
        PageInfoProvider pageInfoProvider;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(lang, "lang");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(path)");
        String resolvedLocation = BookContentsKt.toLocation(BookContentsKt.resolveAbsoluteLocation(path2, lang), false);
        try {
            IResource bookFile = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("logisticspipes", resolvedLocation));
            InputStream inputStream = bookFile.func_110527_b();
            Intrinsics.checkNotNullExpressionValue(inputStream, "bookFile.inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            pageInfoProvider = new LoadedPage(path, lang, CollectionsKt.joinToString$default(TextStreamsKt.readLines(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), "\n", null, null, 0, null, null, 62, null));
        }
        catch (IOException error) {
            PageInfoProvider pageInfoProvider2;
            if (!Intrinsics.areEqual(lang, "en_us")) {
                if (LogisticsPipes.isDEBUG()) {
                    LogisticsPipes.log.error("Language " + lang + " for the current file (" + resolvedLocation + ") was not found. Defaulting to en_us.");
                }
                pageInfoProvider2 = BookContentsKt.loadPage(path, "en_us");
            } else {
                Object[] objectArray = new Object[]{resolvedLocation};
                String translatedError = MessageFormat.format(TextUtil.translate("misc.guide_book.missing_page", new String[0]), objectArray);
                pageInfoProvider2 = new PageInfoProvider(lang, translatedError){
                    private final boolean bookmarkable;
                    @NotNull
                    private final String language;
                    @NotNull
                    private final String fileLocation;
                    @NotNull
                    private final YamlPageMetadata metadata;
                    @NotNull
                    private final List<Paragraph> paragraphs;
                    {
                        this.language = $lang;
                        this.fileLocation = "";
                        this.metadata = new YamlPageMetadata(TextUtil.translate("misc.guide_book.missing_page_title", new String[0]), "logisticspipes:broken_item", MapsKt.emptyMap());
                        Paragraph[] paragraphArray = new Paragraph[2];
                        paragraphArray[0] = new ImageParagraph("Not found image not found?", "guide_book_404");
                        Intrinsics.checkNotNullExpressionValue($translatedError, "translatedError");
                        paragraphArray[1] = new HeaderParagraph(MarkdownParser.INSTANCE.splitSpacesAndWords$logisticspipes($translatedError), 1);
                        this.paragraphs = CollectionsKt.listOf(paragraphArray);
                    }

                    public boolean getBookmarkable() {
                        return this.bookmarkable;
                    }

                    @NotNull
                    public String getLanguage() {
                        return this.language;
                    }

                    @NotNull
                    public String getFileLocation() {
                        return this.fileLocation;
                    }

                    @NotNull
                    public YamlPageMetadata getMetadata() {
                        return this.metadata;
                    }

                    @NotNull
                    public List<Paragraph> getParagraphs() {
                        return this.paragraphs;
                    }
                };
            }
            pageInfoProvider = pageInfoProvider2;
        }
        return pageInfoProvider;
    }

    private static final YamlPageMetadata parseMetadata(String metadataString, String markdownFile) {
        YamlPageMetadata yamlPageMetadata;
        if (((CharSequence)metadataString).length() > 0) {
            YamlPageMetadata yamlPageMetadata2;
            try {
                yamlPageMetadata2 = (YamlPageMetadata)Yaml.Companion.getDefault().decodeFromString(YamlPageMetadata.Companion.serializer(), metadataString);
            }
            catch (YamlException e) {
                LogisticsPipes.log.error("The following Yaml in " + markdownFile + " is malformed! \n" + metadataString, (Throwable)e);
                yamlPageMetadata2 = MISSING_META;
            }
            yamlPageMetadata = yamlPageMetadata2;
        } else {
            yamlPageMetadata = MISSING_META;
        }
        return yamlPageMetadata;
    }

    @NotNull
    public static final String toLocation(@NotNull Path $this$toLocation, boolean absolute) {
        String it;
        Intrinsics.checkNotNullParameter($this$toLocation, "<this>");
        String string = ((Object)$this$toLocation).toString();
        StringBuilder stringBuilder = new StringBuilder().append(absolute ? "/" : "");
        boolean bl = false;
        String string2 = it.substring(FilenameUtils.getPrefixLength((String)it));
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        it = string2;
        boolean bl2 = false;
        return stringBuilder.append(FilenameUtils.separatorsToUnix((String)it)).toString();
    }

    public static /* synthetic */ String toLocation$default(Path path, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = path.isAbsolute();
        }
        return BookContentsKt.toLocation(path, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Path resolveAbsoluteLocation(@NotNull Path resolvedLocation, @NotNull String language) {
        void $this$fold$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(resolvedLocation, "resolvedLocation");
        Intrinsics.checkNotNullParameter(language, "language");
        Path base = Paths.get("book/" + language, new String[0]);
        boolean bl = false;
        Path path = resolvedLocation.normalize();
        Intrinsics.checkNotNullExpressionValue(path, "resolvedLocation.normalize()");
        Iterable iterable = path;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path path2 = (Path)element$iv$iv;
            boolean bl2 = false;
            if (!(!path2.startsWith(".."))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$fold = false;
        Path accumulator$iv = base;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            Path path3 = (Path)element$iv;
            Path p0 = accumulator$iv;
            boolean bl3 = false;
            accumulator$iv = p0.resolve((Path)p1);
        }
        Path path4 = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue(path4, "get(\"book/$language\").le\u2026ase, Path::resolve)\n    }");
        return path4;
    }

    public static final /* synthetic */ Regex access$getMetadataRegex$p() {
        return metadataRegex;
    }

    public static final /* synthetic */ YamlPageMetadata access$parseMetadata(String metadataString, String markdownFile) {
        return BookContentsKt.parseMetadata(metadataString, markdownFile);
    }
}

