/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.property.layer;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.property.Property;
import network.rs485.logisticspipes.property.layer.PropertyOverlay;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u000bH\u0016J'\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0002\u0010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u0002H\u000e\"\u0004\b\u0002\u0010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0010\u0010\b\u001a\u00028\u0001X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0013"}, d2={"Lnetwork/rs485/logisticspipes/property/layer/SimplePropertyOverlay;", "T", "", "P", "Lnetwork/rs485/logisticspipes/property/Property;", "Lnetwork/rs485/logisticspipes/property/layer/PropertyOverlay;", "sourceProperty", "(Lnetwork/rs485/logisticspipes/property/Property;)V", "copiedProperty", "Lnetwork/rs485/logisticspipes/property/Property;", "isPropertyCopied", "", "isWriteMode", "read", "V", "func", "Llogisticspipes/kotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "write", "logisticspipes_api"})
public final class SimplePropertyOverlay<T, P extends Property<T>>
implements PropertyOverlay<T, P> {
    @NotNull
    private final P sourceProperty;
    private boolean isPropertyCopied;
    private P copiedProperty;

    public SimplePropertyOverlay(@NotNull P sourceProperty) {
        Intrinsics.checkNotNullParameter(sourceProperty, "sourceProperty");
        this.sourceProperty = sourceProperty;
    }

    @Override
    public <V> V read(@NotNull Function1<? super P, ? extends V> func) {
        V v;
        Intrinsics.checkNotNullParameter(func, "func");
        if (this.isPropertyCopied) {
            P p = this.copiedProperty;
            if (p == null) {
                Intrinsics.throwUninitializedPropertyAccessException("copiedProperty");
                p = null;
            }
            v = func.invoke(p);
        } else {
            v = func.invoke(this.sourceProperty);
        }
        return v;
    }

    @Override
    public <V> V write(@NotNull Function1<? super P, ? extends V> func) {
        P p;
        Intrinsics.checkNotNullParameter(func, "func");
        if (!this.isPropertyCopied) {
            Property property = this.sourceProperty.copyProperty();
            Intrinsics.checkNotNull(property, "null cannot be cast to non-null type P of network.rs485.logisticspipes.property.layer.SimplePropertyOverlay");
            this.copiedProperty = property;
            this.isPropertyCopied = true;
        }
        if ((p = this.copiedProperty) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("copiedProperty");
            p = null;
        }
        return func.invoke(p);
    }

    @Override
    public boolean isWriteMode() {
        return this.isPropertyCopied;
    }
}

