/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.network.IReadListObject;
import logisticspipes.network.IWriteListObject;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public final class LPDataIOWrapper
implements LPDataInput,
LPDataOutput {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final HashMap<Long, LPDataIOWrapper> BUFFER_WRAPPER_MAP = new HashMap();
    ByteBuf localBuffer;
    private int reference;

    private LPDataIOWrapper(ByteBuf buffer) {
        this.localBuffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static LPDataIOWrapper getInstance(ByteBuf buffer) {
        if (buffer.hasMemoryAddress()) {
            HashMap<Long, LPDataIOWrapper> hashMap = BUFFER_WRAPPER_MAP;
            synchronized (hashMap) {
                LPDataIOWrapper instance = BUFFER_WRAPPER_MAP.get(buffer.memoryAddress());
                if (instance == null) {
                    instance = new LPDataIOWrapper(buffer);
                    BUFFER_WRAPPER_MAP.put(buffer.memoryAddress(), instance);
                }
                ++instance.reference;
                return instance;
            }
        }
        return new LPDataIOWrapper(buffer);
    }

    public static void provideData(byte[] data, LPDataInput.LPDataInputConsumer dataInputConsumer) {
        ByteBuf dataBuffer = Unpooled.wrappedBuffer((byte[])data);
        LPDataIOWrapper lpData = LPDataIOWrapper.getInstance(dataBuffer);
        dataInputConsumer.accept(lpData);
        lpData.unsetBuffer();
        dataBuffer.release();
    }

    @Nonnull
    public static byte[] collectData(LPDataOutput.LPDataOutputConsumer dataOutputConsumer) {
        ByteBuf dataBuffer = Unpooled.buffer();
        LPDataIOWrapper lpData = LPDataIOWrapper.getInstance(dataBuffer);
        dataOutputConsumer.accept(lpData);
        lpData.unsetBuffer();
        byte[] data = new byte[dataBuffer.readableBytes()];
        dataBuffer.getBytes(0, data);
        dataBuffer.release();
        return data;
    }

    public static void provideData(ByteBuf dataBuffer, LPDataInput.LPDataInputConsumer dataInputConsumer) {
        if (dataBuffer.readableBytes() == 0) {
            return;
        }
        LPDataIOWrapper lpData = LPDataIOWrapper.getInstance(dataBuffer);
        dataInputConsumer.accept(lpData);
        lpData.unsetBuffer();
    }

    public static void writeData(ByteBuf dataBuffer, LPDataOutput.LPDataOutputConsumer dataOutputConsumer) {
        if (dataBuffer.writableBytes() == 0) {
            return;
        }
        LPDataIOWrapper lpData = LPDataIOWrapper.getInstance(dataBuffer);
        dataOutputConsumer.accept(lpData);
        lpData.unsetBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetBuffer() {
        if (this.localBuffer.hasMemoryAddress()) {
            HashMap<Long, LPDataIOWrapper> hashMap = BUFFER_WRAPPER_MAP;
            synchronized (hashMap) {
                if (--this.reference < 1) {
                    BUFFER_WRAPPER_MAP.remove(this.localBuffer.memoryAddress());
                }
            }
        }
        this.localBuffer = null;
    }

    @Override
    public void writeByteArray(@Nullable byte[] arr) {
        if (arr == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(arr.length);
            this.writeBytes(arr);
        }
    }

    @Override
    @Nullable
    public byte[] readByteArray() {
        int length = this.readInt();
        if (length == -1) {
            return null;
        }
        return this.readBytes(length);
    }

    @Override
    public void writeByte(int b) {
        this.localBuffer.writeByte(b);
    }

    @Override
    public void writeByte(byte b) {
        this.localBuffer.writeByte((int)b);
    }

    @Override
    public void writeShort(int s) {
        this.localBuffer.writeShort(s);
    }

    @Override
    public void writeShort(short b) {
        this.localBuffer.writeShort((int)b);
    }

    @Override
    public void writeInt(int i) {
        this.localBuffer.writeInt(i);
    }

    @Override
    public void writeLong(long l) {
        this.localBuffer.writeLong(l);
    }

    @Override
    public void writeFloat(float f) {
        this.localBuffer.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) {
        this.localBuffer.writeDouble(d);
    }

    @Override
    public void writeBoolean(boolean b) {
        this.localBuffer.writeBoolean(b);
    }

    @Override
    public void writeUTF(@Nullable String s) {
        if (s == null) {
            this.writeInt(-1);
        } else {
            this.writeByteArray(s.getBytes(UTF_8));
        }
    }

    @Override
    public void writeFacing(@Nullable EnumFacing direction) {
        if (direction == null) {
            this.writeByte((byte)-128);
        } else {
            this.writeByte(direction.ordinal());
        }
    }

    @Override
    public void writeResourceLocation(@Nullable ResourceLocation resource) {
        if (resource == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeUTF(resource.toString());
        }
    }

    @Override
    public <T extends Enum<T>> void writeEnumSet(EnumSet<T> types, Class<T> clazz) {
        Enum[] parts = (Enum[])clazz.getEnumConstants();
        int length = parts.length / 8 + (parts.length % 8 == 0 ? 0 : 1);
        byte[] set = new byte[length];
        for (Enum part : parts) {
            if (!types.contains(part)) continue;
            byte i = (byte)(1 << part.ordinal() % 8);
            int n = part.ordinal() / 8;
            set[n] = (byte)(set[n] | i);
        }
        this.writeByteArray(set);
    }

    @Override
    public void writeBitSet(@Nonnull BitSet bits) {
        this.writeLongArray(bits.toLongArray());
    }

    @Override
    public void writeNBTTagCompound(@Nullable NBTTagCompound tag) {
        if (tag == null) {
            this.writeByte(0);
        } else {
            this.writeByte(1);
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)output);
                this.writeByteArray(output.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeBooleanArray(@Nullable boolean[] arr) {
        if (arr == null) {
            this.writeInt(-1);
        } else if (arr.length == 0) {
            this.writeInt(0);
            this.writeByteArray(null);
        } else {
            BitSet bits = new BitSet(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                bits.set(i, arr[i]);
            }
            this.writeInt(arr.length);
            this.writeByteArray(bits.toByteArray());
        }
    }

    @Override
    public void writeUTFArray(@Nullable String[] arr) {
        if (arr == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(arr.length);
            for (String s : arr) {
                this.writeUTF(s);
            }
        }
    }

    @Override
    public void writeIntArray(@Nullable int[] arr) {
        if (arr == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(arr.length);
            for (int i : arr) {
                this.writeInt(i);
            }
        }
    }

    @Override
    public void writeItemStack(@Nonnull ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            this.writeInt(0);
        } else {
            this.writeInt(Item.func_150891_b((Item)itemstack.func_77973_b()));
            this.writeInt(itemstack.func_190916_E());
            this.writeInt(itemstack.func_77952_i());
            this.writeNBTTagCompound(itemstack.func_77978_p());
        }
    }

    @Override
    public void writeItemIdentifier(@Nullable ItemIdentifier item) {
        if (item == null) {
            this.writeInt(0);
        } else {
            this.writeInt(Item.func_150891_b((Item)item.item));
            this.writeInt(item.itemDamage);
            this.writeNBTTagCompound(item.tag);
        }
    }

    @Override
    public void writeItemIdentifierStack(@Nullable ItemIdentifierStack stack) {
        if (stack == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(stack.getStackSize());
            this.writeItemIdentifier(stack.getItem());
        }
    }

    @Override
    public <T> void writeCollection(@Nullable Collection<T> collection, IWriteListObject<T> handler) {
        if (collection == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(collection.size());
            for (T obj : collection) {
                handler.writeObject(this, obj);
            }
        }
    }

    @Override
    public <T extends Enum<T>> void writeEnum(T obj) {
        this.writeInt(obj.ordinal());
    }

    @Override
    public void writeByteBuf(ByteBuf otherBuffer) {
        this.writeInt(otherBuffer.readableBytes());
        this.localBuffer.writeBytes(otherBuffer, otherBuffer.readableBytes());
    }

    @Override
    public void writeLongArray(@Nullable long[] arr) {
        if (arr == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(arr.length);
            for (long l : arr) {
                this.writeLong(l);
            }
        }
    }

    @Override
    public void writeBytes(byte[] arr) {
        this.localBuffer.writeBytes(arr);
    }

    @Override
    public void writeChannelInformation(ChannelInformation channel) {
        this.writeUTF(channel.getName());
        this.writeUUID(channel.getChannelIdentifier());
        this.writePlayerIdentifier(channel.getOwner());
        this.writeEnum(channel.getRights());
        this.writeUUID(channel.getResponsibleSecurityID());
    }

    @Override
    public void writeUUID(@Nullable UUID uuid) {
        this.writeBoolean(uuid != null);
        if (uuid != null) {
            this.writeLong(uuid.getMostSignificantBits());
            this.writeLong(uuid.getLeastSignificantBits());
        }
    }

    @Override
    public void writePlayerIdentifier(PlayerIdentifier playerIdentifier) {
        this.writeUTF(playerIdentifier.getUsername());
        this.writeUUID(playerIdentifier.getId());
    }

    @Override
    public byte readByte() {
        return this.localBuffer.readByte();
    }

    @Override
    public short readShort() {
        return this.localBuffer.readShort();
    }

    @Override
    public int readInt() {
        return this.localBuffer.readInt();
    }

    @Override
    public long readLong() {
        return this.localBuffer.readLong();
    }

    @Override
    public float readFloat() {
        return this.localBuffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.localBuffer.readDouble();
    }

    @Override
    public boolean readBoolean() {
        return this.localBuffer.readBoolean();
    }

    @Override
    @Nullable
    public String readUTF() {
        byte[] arr = this.readByteArray();
        if (arr == null) {
            return null;
        }
        return new String(arr, UTF_8);
    }

    @Override
    @Nullable
    public EnumFacing readFacing() {
        byte b = this.localBuffer.readByte();
        if (b == -128) {
            return null;
        }
        if (b < 0 || b >= EnumFacing.field_82609_l.length) {
            throw new IndexOutOfBoundsException("Invalid value for EnumFacing");
        }
        return EnumFacing.field_82609_l[b];
    }

    @Override
    @Nullable
    public ResourceLocation readResourceLocation() {
        if (this.readBoolean()) {
            return new ResourceLocation(Objects.requireNonNull(this.readUTF()));
        }
        return null;
    }

    @Override
    @Nonnull
    public <T extends Enum<T>> EnumSet<T> readEnumSet(Class<T> clazz) {
        EnumSet<T> types = EnumSet.noneOf(clazz);
        byte[] arr = this.readByteArray();
        if (arr != null) {
            Enum[] parts;
            for (Enum part : parts = (Enum[])clazz.getEnumConstants()) {
                if ((arr[part.ordinal() / 8] & 1 << part.ordinal() % 8) == 0) continue;
                types.add(part);
            }
        }
        return types;
    }

    @Override
    @Nonnull
    public BitSet readBitSet() {
        long[] words = this.readLongArray();
        if (words == null) {
            return new BitSet();
        }
        return BitSet.valueOf(words);
    }

    @Override
    @Nullable
    public NBTTagCompound readNBTTagCompound() {
        boolean isEmpty2;
        boolean bl = isEmpty2 = this.readByte() == 0;
        if (isEmpty2) {
            return null;
        }
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(Objects.requireNonNull(this.readByteArray())));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Nullable
    public boolean[] readBooleanArray() {
        int bitCount = this.localBuffer.readInt();
        if (bitCount == -1) {
            return null;
        }
        byte[] data = this.readByteArray();
        if (bitCount == 0) {
            return new boolean[0];
        }
        if (data == null) {
            throw new NullPointerException("Boolean's byte array is null");
        }
        BitSet bits = BitSet.valueOf(data);
        boolean[] arr = new boolean[bitCount];
        IntStream.range(0, bitCount).forEach(i -> {
            arr[i] = bits.get(i);
        });
        return arr;
    }

    @Override
    @Nullable
    public String[] readUTFArray() {
        int length = this.localBuffer.readInt();
        if (length == -1) {
            return null;
        }
        String[] arr = new String[length];
        IntStream.range(0, length).forEach(i -> {
            arr[i] = this.readUTF();
        });
        return arr;
    }

    @Override
    @Nullable
    public int[] readIntArray() {
        int length = this.localBuffer.readInt();
        if (length == -1) {
            return null;
        }
        int[] arr = new int[length];
        IntStream.range(0, length).forEach(i -> {
            arr[i] = this.localBuffer.readInt();
        });
        return arr;
    }

    @Override
    @Nonnull
    public byte[] readBytes(int length) {
        byte[] arr = new byte[length];
        this.localBuffer.readBytes(arr, 0, length);
        return arr;
    }

    @Override
    @Nullable
    public ItemIdentifier readItemIdentifier() {
        int itemId = this.readInt();
        if (itemId == 0) {
            return null;
        }
        int damage = this.readInt();
        NBTTagCompound tag = this.readNBTTagCompound();
        return ItemIdentifier.get(Item.func_150899_d((int)itemId), damage, tag);
    }

    @Override
    @Nullable
    public ItemIdentifierStack readItemIdentifierStack() {
        int stacksize = this.readInt();
        if (stacksize == -1) {
            return null;
        }
        ItemIdentifier item = this.readItemIdentifier();
        if (item == null) {
            LogisticsPipes.log.error("Read null ItemIdentifier in readItemIdentifierStack");
            return null;
        }
        return new ItemIdentifierStack(item, stacksize);
    }

    @Override
    @Nonnull
    public ItemStack readItemStack() {
        int itemId = this.readInt();
        if (itemId == 0) {
            return ItemStack.field_190927_a;
        }
        int stackSize = this.readInt();
        int damage = this.readInt();
        ItemStack stack = new ItemStack(Item.func_150899_d((int)itemId), stackSize, damage);
        stack.func_77982_d(this.readNBTTagCompound());
        return stack;
    }

    @Override
    @Nullable
    public <T> ArrayList<T> readArrayList(IReadListObject<T> reader) {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(reader.readObject(this));
        }
        return list;
    }

    @Override
    @Nullable
    public <T> LinkedList<T> readLinkedList(IReadListObject<T> reader) {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        LinkedList<T> list = new LinkedList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(reader.readObject(this));
        }
        return list;
    }

    @Override
    @Nullable
    public <T> Set<T> readSet(IReadListObject<T> handler) {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        HashSet<T> set = new HashSet<T>(size);
        for (int i = 0; i < size; ++i) {
            set.add(handler.readObject(this));
        }
        return set;
    }

    @Override
    @Nullable
    public <T> NonNullList<T> readNonNullList(IReadListObject<T> reader, @Nonnull T fillItem) {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        NonNullList list = NonNullList.func_191197_a((int)size, fillItem);
        for (int i = 0; i < size; ++i) {
            T obj = reader.readObject(this);
            if (obj == null) continue;
            list.set(i, obj);
        }
        return list;
    }

    @Override
    @Nullable
    public <T extends Enum<T>> T readEnum(Class<T> clazz) {
        return (T)((Enum[])clazz.getEnumConstants())[this.localBuffer.readInt()];
    }

    @Override
    @Nonnull
    public ByteBuf readByteBuf() {
        byte[] arr = this.readByteArray();
        if (arr == null) {
            throw new NullPointerException("Buffer may not be null, but read null");
        }
        return Unpooled.wrappedBuffer((byte[])arr);
    }

    @Override
    @Nullable
    public long[] readLongArray() {
        int length = this.localBuffer.readInt();
        if (length == -1) {
            return null;
        }
        long[] arr = new long[length];
        IntStream.range(0, length).forEach(i -> {
            arr[i] = this.localBuffer.readLong();
        });
        return arr;
    }

    @Override
    @Nonnull
    public ChannelInformation readChannelInformation() {
        return new ChannelInformation(this.readUTF(), this.readUUID(), this.readPlayerIdentifier(), this.readEnum(ChannelInformation.AccessRights.class), this.readUUID());
    }

    @Override
    @Nullable
    public UUID readUUID() {
        if (!this.readBoolean()) {
            return null;
        }
        return new UUID(this.readLong(), this.readLong());
    }

    @Override
    @Nonnull
    public PlayerIdentifier readPlayerIdentifier() {
        return PlayerIdentifier.get(this.readUTF(), this.readUUID());
    }
}

