/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.base;

import binnie.core.machines.Machine;
import binnie.core.machines.base.DefaultMachineInventory;
import binnie.core.machines.base.DefaultPower;
import binnie.core.machines.base.DefaultTankContainer;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.machines.power.PowerInterface;
import binnie.core.machines.power.TankInfo;
import binnie.core.util.MjHelper;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.IMjRedstoneReceiver;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")
public class TileEntityMachineBase
extends TileEntity
implements IInventoryMachine,
ITankMachine,
IPoweredMachine,
ITickable,
IEnergySink {
    @Override
    public IInventoryMachine getInventory() {
        IInventoryMachine inv = Machine.getInterface(IInventoryMachine.class, this);
        return inv == null || inv == this ? new DefaultMachineInventory() : inv;
    }

    public ITankMachine getTankContainer() {
        ITankMachine inv = Machine.getInterface(ITankMachine.class, this);
        return inv == null || inv == this ? DefaultTankContainer.INSTANCE : inv;
    }

    public IPoweredMachine getPower() {
        IPoweredMachine inv = Machine.getInterface(IPoweredMachine.class, this);
        return inv == null || inv == this ? DefaultPower.INSTANCE : inv;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return this.getInventory().func_70304_b(index);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.func_145837_r() && this.func_145831_w().func_175625_s(this.func_174877_v()) == this && entityplayer.func_174831_c(this.func_174877_v()) <= 64.0 && this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.getInventory().func_70296_d();
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.getInventory().func_180463_a(side);
    }

    public boolean func_180462_a(int i, ItemStack itemstack, EnumFacing j) {
        return this.getInventory().func_180462_a(i, itemstack, j);
    }

    public boolean func_180461_b(int i, ItemStack itemstack, EnumFacing j) {
        return this.getInventory().func_180461_b(i, itemstack, j);
    }

    @Override
    public PowerInfo getPowerInfo() {
        return this.getPower().getPowerInfo();
    }

    @Override
    public TankInfo[] getTankInfos() {
        return this.getTankContainer().getTankInfos();
    }

    @Override
    public boolean isTankReadOnly(int index) {
        return this.getTankContainer().isTankReadOnly(index);
    }

    @Override
    public boolean isLiquidValidForTank(FluidStack liquid, int index) {
        return this.getTankContainer().isLiquidValidForTank(liquid, index);
    }

    @Override
    public TankSlot addTank(int index, String name, int capacity) {
        return this.getTankContainer().addTank(index, name, capacity);
    }

    @Override
    public TankSlot addTank(int index, ResourceLocation name, int capacity) {
        return this.getTankContainer().addTank(index, name, capacity);
    }

    @Override
    public IFluidTank getTank(int index) {
        return this.getTankContainer().getTank(index);
    }

    @Override
    public TankSlot getTankSlot(int index) {
        return this.getTankContainer().getTankSlot(index);
    }

    @Override
    public IFluidTank[] getTanks() {
        return this.getTankContainer().getTanks();
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return this.getPower().getDemandedEnergy();
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return this.getPower().getSinkTier();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return this.getPower().injectEnergy(directionFrom, amount, voltage);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return this.getPower().acceptsEnergyFrom(emitter, direction);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.getPower().receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.getPower().extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.getPower().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getPower().getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.getPower().canExtract();
    }

    @Override
    public boolean canReceive() {
        return this.getPower().canReceive();
    }

    @Optional.Method(modid="buildcraftlib")
    public long extractPower(long min, long max, boolean simulate) {
        return this.getPower().extractPower(min, max, simulate);
    }

    @Optional.Method(modid="buildcraftlib")
    public long getStored() {
        return this.getPower().getStored();
    }

    @Optional.Method(modid="buildcraftlib")
    public long getCapacity() {
        return this.getPower().getCapacity();
    }

    @Optional.Method(modid="buildcraftlib")
    public long getPowerRequested() {
        return this.getPower().getPowerRequested();
    }

    @Optional.Method(modid="buildcraftlib")
    public long receivePower(long microJoules, boolean simulate) {
        return this.getPower().receivePower(microJoules, simulate);
    }

    @Optional.Method(modid="buildcraftlib")
    public boolean canConnect(@Nonnull IMjConnector other) {
        return this.getPower().canConnect(other);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && (this.canExtract() || this.canReceive()) || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getTankContainer() != DefaultTankContainer.INSTANCE || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                SidedInvWrapper sidedInvWrapper = new SidedInvWrapper((ISidedInventory)this.getInventory(), facing);
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)sidedInvWrapper);
            }
            InvWrapper invWrapper = new InvWrapper((IInventory)this.getInventory());
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)invWrapper);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getHandler(facing));
        }
        if (MjHelper.isMjCapability(capability)) {
            Capability<IMjConnector> mjConnector = MjHelper.CAP_CONNECTOR;
            Capability<IMjPassiveProvider> mjPassiveProvider = MjHelper.CAP_PASSIVE_PROVIDER;
            Capability<IMjReadable> mjReadable = MjHelper.CAP_READABLE;
            Capability<IMjReceiver> mjReceiver = MjHelper.CAP_RECEIVER;
            Capability<IMjRedstoneReceiver> mjRedstoneReceiver = MjHelper.CAP_REDSTONE_RECEIVER;
            if (capability == mjPassiveProvider) {
                return (T)mjPassiveProvider.cast((Object)this);
            }
            if (capability == mjReceiver) {
                return (T)mjReceiver.cast((Object)this);
            }
            if (capability == mjRedstoneReceiver) {
                return (T)mjRedstoneReceiver.cast((Object)this);
            }
            if (capability == mjReadable) {
                return (T)mjReadable.cast((Object)this);
            }
            if (capability == mjConnector) {
                return (T)mjConnector.cast((Object)this);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public PowerInterface getInterface() {
        return this.getPower().getInterface();
    }

    public void func_73660_a() {
    }

    @Override
    @Nullable
    public IFluidHandler getHandler(@Nullable EnumFacing from) {
        return this.getTankContainer().getHandler(from);
    }

    @Override
    @Nullable
    public IFluidHandler getHandler(int[] targetTanks) {
        return this.getTankContainer().getHandler(targetTanks);
    }
}

