/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import forestry.api.apiculture.hives.IHiveGen;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class WorldGenHiveMarble
implements IHiveGen {
    private final Set<Block> validBlocks = new HashSet<Block>();

    public WorldGenHiveMarble() {
        OreDictionary.getOres((String)"stoneMarble").stream().filter(s -> s.func_77973_b() instanceof ItemBlock).map(s -> ((ItemBlock)s.func_77973_b()).func_179223_d()).forEach(this.validBlocks::add);
    }

    @Nullable
    public BlockPos getPosForHive(World world, int x, int z) {
        BlockPos topPos = world.func_175645_m(new BlockPos(x, 0, z));
        int worldHeight = topPos.func_177956_o();
        if (topPos.func_177956_o() <= 0) {
            return null;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);
        for (int i = 0; i < 10; ++i) {
            pos.func_185336_p(world.field_73012_v.nextInt(worldHeight));
            if (!this.isValidLocation(world, (BlockPos)pos)) continue;
            return pos;
        }
        return null;
    }

    public boolean isValidLocation(World world, BlockPos pos) {
        Block blockAtPos = world.func_180495_p(pos).func_177230_c();
        if (world.func_175623_d(pos) || !this.validBlocks.contains(blockAtPos)) {
            return false;
        }
        int otherFace = 0;
        for (EnumFacing face : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(blockAtPos)) continue;
            ++otherFace;
        }
        return otherFace >= 1;
    }

    public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return this.validBlocks.contains(block);
    }
}

