/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.core.Binnie;
import binnie.core.ModId;
import binnie.core.api.genetics.IFieldKitPlugin;
import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.ITexture;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.ForestryAllele;
import binnie.core.genetics.Tolerance;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.resource.textures.StandardTexture;
import binnie.core.texture.BinnieCoreTexture;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.ILepidopteristTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class MothBreedingSystem
extends BreedingSystem {
    public MothBreedingSystem() {
        this.iconUndiscovered = Binnie.RESOURCE.getItemSprite(ExtraTrees.instance, "icon/undiscovered_moth");
        this.iconDiscovered = Binnie.RESOURCE.getItemSprite(ExtraTrees.instance, "icon/discovered_moth");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAlleleSpecies firstSpecies, IAlleleSpecies secondSpecies) {
        return 0.0f;
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return ButterflyManager.butterflyRoot;
    }

    @Override
    public int getColour() {
        return 62194;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return ILepidopteristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumButterflyChromosome.METABOLISM) {
            int metabolism = ((IAlleleInteger)allele).getValue();
            if (metabolism >= 19) {
                return I18N.localise(ModId.EXTRA_TREES, "allele.metabolism.highest", new Object[0]);
            }
            if (metabolism >= 16) {
                return I18N.localise(ModId.EXTRA_TREES, "allele.metabolism.higher", new Object[0]);
            }
            if (metabolism >= 13) {
                return I18N.localise(ModId.EXTRA_TREES, "allele.metabolism.high", new Object[0]);
            }
            if (metabolism >= 10) {
                return I18N.localise(ModId.EXTRA_TREES, "allele.metabolism.normal", new Object[0]);
            }
            if (metabolism >= 7) {
                return I18N.localise(ModId.EXTRA_TREES, "allele.metabolism.slow", new Object[0]);
            }
            if (metabolism >= 4) {
                return I18N.localise(ModId.EXTRA_TREES, "allele.metabolism.slower", new Object[0]);
            }
            return I18N.localise(ModId.EXTRA_TREES, "allele.metabolism.slowest", new Object[0]);
        }
        if (chromosome == EnumButterflyChromosome.FERTILITY) {
            int metabolism = ((IAlleleInteger)allele).getValue();
            return metabolism + "x";
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        ISpeciesType type = this.getSpeciesRoot().getType(member);
        return type != null && this.isDNAManipulable(type);
    }

    @Override
    public boolean isDNAManipulable(ISpeciesType type) {
        return type == EnumFlutterType.SERUM;
    }

    @Override
    public ISpeciesType[] getActiveTypes() {
        return new ISpeciesType[]{EnumFlutterType.BUTTERFLY, EnumFlutterType.CATERPILLAR, EnumFlutterType.SERUM};
    }

    @Override
    public void addExtraAlleles(IChromosomeType chromosome, TreeSet<IAllele> alleles) {
        switch ((EnumButterflyChromosome)chromosome) {
            case FERTILITY: 
            case METABOLISM: {
                for (ForestryAllele.Int a : ForestryAllele.Int.values()) {
                    alleles.add(a.getAllele());
                }
                break;
            }
            case LIFESPAN: {
                for (ForestryAllele.Lifespan a2 : ForestryAllele.Lifespan.values()) {
                    alleles.add(a2.getAllele());
                }
                break;
            }
            case TOLERANT_FLYER: 
            case FIRE_RESIST: 
            case NOCTURNAL: {
                for (ForestryAllele.Bool a3 : ForestryAllele.Bool.values()) {
                    alleles.add(a3.getAllele());
                }
                break;
            }
            case SIZE: {
                for (ForestryAllele.Size a4 : ForestryAllele.Size.values()) {
                    alleles.add(a4.getAllele());
                }
                break;
            }
            case SPEED: {
                for (ForestryAllele.Speed a5 : ForestryAllele.Speed.values()) {
                    alleles.add(a5.getAllele());
                }
                break;
            }
            case HUMIDITY_TOLERANCE: 
            case TEMPERATURE_TOLERANCE: {
                for (Tolerance tolerance : Tolerance.values()) {
                    alleles.add(tolerance.getAllele());
                }
                break;
            }
        }
    }

    @Override
    public IFieldKitPlugin getFieldKitPlugin() {
        return new FieldKitPlugin();
    }

    private static class FieldKitPlugin
    implements IFieldKitPlugin {
        private FieldKitPlugin() {
        }

        @Override
        public Map<IChromosomeType, IPoint> getChromosomePickerPositions() {
            HashMap<IChromosomeType, IPoint> positions = new HashMap<IChromosomeType, IPoint>();
            positions.put((IChromosomeType)EnumButterflyChromosome.SPECIES, new Point(40, 40));
            positions.put((IChromosomeType)EnumButterflyChromosome.SIZE, new Point(63, 32));
            positions.put((IChromosomeType)EnumButterflyChromosome.SPEED, new Point(32, 63));
            positions.put((IChromosomeType)EnumButterflyChromosome.LIFESPAN, new Point(11, 27));
            positions.put((IChromosomeType)EnumButterflyChromosome.METABOLISM, new Point(16, 12));
            positions.put((IChromosomeType)EnumButterflyChromosome.FERTILITY, new Point(17, 63));
            positions.put((IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE, new Point(34, 12));
            positions.put((IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE, new Point(22, 46));
            positions.put((IChromosomeType)EnumButterflyChromosome.NOCTURNAL, new Point(53, 26));
            positions.put((IChromosomeType)EnumButterflyChromosome.TOLERANT_FLYER, new Point(71, 53));
            positions.put((IChromosomeType)EnumButterflyChromosome.FIRE_RESIST, new Point(78, 12));
            positions.put((IChromosomeType)EnumButterflyChromosome.FLOWER_PROVIDER, new Point(55, 55));
            positions.put((IChromosomeType)EnumButterflyChromosome.EFFECT, new Point(27, 31));
            positions.put((IChromosomeType)EnumButterflyChromosome.COCOON, new Point(87, 45));
            return positions;
        }

        @Override
        public ITexture getTypeTexture() {
            return new StandardTexture(96, 96, 96, 96, BinnieCoreTexture.GUI_BREEDING);
        }
    }
}

