/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.source;

import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.biome.Biome;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.biome.Biomes;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.layer.BiomeLayer;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.layer.composite.VoronoiLayer;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.layer.end.EndBiomeLayer;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.layer.end.EndHeightLayer;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.layer.end.EndSimplexLayer;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.biomeutils.source.LayeredBiomeSource;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mcutils.state.Dimension;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mcutils.util.pos.BPos;
import mod.bespectacled.modernbetareleaseplus.relocated.kaptainwutax.mcutils.version.MCVersion;

public class EndBiomeSource
extends LayeredBiomeSource<BiomeLayer> {
    public EndSimplexLayer simplex;
    public EndHeightLayer height;
    public EndBiomeLayer full;
    public VoronoiLayer voronoi;

    public EndBiomeSource(MCVersion version, long worldSeed) {
        super(version, worldSeed);
        this.build();
    }

    @Override
    public Dimension getDimension() {
        return Dimension.END;
    }

    protected void build() {
        this.simplex = new EndSimplexLayer(this.getVersion(), this.getWorldSeed());
        this.layers.add(this.simplex);
        this.height = new EndHeightLayer(this.getVersion(), this.simplex);
        this.layers.add(this.height);
        this.full = new EndBiomeLayer(this.getVersion(), this.height);
        this.layers.add(this.full);
        this.voronoi = new VoronoiLayer(this.getVersion(), this.getWorldSeed(), false, this.full){

            @Override
            public int sample(int x, int y, int z) {
                return this.getVersion().isOlderThan(MCVersion.v1_13) ? Biomes.THE_END.getId() : super.sample(x, y, z);
            }
        };
        this.layers.add(this.voronoi);
        this.layers.setScales();
    }

    @Override
    public Biome getBiome(BPos bpos) {
        return Biomes.REGISTRY.get(this.voronoi.get(bpos.getX(), 0, bpos.getZ()));
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        return Biomes.REGISTRY.get(this.voronoi.get(x, 0, z));
    }

    public Biome getBiome3D(int x, int y, int z) {
        return Biomes.REGISTRY.get(this.voronoi.get(x, y, z));
    }

    @Override
    public Biome getBiomeForNoiseGen(int x, int y, int z) {
        return Biomes.REGISTRY.get(this.full.get(x, 0, z));
    }
}

