/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tape;

import java.io.File;
import java.util.Random;
import net.minecraftforge.common.DimensionManager;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.tape.TapeStorage;
import pl.asie.lib.util.MiscUtils;

public class StorageManager {
    private static Random rand = new Random();

    private File saveDir() {
        File saveDir;
        File currentSaveRootDirectory = DimensionManager.getCurrentSaveRootDirectory();
        if (currentSaveRootDirectory == null) {
            Computronics.log.error("COULD NOT CREATE SAVE DIRECTORY: No parent save directory found!");
        }
        if (!(saveDir = new File(currentSaveRootDirectory, "computronics")).exists() && !saveDir.mkdir()) {
            Computronics.log.error("COULD NOT CREATE SAVE DIRECTORY: " + saveDir.getAbsolutePath());
        }
        return saveDir;
    }

    private String filename(String storageName) {
        return storageName + ".dsk";
    }

    public TapeStorage newStorage(int size) {
        byte[] nameHex;
        String storageName;
        do {
            nameHex = new byte[16];
            rand.nextBytes(nameHex);
        } while (this.exists(storageName = MiscUtils.asHexString(nameHex)));
        return this.get(storageName, size, 0);
    }

    public boolean exists(String name) {
        return new File(this.saveDir(), this.filename(name)).exists();
    }

    public TapeStorage get(String name, int size, int position) {
        return new TapeStorage(name, new File(this.saveDir(), this.filename(name)), size, position);
    }
}

