/*
 * Decompiled with CFR 0.152.
 */
package silly511.backups.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.attribute.FileTime;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GzipOutputStream
extends DeflaterOutputStream {
    private CRC32 crc = new CRC32();

    public GzipOutputStream(OutputStream stream, FileTime modTime) throws IOException {
        this(stream, modTime, 512);
    }

    public GzipOutputStream(OutputStream stream, FileTime modTime, int bufSize) throws IOException {
        super(stream, new Deflater(9, true), bufSize);
        ByteBuffer b = ByteBuffer.allocate(10);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.put((byte)31);
        b.put((byte)-117);
        b.put((byte)8);
        b.put((byte)0);
        b.putInt((int)(modTime.toMillis() / 1000L));
        b.put((byte)2);
        b.put((byte)-1);
        stream.write(b.array());
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.crc.update(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.crc.update(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.crc.update(b, off, len);
    }

    @Override
    public void finish() throws IOException {
        if (!this.def.finished()) {
            super.finish();
            ByteBuffer b = ByteBuffer.allocate(8);
            b.order(ByteOrder.LITTLE_ENDIAN);
            b.putInt((int)this.crc.getValue());
            b.putInt(this.def.getTotalIn());
            this.out.write(b.array());
        }
    }
}

