/*
 * Decompiled with CFR 0.152.
 */
package com.kmecpp.bis;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="BetterInvalidSession", name="BetterInvalidSession", version="1.0.3", acceptedMinecraftVersions="[1.12.2]")
public class BetterInvalidSession {
    public static final String NAME = "BetterInvalidSession";
    public static final String VERSION = "1.0.3";
    private static final Logger logger = Logger.getLogger("BetterInvalidSession");
    private static String kickMessage;
    private static String reAuthKickMessage;
    private static boolean isReAuthLoaded;
    private static final String DEFAULT_KICK_MESSAGE = "Invalid session (you probably opened another game launcher) \n\nRestart your game AND game launcher to login again";
    private static final String DEFAULT_REAUTH_KICK_MESSAGE = "Invalid session (you probably opened another game launcher) \n\nLogin again using the \"Re-Login\" button in the top left of the multiplayer menu or restart your game and game launcher";
    private static boolean attempted;

    @Mod.EventHandler
    public void init(FMLLoadCompleteEvent event) {
        Configuration config = new Configuration(new File("config", "BetterInvalidSession.cfg"), VERSION);
        kickMessage = config.getString("kick-message", "general", DEFAULT_KICK_MESSAGE.replace("\n", "\\n"), "Kick message if the client is disconnected from a server due to having an invalid session");
        reAuthKickMessage = config.getString("reauth-kick-message", "general", DEFAULT_REAUTH_KICK_MESSAGE.replace("\n", "\\n"), "Kick message if ReAuth is installed");
        isReAuthLoaded = Loader.isModLoaded((String)"reauth");
        kickMessage = kickMessage.replace("\\n", "\n");
        reAuthKickMessage = reAuthKickMessage.replace("\\n", "\n");
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void on(GuiOpenEvent event) {
        if (!attempted && event.getGui() instanceof GuiMainMenu) {
            attempted = true;
            try {
                Field instanceField = ObfuscationReflectionHelper.findField(LanguageMap.class, (String)"instance");
                instanceField.setAccessible(true);
                LanguageMap t = (LanguageMap)instanceField.get(null);
                Field mapField = ObfuscationReflectionHelper.findField(LanguageMap.class, (String)"languageList");
                mapField.setAccessible(true);
                Map m = (Map)mapField.get(t);
                m.put("disconnect.loginFailedInfo.invalidSession", isReAuthLoaded ? reAuthKickMessage : kickMessage);
                logger.info("Injected custom invalid session message successfully");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        attempted = false;
    }
}

