/*
 * Decompiled with CFR 0.152.
 */
package com.zumbio.classicfabs.init;

import com.zumbio.classicfabs.block.BlockLavaFabricator;
import com.zumbio.classicfabs.block.BlockOilFabricator;
import com.zumbio.classicfabs.config.ClassicFabricatorsConfig;
import com.zumbio.classicfabs.tile.TileLavaFabricator;
import com.zumbio.classicfabs.tile.TileOilFabricator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ModBlocks {
    public static List<Block> blocks = new ArrayList<Block>();
    public static Block LAVA_FABRICATOR = new BlockLavaFabricator();
    public static Block OIL_FABRICATOR = new BlockOilFabricator();

    public static void init() {
        if (ClassicFabricatorsConfig.lavaFabricatorEnable.booleanValue()) {
            blocks.add(LAVA_FABRICATOR);
            GameRegistry.registerTileEntity(TileLavaFabricator.class, (ResourceLocation)new ModelResourceLocation("lava_fabricator", "inventory"));
        }
        if (ClassicFabricatorsConfig.oilFabricatorEnabled.booleanValue()) {
            blocks.add(OIL_FABRICATOR);
            GameRegistry.registerTileEntity(TileOilFabricator.class, (ResourceLocation)new ModelResourceLocation("oil_fabricator", "inventory"));
        }
    }

    public static void registerRenders() {
        Iterator<Block> blockIterator = blocks.iterator();
        int meta = 0;
        while (blockIterator.hasNext()) {
            ModBlocks.registerRender(blockIterator.next(), meta);
        }
    }

    private static void registerRender(Block block, int meta) {
        System.out.println(block.getRegistryName());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), ""));
    }
}

