/*
 * Decompiled with CFR 0.152.
 */
package com.zumbio.classicfabs.tile;

import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.StringUtilBC;
import com.zumbio.classicfabs.config.ClassicFabricatorsConfig;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileFabricator
extends TileEntity
implements ITickable,
IEnergySink,
IFluidHandler {
    protected boolean loaded = false;
    protected int capacity = 32000;
    protected int storedEnergy = 0;
    protected int maxStoredEnergy = 1600;
    protected FluidTank tank;
    protected Fluid fluid;
    protected int pricePerMB;

    public TileFabricator(Fluid fluid, int pricePerMB, int maxStoredEnergy, int capacity) {
        this.fluid = fluid;
        this.pricePerMB = pricePerMB;
        this.maxStoredEnergy = maxStoredEnergy;
        this.capacity = capacity;
        this.tank = new FluidTank(capacity);
        this.tank.setCanFill(false);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.loaded) {
            this.loaded = true;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
        if (this.tank.getFluid() != null && this.tank.getFluid().amount == this.tank.getCapacity()) {
            return;
        }
        if (this.storedEnergy >= this.pricePerMB) {
            int fillAmount = this.storedEnergy / this.pricePerMB;
            int liquidUsed = this.tank.fillInternal(new FluidStack(this.fluid, fillAmount), true);
            this.storedEnergy -= liquidUsed * this.pricePerMB;
            this.func_70296_d();
        }
        if (!ClassicFabricatorsConfig.outputFluidAutomatically.booleanValue()) {
            return;
        }
        TileFabricator.pushFluidAround((IBlockAccess)this.field_145850_b, this.field_174879_c, this.tank);
    }

    public static void pushFluidAround(IBlockAccess world, BlockPos pos, FluidTank tank) {
        FluidStack actuallyDrained;
        FluidStack potential = tank.drain(tank.getFluidAmount(), false);
        int drained = 0;
        if (potential == null || potential.amount <= 0) {
            return;
        }
        FluidStack working = potential.copy();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int used;
            IFluidHandler handler;
            if (potential.amount <= 0) break;
            TileEntity target = world.func_175625_s(pos.func_177972_a(side));
            if (target == null || (handler = (IFluidHandler)target.getCapability(CapUtil.CAP_FLUIDS, side.func_176734_d())) == null || (used = handler.fill(potential.copy(), true)) <= 0) continue;
            drained += used;
            potential.amount -= used;
        }
        if (drained > 0 && ((actuallyDrained = tank.drain(drained, true)) == null || actuallyDrained.amount != drained)) {
            String strWorking = StringUtilBC.fluidToString((FluidStack)working);
            String strActual = StringUtilBC.fluidToString((FluidStack)actuallyDrained);
            throw new IllegalStateException("Bad tank! Could drain " + strWorking + " but only drained " + strActual + "( tank " + tank.getClass() + ")");
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storedEnergy = compound.func_74762_e("StoredEnergy");
        int storedFluidAmount = compound.func_74762_e("StoredLiquid");
        if (storedFluidAmount > 0) {
            this.tank.fillInternal(new FluidStack(this.fluid, storedFluidAmount), true);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("StoredEnergy", this.storedEnergy);
        compound.func_74768_a("StoredLiquid", this.tank.getFluidAmount());
        return compound;
    }

    public double getDemandedEnergy() {
        return this.maxStoredEnergy - this.storedEnergy;
    }

    public int getSinkTier() {
        return 3;
    }

    public double injectEnergy(EnumFacing enumFacing, double amount, double voltage) {
        this.storedEnergy += (int)Math.floor(amount);
        return 0.0;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return true;
    }

    public void onChunkUnload() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        super.onChunkUnload();
        this.loaded = false;
    }

    public void func_145843_s() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
        super.func_145843_s();
        this.loaded = false;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }
}

