/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.block;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thefloydman.moremystcraft.MoreMystcraft;
import thefloydman.moremystcraft.block.BlockJourneyBase;
import thefloydman.moremystcraft.capability.journeyhub.ICapabilityHub;
import thefloydman.moremystcraft.capability.journeyhub.ProviderCapabilityHub;
import thefloydman.moremystcraft.data.worldsaveddata.MoreMystcraftSavedDataPerSave;
import thefloydman.moremystcraft.gui.MoreMystcraftGUIs;
import thefloydman.moremystcraft.network.MoreMystcraftPacketHandler;
import thefloydman.moremystcraft.tileentity.TileEntityJourney;
import thefloydman.moremystcraft.tileentity.TileEntitySingleItem;
import thefloydman.moremystcraft.util.JourneyUtils;
import thefloydman.moremystcraft.util.Reference;

public class BlockJourneyHub
extends BlockJourneyBase {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockJourneyHub(JourneyUtils.PatternType type) {
        super(type, Material.field_151573_f);
        this.func_149663_c("moremystcraft.journey_hub_" + type.name().toLowerCase());
        this.setRegistryName(Reference.forMoreMystcraft("journey_hub_" + type.name().toLowerCase()));
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity;
        int power = 0;
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && side.equals((Object)((EnumFacing)blockState.func_177229_b((IProperty)field_185512_D))) && (tileEntity = blockAccess.func_175625_s(pos)) instanceof TileEntitySingleItem) {
            ICapabilityHub capStack = (ICapabilityHub)((TileEntitySingleItem)tileEntity).getItem().getCapability(ProviderCapabilityHub.HUB, side);
            MoreMystcraftSavedDataPerSave data = MoreMystcraftSavedDataPerSave.get(tileEntity.func_145831_w());
            List<UUID> uuids = capStack.getUUIDs();
            for (UUID id : uuids) {
                if (capStack.getPerPlayer()) {
                    power += data.journeyClothActivatedByPlayer(id, capStack.getLastActivatedBy()) ? 1 : 0;
                    continue;
                }
                power += data.journeyClothActivatedByAnyone(id) ? 1 : 0;
            }
        }
        return MathHelper.func_76125_a((int)power, (int)0, (int)15);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityJourney(JourneyUtils.BlockType.HUB);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, POWERED});
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntitySingleItem) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(1);
            ICapabilityHub cap = (ICapabilityHub)newStack.getCapability(ProviderCapabilityHub.HUB, null);
            if (cap != null) {
                cap.setOwner(placer.func_110124_au());
            }
            TileEntitySingleItem hubEntity = (TileEntitySingleItem)tileEntity;
            hubEntity.setItem(newStack);
            world.func_184138_a(pos, state, state, 3);
        }
        this.notifyNeighbors(world, pos, state);
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof TileEntitySingleItem) {
                    ICapabilityHub capStack = (ICapabilityHub)((TileEntitySingleItem)tileEntity).getItem().getCapability(ProviderCapabilityHub.HUB, facing);
                    if (capStack != null) {
                        if (!capStack.getOwner().equals(player.func_110124_au())) {
                            return false;
                        }
                        capStack.updateClothInfo(world);
                    }
                    world.func_184138_a(pos, state, state, 3);
                    player.openGui((Object)MoreMystcraft.instance, MoreMystcraftGUIs.JOURNEY_HUB.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            } else if (!this.isPowered(state)) {
                ICapabilityHub capStack;
                world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
                this.notifyNeighbors(world, pos, state);
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof TileEntitySingleItem && (capStack = (ICapabilityHub)((TileEntitySingleItem)tileEntity).getItem().getCapability(ProviderCapabilityHub.HUB, facing)) != null) {
                    capStack.setLastActivatedBy(player.func_110124_au());
                    MoreMystcraftPacketHandler.renderJourneyActivation((EntityPlayerMP)player, pos);
                    if (capStack.getTimeLimit() != 0) {
                        world.func_180497_b(pos, (Block)this, capStack.getTimeLimit(), 0);
                    }
                    world.func_184138_a(pos, state, state, 3);
                }
            }
        }
        return true;
    }

    public boolean isPowered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && this.isPowered(state)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            this.notifyNeighbors(world, pos, state);
            world.func_175704_b(pos, pos);
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }
}

