/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.capability.journeyhub;

import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import thefloydman.moremystcraft.capability.journeyhub.ICapabilityHub;

public class StorageCapabilityHub
implements Capability.IStorage<ICapabilityHub> {
    public NBTBase writeNBT(Capability<ICapabilityHub> capability, ICapabilityHub instance, EnumFacing side) {
        NBTTagCompound main = new NBTTagCompound();
        if (instance != null) {
            NBTTagList list = new NBTTagList();
            if (instance.getUUIDs().size() > 0) {
                for (UUID id : instance.getUUIDs()) {
                    NBTTagCompound cloth = new NBTTagCompound();
                    cloth.func_74782_a("uuid", (NBTBase)NBTUtil.func_186862_a((UUID)id));
                    cloth.func_74768_a("dim", instance.getClothDimension(id));
                    cloth.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)instance.getClothPos(id)));
                    list.func_74742_a((NBTBase)cloth);
                }
            }
            main.func_74782_a("cloths", (NBTBase)list);
            main.func_74768_a("timeLimit", instance.getTimeLimit());
            main.func_74757_a("perPlayer", instance.getPerPlayer());
            if (instance.getLastActivatedBy() != null) {
                main.func_74782_a("lastActivatedBy", (NBTBase)NBTUtil.func_186862_a((UUID)instance.getLastActivatedBy()));
            }
            main.func_74782_a("owner", (NBTBase)NBTUtil.func_186862_a((UUID)instance.getOwner()));
        }
        return main;
    }

    public void readNBT(Capability<ICapabilityHub> capability, ICapabilityHub instance, EnumFacing side, NBTBase nbt) {
        if (instance != null && nbt != null) {
            NBTTagCompound main = (NBTTagCompound)nbt;
            NBTTagList list = main.func_150295_c("cloths", 10);
            instance.clearUUIDs();
            for (NBTBase tag : list) {
                NBTTagCompound cmp = (NBTTagCompound)tag;
                if (!cmp.func_74764_b("uuid")) continue;
                UUID uuid = NBTUtil.func_186860_b((NBTTagCompound)cmp.func_74775_l("uuid"));
                instance.addUUID(uuid);
                if (cmp.func_74764_b("dim")) {
                    instance.setClothDimension(uuid, cmp.func_74762_e("dim"));
                }
                if (!cmp.func_74764_b("pos")) continue;
                instance.setClothPos(uuid, NBTUtil.func_186861_c((NBTTagCompound)cmp.func_74775_l("pos")));
            }
            instance.setTimeLimit(main.func_74762_e("timeLimit"));
            instance.setPerPlayer(main.func_74767_n("perPlayer"));
            if (((NBTTagCompound)nbt).func_74764_b("lastActivatedBy")) {
                instance.setLastActivatedBy(NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)nbt).func_74775_l("lastActivatedBy")));
            }
            instance.setOwner(NBTUtil.func_186860_b((NBTTagCompound)main.func_74775_l("owner")));
        }
    }
}

