/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.data.worldsaveddata;

import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class MoreMystcraftSavedDataPerSave
extends WorldSavedData {
    private static final String NAME = "moremystcraft";
    private NBTTagList allJourneyClothInfo = new NBTTagList();
    private static MoreMystcraftSavedDataPerSave instance;

    public MoreMystcraftSavedDataPerSave() {
        super(NAME);
    }

    public MoreMystcraftSavedDataPerSave(String str) {
        super(str);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.allJourneyClothInfo = nbt.func_150295_c("journeyClothInfo", 10);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a("journeyClothInfo", (NBTBase)this.allJourneyClothInfo);
        return nbt;
    }

    public static MoreMystcraftSavedDataPerSave get(World world) {
        MapStorage storage = world.func_175693_T();
        instance = (MoreMystcraftSavedDataPerSave)storage.func_75742_a(MoreMystcraftSavedDataPerSave.class, NAME);
        if (instance == null) {
            instance = new MoreMystcraftSavedDataPerSave();
            storage.func_75745_a(NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public NBTTagList getAllJourneyClothInfo() {
        return this.allJourneyClothInfo;
    }

    public void setAllJourneyClothInfo(NBTTagList nbt) {
        this.allJourneyClothInfo = nbt;
        this.func_76185_a();
    }

    public NBTTagCompound getSingleJourneyClothData(UUID uuidIn) {
        NBTTagList main = this.getAllJourneyClothInfo();
        for (NBTBase base : main) {
            UUID uuidSaved = NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)base).func_74775_l("uuid"));
            if (!uuidIn.equals(uuidSaved)) continue;
            return (NBTTagCompound)base;
        }
        return null;
    }

    public void setSingleClothData(UUID uuid, NBTTagCompound nbt) {
        NBTTagList main = this.getAllJourneyClothInfo();
        int index = this.indexOfCloth(uuid);
        if (index >= 0) {
            main.func_150304_a(index, (NBTBase)nbt);
        } else {
            main.func_74742_a((NBTBase)nbt);
        }
        this.setAllJourneyClothInfo(main);
    }

    public int indexOfCloth(UUID uuidIn) {
        NBTTagList main = this.getAllJourneyClothInfo();
        for (int i = 0; i < main.func_74745_c(); ++i) {
            UUID uuidSaved = NBTUtil.func_186860_b((NBTTagCompound)main.func_150305_b(i).func_74775_l("uuid"));
            if (!uuidIn.equals(uuidSaved)) continue;
            return i;
        }
        return -1;
    }

    public void addJourneyCloth(UUID clothUUID) {
        if (this.getSingleJourneyClothData(clothUUID) != null) {
            return;
        }
        NBTTagCompound cloth = new NBTTagCompound();
        cloth.func_74782_a("uuid", (NBTBase)NBTUtil.func_186862_a((UUID)clothUUID));
        this.setSingleClothData(clothUUID, cloth);
    }

    public void setClothPos(UUID uuid, int dimension, BlockPos pos) {
        NBTTagCompound cloth;
        NBTTagList main = this.getAllJourneyClothInfo();
        if (this.getSingleJourneyClothData(uuid) == null) {
            this.addJourneyCloth(uuid);
        }
        if ((cloth = this.getSingleJourneyClothData(uuid)) != null) {
            cloth.func_74768_a("dim", dimension);
            cloth.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            this.setSingleClothData(uuid, cloth);
        }
    }

    public int getClothDimension(UUID uuid) {
        NBTTagCompound cloth = this.getSingleJourneyClothData(uuid);
        return cloth.func_74762_e("dim");
    }

    public void removeClothPos(UUID uuid) {
        NBTTagCompound cloth = this.getSingleJourneyClothData(uuid);
        if (cloth.func_74764_b("dim")) {
            cloth.func_82580_o("dim");
        }
        if (cloth.func_74764_b("pos")) {
            cloth.func_82580_o("pos");
        }
        this.setSingleClothData(uuid, cloth);
    }

    public BlockPos getClothPos(UUID uuid) {
        NBTTagCompound cloth = this.getSingleJourneyClothData(uuid);
        return NBTUtil.func_186861_c((NBTTagCompound)cloth.func_74775_l("pos"));
    }

    public void activateJourneyCloth(UUID clothUUID, UUID playerUUID) {
        if (!this.journeyClothActivatedByPlayer(clothUUID, playerUUID)) {
            if (this.getSingleJourneyClothData(clothUUID) == null) {
                this.addJourneyCloth(clothUUID);
            }
            NBTTagList main = this.getAllJourneyClothInfo();
            NBTTagCompound cloth = this.getSingleJourneyClothData(clothUUID);
            NBTTagList players = cloth.func_150295_c("players", 10);
            players.func_74742_a((NBTBase)NBTUtil.func_186862_a((UUID)playerUUID));
            cloth.func_74782_a("players", (NBTBase)players);
            int index = this.indexOfCloth(clothUUID);
            if (index >= 0) {
                main.func_150304_a(index, (NBTBase)cloth);
                this.setAllJourneyClothInfo(main);
            }
        }
    }

    public void deactivateJourneyCloth(UUID clothUUID, UUID playerUUID) {
        if (this.journeyClothActivatedByPlayer(clothUUID, playerUUID) && this.getSingleJourneyClothData(clothUUID) != null) {
            NBTTagList main = this.getAllJourneyClothInfo();
            NBTTagCompound cloth = this.getSingleJourneyClothData(clothUUID);
            NBTTagList players = cloth.func_150295_c("players", 10);
            for (int i = 0; i < players.func_74745_c(); ++i) {
                if (!playerUUID.equals(NBTUtil.func_186860_b((NBTTagCompound)players.func_150305_b(i)))) continue;
                players.func_74744_a(i);
            }
            cloth.func_74782_a("players", (NBTBase)players);
            int index = this.indexOfCloth(clothUUID);
            if (index >= 0) {
                main.func_150304_a(index, (NBTBase)cloth);
                this.setAllJourneyClothInfo(main);
            }
        }
    }

    public boolean journeyClothActivatedByPlayer(UUID clothUUID, UUID playerUUID) {
        NBTTagCompound cloth = this.getSingleJourneyClothData(clothUUID);
        if (cloth != null) {
            NBTTagList players = cloth.func_150295_c("players", 10);
            for (NBTBase base : players) {
                UUID savedUUID = NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)base));
                if (!playerUUID.equals(savedUUID)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean journeyClothActivatedByAnyone(UUID clothUUID) {
        NBTTagCompound cloth = this.getSingleJourneyClothData(clothUUID);
        if (cloth == null) {
            return false;
        }
        if (!cloth.func_74764_b("players")) {
            return false;
        }
        NBTTagList players = cloth.func_150295_c("players", 10);
        return !players.func_82582_d();
    }
}

