/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.init;

import com.xcompwiz.mystcraft.data.ModRegistryPrimer;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thefloydman.moremystcraft.block.BlockJourneyCloth;
import thefloydman.moremystcraft.block.BlockJourneyHub;
import thefloydman.moremystcraft.block.BlockLockedBookstand;
import thefloydman.moremystcraft.block.BlockLockedLectern;
import thefloydman.moremystcraft.block.BlockNexusController;
import thefloydman.moremystcraft.block.BlockTrafficCone;
import thefloydman.moremystcraft.block.BlockUnstableBookReceptacle;
import thefloydman.moremystcraft.block.BlockUnstablePortal;
import thefloydman.moremystcraft.config.MoreMystcraftConfig;
import thefloydman.moremystcraft.item.ItemJourneyCloth;
import thefloydman.moremystcraft.item.ItemJourneyHub;
import thefloydman.moremystcraft.util.JourneyUtils;
import thefloydman.moremystcraft.util.Reference;

@Mod.EventBusSubscriber
public class MoreMystcraftBlocks {
    public static final Block LOCKED_LECTERN = new BlockLockedLectern();
    public static final Block LOCKED_BOOKSTAND = new BlockLockedBookstand();
    public static final Block TRAFFIC_CONE = new BlockTrafficCone();
    public static final Block UNSTABLE_RECEPTACLE = new BlockUnstableBookReceptacle();
    public static final Block UNSTABLE_PORTAL = new BlockUnstablePortal();
    public static final Block NEXUS_CONTROLLER = new BlockNexusController();
    public static final Block JOURNEY_CLOTH_HAND = new BlockJourneyCloth(JourneyUtils.PatternType.HAND);
    public static final Block JOURNEY_CLOTH_SHELL = new BlockJourneyCloth(JourneyUtils.PatternType.SHELL);
    public static final Block JOURNEY_CLOTH_SPIRAL = new BlockJourneyCloth(JourneyUtils.PatternType.SPIRAL);
    public static final Block JOURNEY_HUB_HAND = new BlockJourneyHub(JourneyUtils.PatternType.HAND);
    public static final Block JOURNEY_HUB_SHELL = new BlockJourneyHub(JourneyUtils.PatternType.SHELL);
    public static final Block JOURNEY_HUB_SPIRAL = new BlockJourneyHub(JourneyUtils.PatternType.SPIRAL);
    public static final Item JOURNEY_CLOTH_HAND_ITEM = new ItemJourneyCloth(JOURNEY_CLOTH_HAND, ((BlockJourneyCloth)MoreMystcraftBlocks.JOURNEY_CLOTH_HAND).PATTERN_TYPE);
    public static final Item JOURNEY_CLOTH_SHELL_ITEM = new ItemJourneyCloth(JOURNEY_CLOTH_SHELL, ((BlockJourneyCloth)MoreMystcraftBlocks.JOURNEY_CLOTH_SHELL).PATTERN_TYPE);
    public static final Item JOURNEY_CLOTH_SPIRAL_ITEM = new ItemJourneyCloth(JOURNEY_CLOTH_SPIRAL, ((BlockJourneyCloth)MoreMystcraftBlocks.JOURNEY_CLOTH_SPIRAL).PATTERN_TYPE);
    public static final Item JOURNEY_HUB_HAND_ITEM = new ItemJourneyHub(JOURNEY_HUB_HAND, ((BlockJourneyHub)MoreMystcraftBlocks.JOURNEY_HUB_HAND).PATTERN_TYPE);
    public static final Item JOURNEY_HUB_SHELL_ITEM = new ItemJourneyHub(JOURNEY_HUB_SHELL, ((BlockJourneyHub)MoreMystcraftBlocks.JOURNEY_HUB_SHELL).PATTERN_TYPE);
    public static final Item JOURNEY_HUB_SPIRAL_ITEM = new ItemJourneyHub(JOURNEY_HUB_SPIRAL, ((BlockJourneyHub)MoreMystcraftBlocks.JOURNEY_HUB_SPIRAL).PATTERN_TYPE);

    public static void init() {
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getLockedLecternEnabled()) {
            LOCKED_LECTERN.setRegistryName(Reference.forMoreMystcraft("locked_lectern"));
            ModRegistryPrimer.queueForRegistration((IForgeRegistryEntry)LOCKED_LECTERN);
            MoreMystcraftBlocks.registerMystcraftItemBlock(LOCKED_LECTERN);
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getLockedBookstandEnabled()) {
            LOCKED_BOOKSTAND.setRegistryName(Reference.forMoreMystcraft("locked_bookstand"));
            ModRegistryPrimer.queueForRegistration((IForgeRegistryEntry)LOCKED_BOOKSTAND);
            MoreMystcraftBlocks.registerMystcraftItemBlock(LOCKED_BOOKSTAND);
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getUnstableReceptacleEnabled()) {
            UNSTABLE_RECEPTACLE.setRegistryName(Reference.forMoreMystcraft("unstable_receptacle"));
            ModRegistryPrimer.queueForRegistration((IForgeRegistryEntry)UNSTABLE_RECEPTACLE);
            MoreMystcraftBlocks.registerMystcraftItemBlock(UNSTABLE_RECEPTACLE);
            UNSTABLE_PORTAL.setRegistryName(Reference.forMoreMystcraft("unstable_portal"));
            ModRegistryPrimer.queueForRegistration((IForgeRegistryEntry)UNSTABLE_PORTAL);
            MoreMystcraftBlocks.registerMystcraftItemBlock(UNSTABLE_PORTAL);
        }
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getTrafficConeEnabled()) {
            event.getRegistry().register((IForgeRegistryEntry)TRAFFIC_CONE);
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getNexusControllerEnabled()) {
            event.getRegistry().register((IForgeRegistryEntry)NEXUS_CONTROLLER);
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getJourneysEnabled()) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{JOURNEY_CLOTH_HAND, JOURNEY_CLOTH_SHELL, JOURNEY_CLOTH_SPIRAL, JOURNEY_HUB_HAND, JOURNEY_HUB_SHELL, JOURNEY_HUB_SPIRAL});
        }
    }

    @SubscribeEvent
    public static void registerItemBlock(RegistryEvent.Register<Item> event) {
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getTrafficConeEnabled()) {
            event.getRegistry().register(new ItemBlock(TRAFFIC_CONE).setRegistryName(TRAFFIC_CONE.getRegistryName()));
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getNexusControllerEnabled()) {
            event.getRegistry().register(new ItemBlock(NEXUS_CONTROLLER).setRegistryName(NEXUS_CONTROLLER.getRegistryName()));
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getJourneysEnabled()) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{JOURNEY_CLOTH_HAND_ITEM, JOURNEY_CLOTH_SHELL_ITEM, JOURNEY_CLOTH_SPIRAL_ITEM, JOURNEY_HUB_HAND_ITEM, JOURNEY_HUB_SHELL_ITEM, JOURNEY_HUB_SPIRAL_ITEM});
        }
    }

    @SubscribeEvent
    public static void registerRenders(ModelRegistryEvent event) {
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getTrafficConeEnabled()) {
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)TRAFFIC_CONE));
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getNexusControllerEnabled()) {
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)NEXUS_CONTROLLER));
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getJourneysEnabled()) {
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)JOURNEY_CLOTH_HAND));
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)JOURNEY_CLOTH_SHELL));
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)JOURNEY_CLOTH_SPIRAL));
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)JOURNEY_HUB_HAND));
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)JOURNEY_HUB_SHELL));
            MoreMystcraftBlocks.registerRender(Item.func_150898_a((Block)JOURNEY_HUB_SPIRAL));
        }
    }

    public static void registerRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static void registerMystcraftItemBlock(Block b) {
        ItemBlock ib = new ItemBlock(b);
        ib.setRegistryName(b.getRegistryName());
        ModRegistryPrimer.queueForRegistration((IForgeRegistryEntry)ib);
    }

    public static void registerMystcraftModels() {
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getLockedLecternEnabled()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)LOCKED_LECTERN), (int)0, (ModelResourceLocation)MoreMystcraftBlocks.mrlItemBlockModel("blocklectern"));
        }
        new MoreMystcraftConfig();
        if (MoreMystcraftConfig.getLockedBookstandEnabled()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)LOCKED_BOOKSTAND), (int)0, (ModelResourceLocation)MoreMystcraftBlocks.mrlItemBlockModel("blockbookstand"));
        }
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)UNSTABLE_RECEPTACLE), (int)0, (ModelResourceLocation)MoreMystcraftBlocks.mrlItemBlockModelMore("unstable_receptacle"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)UNSTABLE_PORTAL), (int)0, (ModelResourceLocation)MoreMystcraftBlocks.mrlItemBlockModelMore("unstable_portal"));
    }

    private static ModelResourceLocation mrlItemBlockModel(String name) {
        return new ModelResourceLocation(new ResourceLocation("mystcraft", name), "inventory");
    }

    private static ModelResourceLocation mrlItemBlockModelMore(String name) {
        return new ModelResourceLocation(new ResourceLocation("moremystcraft", name), "inventory");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModelColors() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, worldIn, pos, tintIndex) -> new Color(255, 0, 0).getRGB(), new Block[]{UNSTABLE_PORTAL});
    }
}

