/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.network.packets;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thefloydman.moremystcraft.util.handlers.PotionListHandler;

public class PacketPotion
implements IMessage {
    int dimension;
    String potion;

    public PacketPotion(int dim, String str) {
        this.dimension = dim;
        this.potion = str;
    }

    public PacketPotion() {
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.potion = buf.readCharSequence(buf.readableBytes(), Charset.defaultCharset()).toString();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeCharSequence((CharSequence)this.potion, Charset.defaultCharset());
    }

    public static class Handler
    implements IMessageHandler<PacketPotion, IMessage> {
        public IMessage onMessage(PacketPotion msg, MessageContext ctx) {
            PotionListHandler.receivePotion(msg.dimension, msg.potion);
            return null;
        }
    }
}

