/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.behavior;

import com.google.gson.JsonObject;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.IAgeSymbolBehavior;
import mystlibrary.symbol.util.SymbolJsonParser;
import net.minecraft.util.ResourceLocation;
import thefloydman.moremystcraft.util.Reference;

public class CloudHeightBehavior
implements IAgeSymbolBehavior {
    public static final ResourceLocation NAME = Reference.forMoreMystcraft("cloud_height");
    private final float height;
    private static final String FIELD_NAME_VALUE = "value";

    public static IAgeSymbolBehavior fromJson(JsonObject json, SymbolMetadata metadata) throws SymbolBuildException {
        float height = SymbolJsonParser.parseFloat((JsonObject)json, (String)FIELD_NAME_VALUE, (SymbolMetadata)metadata);
        CloudHeightBehavior behavior = new CloudHeightBehavior(height);
        return behavior;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("behavior_id", NAME.toString());
        json.addProperty(FIELD_NAME_VALUE, (Number)Float.valueOf(this.height));
        return json;
    }

    public CloudHeightBehavior(float height) {
        this.height = height;
    }

    public void registerLogic(AgeDirector controller, long seed) {
        Float value = Float.valueOf(this.height);
        Number prev = controller.popModifier("cloud_height").asNumber();
        if (prev != null) {
            value = Float.valueOf((prev.floatValue() + value.floatValue()) / 2.0f);
        }
        controller.setCloudHeight(value.floatValue());
    }
}

