/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IBiomeController;
import com.xcompwiz.mystcraft.symbol.modifiers.SymbolBiome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import thefloydman.moremystcraft.symbol.MoreMystcraftSymbolBase;
import thefloydman.moremystcraft.world.gen.MazeGeneratorRecursiveBacktracker;

public class SymbolBiomeControllerMaze
extends MoreMystcraftSymbolBase {
    public SymbolBiomeControllerMaze(ResourceLocation identifier) {
        super(identifier);
    }

    public void registerLogic(AgeDirector controller, long seed) {
        Number size = controller.popModifier("size").asNumber();
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        Biome biome = ModifierUtils.popBiome((AgeDirector)controller);
        while (biome != null) {
            biomes.add(biome);
            biome = ModifierUtils.popBiome((AgeDirector)controller);
        }
        Random rand = new Random(controller.getSeed());
        while (biomes.size() < 2) {
            biomes.add(SymbolBiome.getRandomBiome((Random)rand));
        }
        controller.registerInterface((IBiomeController)new BiomeController(biomes, size));
    }

    public boolean generatesConfigOption() {
        return true;
    }

    private class BiomeController
    implements IBiomeController {
        private List<Biome> biomes;
        private double size;
        private int resolution;
        private Biome[] biomeArray;
        Map<String, int[][]> mazeMap = new HashMap<String, int[][]>();

        public BiomeController(List<Biome> biomes, Number size) {
            this.biomes = biomes;
            if (size != null) {
                if (size.doubleValue() == 3.0) {
                    this.size = 64.0;
                } else if (size.doubleValue() == 2.0) {
                    this.size = 32.0;
                } else if (size.doubleValue() == 1.0) {
                    this.size = 16.0;
                } else if (size.doubleValue() == 0.5) {
                    this.size = 8.0;
                } else if (size.doubleValue() == 0.25) {
                    this.size = 4.0;
                }
            } else {
                this.size = 16.0;
            }
        }

        public List<Biome> getValidSpawnBiomes() {
            return this.biomes;
        }

        public Biome getBiomeAtCoords(int i, int j) {
            int localZ;
            int localX;
            int mazeChunkX = (int)Math.floor((double)i / (16.0 * this.size));
            int mazeChunkZ = (int)Math.floor((double)j / (16.0 * this.size));
            String index = String.valueOf(mazeChunkX) + "," + String.valueOf(mazeChunkZ);
            if (this.mazeMap.get(index) == null) {
                this.generateMazeSquare(index);
            }
            for (localX = (int)Math.abs(((double)i - (double)i % this.size) / this.size); localX > 15; localX -= 16) {
            }
            for (localZ = (int)Math.abs(((double)j - (double)j % this.size) / this.size); localZ > 15; localZ -= 16) {
            }
            if (this.mazeMap.get(index)[localX][localZ] == 2) {
                return this.biomes.get(0);
            }
            if (this.mazeMap.get(index)[localX][localZ] == 1) {
                return this.biomes.get(1);
            }
            return this.biomes.get(0);
        }

        public Biome[] getBiomesForGeneration(Biome[] aBiome, int x, int z, int xSize, int zSize) {
            if (aBiome == null || aBiome.length < xSize * zSize) {
                aBiome = new Biome[xSize * zSize];
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                aBiome[i] = this.getBiomeAtCoords((x + i % xSize) * 4, (z + i / xSize) * 4);
            }
            return aBiome;
        }

        public Biome[] getBiomesAtCoords(Biome[] aBiome, int x, int z, int xSize, int zSize, boolean flag) {
            if (aBiome == null || aBiome.length < xSize * zSize) {
                aBiome = new Biome[xSize * zSize];
            }
            if (flag && xSize == 16 && zSize == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
                return this.createBiomeArray(aBiome, x, z, xSize, zSize);
            }
            for (int i = 0; i < xSize * zSize; ++i) {
                aBiome[i] = this.getBiomeAtCoords(x + i % xSize, z + i / xSize);
            }
            return aBiome;
        }

        private Biome[] createBiomeArray(Biome[] aBiome, int i, int j, int k, int l) {
            if (aBiome == null || aBiome.length < k * l) {
                aBiome = new Biome[k * l];
            }
            for (int i2 = 0; i2 < k * l; ++i2) {
                aBiome[i2] = this.getBiomeAtCoords(i + i2 % k, j + i2 / k);
            }
            return aBiome;
        }

        public void cleanupCache() {
        }

        private Double distanceToCoords(int x, int z) {
            return Math.abs(Math.sqrt(x * x + z * z));
        }

        private void generateMazeSquare(String index) {
            if (this.biomes.get(0).equals(null)) {
                return;
            }
            int[][] mazeSquare = new MazeGeneratorRecursiveBacktracker(16, 16).getMaze();
            int randomSide = (int)(Math.random() * 15.0 + 1.0);
            int n = randomSide % 2 == 0 ? 1 : 0;
            mazeSquare[randomTop += (randomTop = (int)(Math.random() * 15.0 + 1.0)) % 2 == 0 ? 1 : 0][0] = 2;
            mazeSquare[0][randomSide += n] = 2;
            this.mazeMap.put(index, mazeSquare);
        }
    }
}

