/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.api.world.logic.ISpawnModifier;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainFeatureLocator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import thefloydman.moremystcraft.symbol.MoreMystcraftSymbolBase;

public class SymbolOceanMonument
extends MoreMystcraftSymbolBase {
    public SymbolOceanMonument(ResourceLocation identifier) {
        super(identifier);
    }

    public void registerLogic(AgeDirector controller, long seed) {
        StructureOceanMonument generator = new StructureOceanMonument();
        controller.registerInterface((ITerrainAlteration)new TerrainAlteration(generator));
        controller.registerInterface((IPopulate)new Populator(generator));
        controller.registerInterface((ITerrainFeatureLocator)new FeatureLocator(generator));
        controller.registerInterface((ISpawnModifier)new SpawnModifier(generator));
    }

    public int instabilityModifier(int count) {
        if (count > 3) {
            return 100;
        }
        return 0;
    }

    public boolean generatesConfigOption() {
        return true;
    }

    private class SpawnModifier
    implements ISpawnModifier {
        private StructureOceanMonument generator;

        public SpawnModifier(StructureOceanMonument gen) {
            this.generator = gen;
        }

        public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType creatureType, BlockPos pos) {
            return this.generator.func_175799_b();
        }
    }

    private class FeatureLocator
    implements ITerrainFeatureLocator {
        private StructureOceanMonument generator;

        public FeatureLocator(StructureOceanMonument gen) {
            this.generator = gen;
        }

        public BlockPos locate(World world, String s, BlockPos pos, boolean genChunks) {
            if ("Monument".equals(s) && this.generator != null) {
                return this.generator.func_180706_b(world, pos, genChunks);
            }
            return null;
        }

        public boolean isInsideFeature(World world, String identifier, BlockPos pos) {
            return "Monument".equals(identifier) && this.generator != null && this.generator.func_175796_a(world, pos);
        }
    }

    private class TerrainAlteration
    implements ITerrainAlteration {
        private StructureOceanMonument generator;

        public TerrainAlteration(StructureOceanMonument gen) {
            this.generator = gen;
        }

        public void alterTerrain(World worldObj, int chunkX, int chunkZ, ChunkPrimer primer) {
            this.generator.func_186125_a(worldObj, chunkX, chunkZ, primer);
        }
    }

    private class Populator
    implements IPopulate {
        private StructureOceanMonument generator;

        public Populator(StructureOceanMonument gen) {
            this.generator = gen;
        }

        public boolean populate(World worldObj, Random rand, int i, int j, boolean flag) {
            return this.generator.func_175794_a(worldObj, rand, new ChunkPos(i >> 4, j >> 4));
        }
    }
}

