/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ICelestial;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thefloydman.moremystcraft.lwjgl.Matrix3f;
import thefloydman.moremystcraft.lwjgl.Vector3f;
import thefloydman.moremystcraft.symbol.MoreMystcraftSunsetRenderer;
import thefloydman.moremystcraft.symbol.MoreMystcraftSymbolBase;
import thefloydman.moremystcraft.util.Reference;

public class SymbolTintedSun
extends MoreMystcraftSymbolBase {
    public SymbolTintedSun(ResourceLocation identifier) {
        super(identifier);
    }

    public void registerLogic(AgeDirector controller, long seed) {
        Number period = controller.popModifier("wavelength").asNumber();
        Number angle = controller.popModifier("angle").asNumber();
        Number phase = controller.popModifier("phase").asNumber();
        ColorGradient sunset = controller.popModifier("sunset").asGradient();
        ColorGradient sunGradient = controller.popModifier("sun_color").asGradient();
        if (sunGradient == null) {
            sunGradient = new ColorGradient();
        }
        if (sunGradient.getColorCount() == 0) {
            Color color = controller.popModifier("color").asColor();
            if (color != null) {
                sunGradient.pushColor(color);
            }
            sunGradient.pushColor(color);
        }
        Number size = controller.popModifier("size").asNumber();
        Number tilt = controller.popModifier("tilt").asNumber();
        controller.registerInterface((ICelestial)new CelestialObject(controller, seed, period, angle, phase, sunset, sunGradient, size, tilt));
    }

    public boolean generatesConfigOption() {
        return true;
    }

    private static class CelestialObject
    extends MoreMystcraftSunsetRenderer
    implements ICelestial {
        private Random rand;
        private long period;
        private float angle;
        private float phase;
        private ColorGradient sunColor;
        private double size;
        private float tilt;

        CelestialObject(AgeDirector controller, long seed, Number period, Number angle, Number phase, ColorGradient sunsetGradient, ColorGradient sunGradient, Number size, Number tilt) {
            super(controller, sunsetGradient);
            this.rand = new Random(seed);
            if (period == null) {
                period = 0.4 * this.rand.nextDouble() + 0.8;
            }
            this.period = (long)(period.doubleValue() * 24000.0);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
            if (phase != null) {
                phase = Float.valueOf(phase.floatValue() / 360.0f);
            }
            if (phase == null) {
                phase = Float.valueOf(this.rand.nextFloat());
                if (this.period == 0L) {
                    phase = Float.valueOf(phase.floatValue() / 2.0f + 0.25f);
                }
            }
            this.phase = phase.floatValue() - 0.5f;
            if (sunGradient == null || sunGradient.getColorCount() < 1) {
                ColorGradient grad = new ColorGradient();
                grad.pushColor(new Color(this.rand.nextFloat(), this.rand.nextFloat(), this.rand.nextFloat()));
                sunGradient = grad;
            }
            this.sunColor = sunGradient;
            this.size = size != null ? size.doubleValue() : 1.0;
            this.tilt = tilt != null ? tilt.floatValue() : 0.0f;
        }

        public boolean providesLight() {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public void render(TextureManager eng, World world, float partial) {
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            float celestial_period = this.getAltitudeForSunset(world.func_72820_D(), partial);
            GlStateManager.func_179098_w();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            float f16 = 1.0f - world.func_72867_j(partial);
            Color color = new Color(1.0f, 0.9607843f, 0.46666667f);
            if (this.sunColor.getColorCount() > 0) {
                color = this.sunColor.getColor((float)this.controller.getTime() / 12000.0f);
            }
            GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)f16);
            GlStateManager.func_179114_b((float)(this.angle + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.tilt, (float)1.0f, (float)0.0f, (float)0.0f);
            float rotZ = this.phase * 360.0f % 360.0f;
            if (this.period != 0L) {
                rotZ = (float)((360.0 * ((double)world.func_72820_D() / (double)this.period) + (double)(this.phase * 360.0f)) % 360.0);
            }
            GlStateManager.func_179114_b((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
            double size = this.size < 0.375 ? 10.0 : (this.size >= 0.375 && this.size < 0.75 ? 20.0 : (this.size >= 0.75 && this.size < 1.5 ? 30.0 : (this.size >= 1.5 && this.size < 2.5 ? 70.0 : (this.size >= 2.5 ? 120.0 : 30.0))));
            eng.func_110577_a(Reference.forMoreMystcraft("textures/environment/sun_neutral.png"));
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(-size, 100.0, -size).func_187315_a(0.0, 0.0).func_181675_d();
            vb.func_181662_b(size, 100.0, -size).func_187315_a(1.0, 0.0).func_181675_d();
            vb.func_181662_b(size, 100.0, size).func_187315_a(1.0, 1.0).func_181675_d();
            vb.func_181662_b(-size, 100.0, size).func_187315_a(0.0, 1.0).func_181675_d();
            tes.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            this.renderHorizon(eng, world, celestial_period, this.getHorizonAngle(world.func_72820_D(), this.tilt, this.period), partial, 1.0f);
        }

        public float getAltitudeAngle(long time, float partialTime) {
            Vector3f sunPos = this.getSunPos(time, this.angle, this.tilt, this.period);
            Vector3f noon = new Vector3f(0.0f, 1.0f, 0.0f);
            double angCurrent = Vector3f.angle(sunPos, noon);
            if (this.period != 0L && ((double)time % (double)this.period / (double)this.period + (double)this.phase) % 1.0 > 0.5) {
                angCurrent = Math.PI * 2 - angCurrent;
            }
            angCurrent /= Math.PI * 2;
            angCurrent %= 1.0;
            float sunsInAQuarter = this.size < 0.375 ? 11.0f : (this.size >= 0.375 && this.size < 0.75 ? 9.0f : (this.size >= 0.75 && this.size < 1.5 ? 4.5f : (this.size >= 1.5 && this.size < 2.5 ? 2.25f : (this.size >= 2.5 ? 1.5f : 4.5f))));
            float angAdj = 0.25f / sunsInAQuarter / 2.0f;
            angCurrent = angCurrent <= 0.5 ? (angCurrent -= (double)angAdj) : (angCurrent += (double)angAdj);
            return (float)(angCurrent %= 1.0);
        }

        private float getAltitudeForSunset(long time, float partialTime) {
            Vector3f sunPos = this.getSunPos(time, this.angle, this.tilt, this.period);
            Vector3f noon = new Vector3f(0.0f, 1.0f, 0.0f);
            double angCurrent = Vector3f.angle(sunPos, noon);
            if (this.period != 0L && ((double)time % (double)this.period / (double)this.period + (double)this.phase) % 1.0 > 0.5) {
                angCurrent = Math.PI * 2 - angCurrent;
            }
            angCurrent /= Math.PI * 2;
            angCurrent %= 1.0;
            float sunsInAQuarter = 10.0f;
            sunsInAQuarter = this.size < 0.375 ? 10.0f : (this.size >= 0.375 && this.size < 0.75 ? 8.0f : (this.size >= 0.75 && this.size < 1.5 ? 4.5f : (this.size >= 1.5 && this.size < 2.5 ? 3.0f : (this.size >= 2.5 ? 2.0f : 4.5f))));
            float angAdj = 0.25f / sunsInAQuarter / 2.0f;
            float[] coords0 = new float[]{0.0f, 0.0f, 0.25f - 2.0f * angAdj, 0.25f - angAdj};
            float[] coords1 = new float[]{0.25f - 2.0f * angAdj, 0.25f - angAdj, 0.25f - angAdj, 0.25f};
            float[] coords2 = new float[]{0.25f - angAdj, 0.25f, 0.25f + angAdj, 0.25f};
            float[] coords3 = new float[]{0.25f + angAdj, 0.25f, 0.25f + 2.0f * angAdj, 0.25f + angAdj};
            float[] coords4 = new float[]{0.25f + 2.0f * angAdj, 0.25f + angAdj, 0.75f - 2.0f * angAdj, 0.75f - angAdj};
            float[] coords5 = new float[]{0.75f - 2.0f * angAdj, 0.75f - angAdj, 0.75f - angAdj, 0.75f};
            float[] coords6 = new float[]{0.75f - angAdj, 0.75f, 0.75f + angAdj, 0.75f};
            float[] coords7 = new float[]{0.75f + angAdj, 0.75f, 0.75f + 2.0f * angAdj, 0.75f + angAdj};
            float[] coords8 = new float[]{0.75f + 2.0f * angAdj, 0.75f + angAdj, 1.0f, 1.0f};
            float slope0 = this.findSlope(coords0[0], coords0[1], coords0[2], coords0[3]);
            float slope1 = this.findSlope(coords1[0], coords1[1], coords1[2], coords1[3]);
            float slope2 = this.findSlope(coords2[0], coords2[1], coords2[2], coords2[3]);
            float slope3 = this.findSlope(coords3[0], coords3[1], coords3[2], coords3[3]);
            float slope4 = this.findSlope(coords4[0], coords4[1], coords4[2], coords4[3]);
            float slope5 = this.findSlope(coords5[0], coords5[1], coords5[2], coords5[3]);
            float slope6 = this.findSlope(coords6[0], coords6[1], coords6[2], coords6[3]);
            float slope7 = this.findSlope(coords7[0], coords7[1], coords7[2], coords7[3]);
            float slope8 = this.findSlope(coords8[0], coords8[1], coords8[2], coords8[3]);
            float intercept0 = this.findYIntercept(coords0[0], coords0[1], slope0);
            float intercept1 = this.findYIntercept(coords1[0], coords1[1], slope1);
            float intercept2 = this.findYIntercept(coords2[0], coords2[1], slope2);
            float intercept3 = this.findYIntercept(coords3[0], coords3[1], slope3);
            float intercept4 = this.findYIntercept(coords4[0], coords4[1], slope4);
            float intercept5 = this.findYIntercept(coords5[0], coords5[1], slope5);
            float intercept6 = this.findYIntercept(coords6[0], coords6[1], slope6);
            float intercept7 = this.findYIntercept(coords7[0], coords7[1], slope7);
            float intercept8 = this.findYIntercept(coords8[0], coords8[1], slope8);
            if (angCurrent < 0.25 - (double)(angAdj * 2.0f)) {
                angCurrent *= (double)slope0;
                angCurrent += (double)intercept0;
            } else if (angCurrent >= 0.25 - (double)(angAdj * 2.0f) && angCurrent < 0.25 - (double)angAdj) {
                angCurrent *= (double)slope1;
                angCurrent += (double)intercept1;
            } else if (angCurrent >= 0.25 - (double)angAdj && angCurrent < 0.25 + (double)angAdj) {
                angCurrent *= (double)slope2;
                angCurrent += (double)intercept2;
            } else if (angCurrent >= 0.25 + (double)angAdj && angCurrent < 0.25 + (double)(angAdj * 2.0f)) {
                angCurrent *= (double)slope3;
                angCurrent += (double)intercept3;
            } else if (angCurrent >= 0.25 + (double)(angAdj * 2.0f) && angCurrent < 0.75 - (double)(angAdj * 2.0f)) {
                angCurrent *= (double)slope4;
                angCurrent += (double)intercept4;
            } else if (angCurrent >= 0.75 - (double)(angAdj * 2.0f) && angCurrent < 0.75 - (double)angAdj) {
                angCurrent *= (double)slope5;
                angCurrent += (double)intercept5;
            } else if (angCurrent >= 0.75 - (double)angAdj && angCurrent < 0.75 + (double)angAdj) {
                angCurrent *= (double)slope6;
                angCurrent += (double)intercept6;
            } else if (angCurrent >= 0.75 + (double)angAdj && angCurrent < 0.75 + (double)(angAdj * 2.0f)) {
                angCurrent *= (double)slope7;
                angCurrent += (double)intercept7;
            } else if (angCurrent >= 0.75 + (double)(angAdj * 2.0f)) {
                angCurrent *= (double)slope8;
                angCurrent += (double)intercept8;
            }
            return (float)(angCurrent %= 1.0);
        }

        private float getHorizonAngle(long time, double tilt, double period) {
            Vector3f sunPos = this.getSunPos(time, this.angle, tilt, period);
            Vector3f sunPosFlat = new Vector3f(sunPos.getX(), 0.0f, sunPos.getZ()).normalise(null);
            Vector3f horZ = new Vector3f(0.0f, 0.0f, 1.0f);
            double angCurrent = Math.PI - (double)Vector3f.angle(sunPosFlat, horZ);
            Vector3f horX = new Vector3f(1.0f, 0.0f, 0.0f);
            double angCheck = Vector3f.angle(sunPosFlat, horX);
            if (angCheck < 1.5707963267948966) {
                angCurrent *= -1.0;
            }
            return (float)Math.toDegrees(angCurrent) + 90.0f;
        }

        public Long getTimeToDawn(long time) {
            if (this.period == 0L) {
                return null;
            }
            long current = time % this.period;
            long next = (long)((float)this.period * Math.abs(0.75f - this.phase));
            if (current > next) {
                next += this.period;
            }
            return next - current;
        }

        private Vector3f getSunPos(double time, double angle, double tilt, double period) {
            tilt = Math.toRadians(tilt);
            double angY = -angle;
            angY = Math.toRadians(angY);
            double angZ = period == 0.0 ? (double)(this.phase * 360.0f % 360.0f) : (360.0 * (time / period) + (double)(this.phase * 360.0f)) % 360.0;
            angZ = Math.toRadians(angZ);
            Vector3f sunPos = new Vector3f(0.0f, 1.0f, 0.0f);
            Matrix3f rotX = this.matrixRotX(tilt);
            Matrix3f rotY = this.matrixRotY(angY);
            Matrix3f rotZ = this.matrixRotZ(angZ);
            Matrix3f.transform(rotZ, sunPos, sunPos);
            Matrix3f.transform(rotX, sunPos, sunPos);
            Matrix3f.transform(rotY, sunPos, sunPos);
            return sunPos;
        }

        private Matrix3f matrixRotX(double ang) {
            Matrix3f rot = new Matrix3f();
            rot.m00 = 1.0f;
            rot.m01 = 0.0f;
            rot.m02 = 0.0f;
            rot.m10 = 0.0f;
            rot.m11 = (float)Math.cos(ang);
            rot.m12 = -((float)Math.sin(ang));
            rot.m20 = 0.0f;
            rot.m21 = (float)Math.sin(ang);
            rot.m22 = (float)Math.cos(ang);
            return rot;
        }

        private Matrix3f matrixRotY(double ang) {
            Matrix3f rot = new Matrix3f();
            rot.m00 = (float)Math.cos(ang);
            rot.m01 = 0.0f;
            rot.m02 = (float)Math.sin(ang);
            rot.m10 = 0.0f;
            rot.m11 = 1.0f;
            rot.m12 = 0.0f;
            rot.m20 = -((float)Math.sin(ang));
            rot.m21 = 0.0f;
            rot.m22 = (float)Math.cos(ang);
            return rot;
        }

        private Matrix3f matrixRotZ(double ang) {
            Matrix3f rot = new Matrix3f();
            rot.m00 = (float)Math.cos(ang);
            rot.m01 = -((float)Math.sin(ang));
            rot.m02 = 0.0f;
            rot.m10 = (float)Math.sin(ang);
            rot.m11 = (float)Math.cos(ang);
            rot.m12 = 0.0f;
            rot.m20 = 0.0f;
            rot.m21 = 0.0f;
            rot.m22 = 1.0f;
            return rot;
        }

        private float findSlope(float input1, float output1, float input2, float output2) {
            return (output2 - output1) / (input2 - input1);
        }

        private float findYIntercept(float input, float output, float slope) {
            return output - input * slope;
        }
    }
}

