/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.tileentity;

import com.xcompwiz.mystcraft.item.ItemLinking;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scala.actors.threadpool.Arrays;

public class TileEntityNexusController
extends TileEntity
implements ISidedInventory {
    protected NonNullList<ItemStack> bookList = NonNullList.func_191197_a((int)this.inventorySize, (Object)ItemStack.field_190927_a);
    protected List<ItemStack> shortList = new ArrayList<ItemStack>();
    private List<Integer> filteredList = new ArrayList<Integer>();
    protected int bookCount = 0;
    protected int inventorySize = 130;
    protected String query = null;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("books")) {
            NBTTagCompound books = nbt.func_74775_l("books");
            this.bookList = NonNullList.func_191197_a((int)this.inventorySize, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)books, this.bookList);
            this.bookCount = 0;
            for (ItemStack stack : this.bookList) {
                if (stack.func_190926_b()) continue;
                ++this.bookCount;
            }
            this.shortList = new ArrayList<ItemStack>();
            for (int i = 2; i < this.bookList.size() && !((ItemStack)this.bookList.get(i)).func_190926_b(); ++i) {
                this.shortList.add((ItemStack)this.bookList.get(i));
            }
        } else {
            this.bookList = null;
        }
        this.query = nbt.func_74764_b("query") ? nbt.func_74779_i("query") : null;
        this.filterBooks(this.query);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.bookList != null) {
            NBTTagCompound books = new NBTTagCompound();
            ItemStackHelper.func_191282_a((NBTTagCompound)books, this.bookList);
            nbt.func_74782_a("books", (NBTBase)books);
        }
        if (this.query != null) {
            nbt.func_74778_a("query", this.query);
        }
        return nbt;
    }

    public boolean addBook(ItemStack stack) {
        for (int i = 2; i < this.inventorySize; ++i) {
            if (!((ItemStack)this.bookList.get(i)).func_190926_b()) continue;
            this.bookList.set(i, (Object)stack);
            this.shortList.add(stack);
            this.sortBookList();
            ++this.bookCount;
            this.func_70304_b(0);
            this.filterBooks(this.query);
            return true;
        }
        return false;
    }

    public void removeBook(int id) {
        for (int i = id; i < this.bookList.size() - 1; ++i) {
            this.bookList.set(i, this.bookList.get(i + 1));
        }
        this.bookList.set(this.bookList.size() - 1, (Object)ItemStack.field_190927_a);
        this.shortList.remove(id - 2);
        --this.bookCount;
        this.filterBooks(this.query);
        this.func_70296_d();
    }

    public int getBookCount() {
        return this.bookCount;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        super.func_189518_D_();
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.bookList != null) {
            NBTTagCompound books = new NBTTagCompound();
            ItemStackHelper.func_191282_a((NBTTagCompound)books, this.bookList);
            nbt.func_74782_a("books", (NBTBase)books);
        }
        if (this.query != null) {
            nbt.func_74778_a("query", this.query);
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        if (nbt.func_74764_b("books")) {
            NBTTagCompound books = nbt.func_74775_l("books");
            this.bookList = NonNullList.func_191197_a((int)this.inventorySize, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)books, this.bookList);
            this.bookCount = 0;
            for (ItemStack stack : this.bookList) {
                if (stack.func_190926_b()) continue;
                ++this.bookCount;
            }
            this.shortList = new ArrayList<ItemStack>();
            for (int i = 2; i < this.bookList.size() && !((ItemStack)this.bookList.get(i)).func_190926_b(); ++i) {
                this.shortList.add((ItemStack)this.bookList.get(i));
            }
        } else {
            this.bookList = null;
        }
        this.query = nbt.func_74764_b("query") ? nbt.func_74779_i("query") : null;
        this.filterBooks(this.query);
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return this.inventorySize;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.bookList) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.bookList.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.bookList, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.bookList.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.bookList.set(index, (Object)ItemStack.field_190927_a);
        this.func_70296_d();
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.bookList.set(index, (Object)stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.func_77973_b() instanceof ItemLinking;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
        this.func_70296_d();
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (Arrays.asList((Object[])EnumFacing.field_176754_o).contains(side)) {
            return new int[]{0};
        }
        return null;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 && Arrays.asList((Object[])EnumFacing.field_176754_o).contains(direction) && itemStackIn.func_77973_b() instanceof ItemLinking;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return !oldState.func_177230_c().equals(newState.func_177230_c());
    }

    @Nonnull
    public String getQuery() {
        return this.query == null ? "" : this.query;
    }

    public void setQuery(String str) {
        this.query = str;
        this.func_70296_d();
    }

    public NonNullList<ItemStack> getBookList() {
        return this.bookList;
    }

    public NBTTagCompound func_189517_E_() {
        super.func_189517_E_();
        NBTTagCompound nbt = this.getTileData();
        if (this.bookList != null) {
            NBTTagCompound books = new NBTTagCompound();
            ItemStackHelper.func_191282_a((NBTTagCompound)books, this.bookList);
            nbt.func_74782_a("books", (NBTBase)books);
        }
        if (this.query != null) {
            nbt.func_74778_a("query", this.query);
        }
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        NBTTagCompound nbt = new NBTTagCompound();
        if (nbt.func_74764_b("books")) {
            NBTTagCompound books = nbt.func_74775_l("books");
            this.bookList = NonNullList.func_191197_a((int)this.inventorySize, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)books, this.bookList);
            this.bookCount = 0;
            for (ItemStack stack : this.bookList) {
                if (stack.func_190926_b()) continue;
                ++this.bookCount;
            }
            this.shortList = new ArrayList<ItemStack>();
            for (int i = 2; i < this.bookList.size() && !((ItemStack)this.bookList.get(i)).func_190926_b(); ++i) {
                this.shortList.add((ItemStack)this.bookList.get(i));
            }
        } else {
            this.bookList = null;
        }
        this.query = nbt.func_74764_b("query") ? nbt.func_74779_i("query") : null;
        this.filterBooks(this.query);
    }

    protected void sortBookList() {
        Comparator compareByDisplayName = (o1, o2) -> ((ItemLinking)o1.func_77973_b()).getLinkInfo(o1).getDisplayName().toLowerCase().compareTo(((ItemLinking)o2.func_77973_b()).getLinkInfo(o2).getDisplayName().toLowerCase());
        this.shortList.sort(compareByDisplayName);
        for (int i = 0; i < this.shortList.size(); ++i) {
            this.bookList.set(i + 2, (Object)this.shortList.get(i));
        }
        this.func_70296_d();
    }

    public List<ItemStack> getShortList() {
        return this.shortList;
    }

    public void filterBooks(String text) {
        int i;
        this.filteredList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.getShortList().size(); ++i2) {
            this.filteredList.add(i2 + 2);
        }
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        ArrayList<String> displayNames = new ArrayList<String>();
        for (ItemStack stack : this.shortList) {
            displayNames.add(((ItemLinking)stack.func_77973_b()).getLinkInfo(stack).getDisplayName());
        }
        this.filteredList = new ArrayList<Integer>();
        for (i = 0; i < this.getShortList().size(); ++i) {
            this.filteredList.add(i + 2);
        }
        for (i = 0; i < displayNames.size(); ++i) {
            if (((String)displayNames.get(i)).toLowerCase().contains(text.toLowerCase())) continue;
            int index = this.filteredList.indexOf(i + 2);
            this.filteredList.remove(index);
        }
        this.func_70296_d();
    }

    public List<Integer> getFilteredBookList() {
        return this.filteredList;
    }
}

