/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.util.handlers;

import com.xcompwiz.mystcraft.api.event.LinkEvent;
import com.xcompwiz.mystcraft.item.ItemLinkbookUnlinked;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thefloydman.moremystcraft.entity.EntityMaintainerSuit;
import thefloydman.moremystcraft.entity.EntityPotionDummy;
import thefloydman.moremystcraft.init.MoreMystcraftItems;
import thefloydman.moremystcraft.network.MoreMystcraftPacketHandler;

@Mod.EventBusSubscriber
public class MaintainerSuitEventHandler {
    private static Map<UUID, Boolean> wasRidingSuit = new HashMap<UUID, Boolean>();
    private static Map<Integer, List<String>> potions = new HashMap<Integer, List<String>>();
    private static Map<Integer, Integer> potionListChanged = new HashMap<Integer, Integer>();

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        if (!world.field_72995_K && event.getHand().equals((Object)EnumHand.MAIN_HAND)) {
            EntityPlayer entityPlayer = event.getEntityPlayer();
            Entity entityTarget = event.getTarget();
            if (entityTarget instanceof EntityMaintainerSuit) {
                EntityMaintainerSuit entitySuit = (EntityMaintainerSuit)entityTarget;
                if (entityPlayer.func_70093_af()) {
                    ItemStack itemStack = new ItemStack(MoreMystcraftItems.MAINTAINER_SUIT);
                    entityPlayer.func_191521_c(itemStack);
                    ((EntityPlayerMP)entityPlayer).func_71120_a(entityPlayer.field_71069_bz);
                    world.func_72900_e(entityTarget);
                } else if (!(entityPlayer.func_184187_bx() instanceof EntityMaintainerSuit)) {
                    entityPlayer.func_184220_m((Entity)entitySuit);
                }
            }
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent event) {
        if (event.getEntity().func_184218_aH() && event.getEntity().func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntity() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingAttackEntity(LivingAttackEvent event) {
        Entity victim = event.getEntity();
        Entity aggressor = event.getSource().func_76346_g();
        if (victim instanceof EntityPotionDummy) {
            event.setCanceled(true);
        } else if (victim instanceof EntityPlayer) {
            if (victim.func_184218_aH() && victim.func_184187_bx() instanceof EntityMaintainerSuit) {
                event.setCanceled(true);
            }
        } else if (aggressor instanceof EntityPlayer && aggressor.func_184218_aH() && aggressor.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void potionApplicable(PotionEvent.PotionApplicableEvent event) {
        Entity entity = event.getEntity();
        int world = entity.field_71093_bK;
        if (world < 2 || !(event.getEntity().field_70170_p.field_73011_w instanceof WorldProviderMyst)) {
            return;
        }
        if (((WorldProviderMyst)event.getEntity().field_70170_p.field_73011_w).getAgeController().getInstabilityScore() <= 0) {
            return;
        }
        if (entity instanceof EntityPotionDummy) {
            String potion = event.getPotionEffect().func_76453_d();
            if (!potions.containsKey(world)) {
                potions.put(world, new ArrayList());
            }
            if (!potionListChanged.containsKey(world)) {
                potionListChanged.put(world, 0);
            }
            if (!potions.get(world).contains(potion) && potionListChanged.get(world) == 0) {
                potions.get(world).add(0, potion);
                potionListChanged.put(world, potionListChanged.get(world) + 1);
            }
        } else if (entity instanceof EntityPlayer && entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setResult(Event.Result.DENY);
            if (potionListChanged.get(world) != null && potionListChanged.get(world) > 0) {
                for (int i = 0; i < potionListChanged.get(world); ++i) {
                    MoreMystcraftPacketHandler.sendPotion(world, potions.get(world).get(i), (EntityPlayerMP)entity);
                }
                potionListChanged.put(world, 0);
            }
        }
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70163_u <= 0.0) {
            return;
        }
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCancellationResult(EnumActionResult.FAIL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerInteractLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCancellationResult(EnumActionResult.FAIL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerInteractRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCancellationResult(EnumActionResult.FAIL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerInteractRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getItemStack().func_77973_b() instanceof ItemLinking || event.getItemStack().func_77973_b() instanceof ItemLinkbookUnlinked) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCancellationResult(EnumActionResult.FAIL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLinkAlter(LinkEvent.LinkEventAlter event) {
        Entity entity = event.entity;
        Entity mount = entity.func_184187_bx();
        if (mount != null && mount instanceof EntityMaintainerSuit) {
            entity.func_184210_p();
            event.origin.func_72900_e(mount);
            wasRidingSuit.put(entity.func_110124_au(), true);
        }
    }

    @SubscribeEvent
    public static void onLinkAfter(LinkEvent.LinkEventEnd event) {
        Entity entity = event.entity;
        UUID uuid = entity.func_110124_au();
        if (!wasRidingSuit.containsKey(uuid)) {
            wasRidingSuit.put(uuid, false);
        }
        if (wasRidingSuit.get(entity.func_110124_au()).booleanValue()) {
            EntityMaintainerSuit suit = new EntityMaintainerSuit(event.destination);
            suit.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            event.destination.func_72838_d((Entity)suit);
            wasRidingSuit.put(entity.func_110124_au(), false);
            entity.func_184220_m((Entity)suit);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderHand(RenderSpecificHandEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void pickupItem(EntityItemPickupEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void tossItem(ItemTossEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player.func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
            ItemStack item = event.getEntityItem().func_92059_d();
            player.func_191521_c(item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent event) {
        EntityPlayerSP player;
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && (player = Minecraft.func_71410_x().field_71439_g).func_184218_aH() && player.func_184187_bx() instanceof EntityMaintainerSuit) {
            event.setCanceled(true);
        }
    }

    public static void clearPotionsList() {
        potions = new HashMap<Integer, List<String>>();
        potionListChanged = new HashMap<Integer, Integer>();
    }

    public static void clearPotionsList(int dim) {
        potions.remove(dim);
        potionListChanged.remove(dim);
    }

    public static void setPotionsList(Integer dim, List<String> effects) {
        potions = new HashMap<Integer, List<String>>();
        potions.put(dim, effects);
        potionListChanged = new HashMap<Integer, Integer>();
        potionListChanged.put(dim, effects.size());
    }

    public static List<String> getPotionsList(int dim) {
        return potions.get(dim);
    }
}

