/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.world.gen.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class WorldGenGiganticTree {
    World world;
    Random rand;
    final IBlockState logBlockState;
    final IBlockState leafBlockState;
    int treeHeightMinimum;
    int treeHeightVariant;
    int treeHeightActual;
    int xAnchor;
    int zAnchor;
    int leavesDistance;
    List<Integer> trunkColumnsX;
    List<Integer> trunkColumnsZ;

    public WorldGenGiganticTree(IBlockState logBlockState, IBlockState leafBlockState) {
        this.logBlockState = logBlockState;
        this.leafBlockState = leafBlockState;
    }

    public boolean generate(World world, Random rand, int x, int z) {
        this.world = world;
        this.rand = rand;
        this.treeHeightMinimum = this.world.field_73011_w.func_76557_i() + 128;
        this.treeHeightVariant = 16;
        this.treeHeightActual = this.treeHeightMinimum + 1 + this.rand.nextInt(this.treeHeightVariant);
        this.xAnchor = x;
        this.zAnchor = z;
        this.leavesDistance = 3;
        this.trunkColumnsX = new ArrayList<Integer>();
        this.trunkColumnsZ = new ArrayList<Integer>();
        this.generateTrunk();
        this.generateAllBranchesAndLeaves();
        this.generateTopLeaves();
        return true;
    }

    protected void generateTopLeaves() {
        this.generateLeavesSphere(new BlockPos(this.xAnchor, this.treeHeightActual - 1, this.zAnchor + 1));
        this.generateLeavesSphere(new BlockPos(this.xAnchor + 2, this.treeHeightActual - 1, this.zAnchor));
        this.generateLeavesSphere(new BlockPos(this.xAnchor + 3, this.treeHeightActual - 1, this.zAnchor + 2));
        this.generateLeavesSphere(new BlockPos(this.xAnchor + 1, this.treeHeightActual - 1, this.zAnchor + 3));
    }

    protected void generateAllBranchesAndLeaves() {
        if (this.trunkColumnsX.size() != this.trunkColumnsZ.size()) {
            System.out.println("Trunk Column Arrays are not the same size. Aborting branch and leaves generation.");
            return;
        }
        for (int i = 0; i < this.trunkColumnsX.size(); ++i) {
            if (this.trunkColumnsX.get(i) == 1 && this.trunkColumnsZ.get(i) == 0) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 1, this.treeHeightActual - 8, this.zAnchor - 1), BranchDirections.NORTH.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 2 && this.trunkColumnsZ.get(i) == 0) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 2, this.treeHeightActual - 8, this.zAnchor - 1), BranchDirections.NORTH.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 2 && this.trunkColumnsZ.get(i) == 1) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 3, this.treeHeightActual - 8, this.zAnchor), BranchDirections.NORTHEAST.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 3 && this.trunkColumnsZ.get(i) == 1) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 4, this.treeHeightActual - 8, this.zAnchor + 1), BranchDirections.EAST.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 3 && this.trunkColumnsZ.get(i) == 2) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 4, this.treeHeightActual - 8, this.zAnchor + 2), BranchDirections.EAST.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 2 && this.trunkColumnsZ.get(i) == 2) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 3, this.treeHeightActual - 8, this.zAnchor + 3), BranchDirections.SOUTHEAST.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 2 && this.trunkColumnsZ.get(i) == 3) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 2, this.treeHeightActual - 8, this.zAnchor + 4), BranchDirections.SOUTH.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 1 && this.trunkColumnsZ.get(i) == 3) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor + 1, this.treeHeightActual - 8, this.zAnchor + 4), BranchDirections.SOUTH.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 1 && this.trunkColumnsZ.get(i) == 2) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor, this.treeHeightActual - 8, this.zAnchor + 3), BranchDirections.SOUTHWEST.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 0 && this.trunkColumnsZ.get(i) == 2) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor - 1, this.treeHeightActual - 8, this.zAnchor + 2), BranchDirections.WEST.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) == 2 && this.trunkColumnsZ.get(i) == 1) {
                this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor - 1, this.treeHeightActual - 8, this.zAnchor + 1), BranchDirections.WEST.ordinal());
                continue;
            }
            if (this.trunkColumnsX.get(i) != 1 || this.trunkColumnsZ.get(i) != 1) continue;
            this.generateColumnBranchesAndLeaves(new BlockPos(this.xAnchor, this.treeHeightActual - 8, this.zAnchor), BranchDirections.NORTHWEST.ordinal());
        }
    }

    protected boolean generateColumnBranchesAndLeaves(BlockPos pos, int direction) {
        block10: for (int i = 0; i < 8; ++i) {
            if (this.rand.nextInt(4) != 0 || this.world.func_180495_p(pos.func_177981_b(i).func_177977_b()).equals(this.logBlockState)) continue;
            int length = 4 + this.rand.nextInt(3);
            switch (direction) {
                case 0: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177964_d(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177964_d(length - 1));
                    continue block10;
                }
                case 1: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177964_d(length).func_177965_g(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177964_d(length - 1).func_177965_g(length - 1));
                    continue block10;
                }
                case 2: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177965_g(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177965_g(length - 1));
                    continue block10;
                }
                case 3: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177970_e(length).func_177965_g(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177970_e(length - 1).func_177965_g(length - 1));
                    continue block10;
                }
                case 4: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177970_e(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177970_e(length - 1));
                    continue block10;
                }
                case 5: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177970_e(length).func_177985_f(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177970_e(length - 1).func_177985_f(length - 1));
                    continue block10;
                }
                case 6: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177985_f(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177985_f(length - 1));
                    continue block10;
                }
                case 7: {
                    this.generateBlockLine(pos.func_177981_b(i), pos.func_177981_b(i).func_177964_d(length).func_177985_f(length), this.logBlockState);
                    this.generateLeavesSphere(pos.func_177981_b(i).func_177964_d(length - 1).func_177985_f(length - 1));
                }
            }
        }
        return true;
    }

    protected void generateLeavesSphere(BlockPos pos) {
        if (!this.world.func_180495_p(pos).func_185904_a().equals(Material.field_151575_d)) {
            return;
        }
        for (int x = -this.leavesDistance; x <= this.leavesDistance; ++x) {
            for (int y = -this.leavesDistance; y <= this.leavesDistance; ++y) {
                for (int z = -this.leavesDistance; z <= this.leavesDistance; ++z) {
                    if (!this.world.func_180495_p(pos.func_177965_g(x).func_177981_b(y).func_177970_e(z)).equals(Blocks.field_150350_a.func_176223_P()) || this.indirectDistanceBetween(pos, pos.func_177965_g(x).func_177981_b(y).func_177970_e(z)) >= 5 || !(this.directDistanceBetween(pos, pos.func_177965_g(x).func_177981_b(y).func_177970_e(z)) <= (float)this.leavesDistance)) continue;
                    this.world.func_175656_a(pos.func_177965_g(x).func_177981_b(y).func_177970_e(z), this.leafBlockState);
                }
            }
        }
    }

    protected float directDistanceBetween(BlockPos pos0, BlockPos pos1) {
        float xDif = pos1.func_177958_n() - pos0.func_177958_n();
        float yDif = pos1.func_177956_o() - pos0.func_177956_o();
        float zDif = pos1.func_177952_p() - pos0.func_177952_p();
        float x2 = xDif * xDif;
        float y2 = yDif * yDif;
        float z2 = zDif * zDif;
        return MathHelper.func_76129_c((float)(x2 + y2 + z2));
    }

    protected void generateTrunk() {
        this.generateTrunkColumn(0, 1);
        this.generateTrunkColumn(0, 2);
        this.generateTrunkColumn(1, 0);
        this.generateTrunkColumn(1, 1);
        this.generateTrunkColumn(1, 2);
        this.generateTrunkColumn(1, 3);
        this.generateTrunkColumn(2, 0);
        this.generateTrunkColumn(2, 1);
        this.generateTrunkColumn(2, 2);
        this.generateTrunkColumn(2, 3);
        this.generateTrunkColumn(3, 1);
        this.generateTrunkColumn(3, 2);
    }

    protected void generateTrunkColumn(int x, int z) {
        int bottomY = this.findGround(x, z) + 1;
        if (bottomY == 0) {
            return;
        }
        this.generateBlockLine(new BlockPos(x + this.xAnchor, bottomY, z + this.zAnchor), new BlockPos(x + this.xAnchor, this.treeHeightActual, z + this.zAnchor), this.logBlockState);
        this.trunkColumnsX.add(x);
        this.trunkColumnsZ.add(z);
    }

    protected boolean generateBlockLine(BlockPos startPos, BlockPos endPos, IBlockState state) {
        if (startPos.equals((Object)endPos)) {
            return false;
        }
        int xDif = MathHelper.func_76130_a((int)(endPos.func_177958_n() - startPos.func_177958_n()));
        int yDif = MathHelper.func_76130_a((int)(endPos.func_177956_o() - startPos.func_177956_o()));
        int zDif = MathHelper.func_76130_a((int)(endPos.func_177952_p() - startPos.func_177952_p()));
        int steps = Math.max(Math.max(xDif, yDif), Math.max(zDif, yDif));
        float xStep = startPos.func_177958_n() < endPos.func_177958_n() ? (float)(xDif / steps) : (float)(-xDif / steps);
        float yStep = startPos.func_177956_o() < endPos.func_177956_o() ? (float)(yDif / steps) : (float)(-yDif / steps);
        float zStep = startPos.func_177952_p() < endPos.func_177952_p() ? (float)(zDif / steps) : (float)(-zDif / steps);
        float xCurrent = startPos.func_177958_n();
        float yCurrent = startPos.func_177956_o();
        float zCurrent = startPos.func_177952_p();
        while (!endPos.equals((Object)new BlockPos(Math.round(xCurrent), Math.round(yCurrent), Math.round(zCurrent)))) {
            this.world.func_175656_a(new BlockPos(Math.round(xCurrent), Math.round(yCurrent), Math.round(zCurrent)), state);
            xCurrent += xStep;
            yCurrent += yStep;
            zCurrent += zStep;
        }
        return true;
    }

    protected int findGround(int xLocal, int zLocal) {
        int y;
        int x = xLocal + this.xAnchor;
        int z = zLocal + this.zAnchor;
        for (y = 255; y >= 0; --y) {
            if (!this.world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76220_a() || this.world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().equals(Material.field_151584_j) || this.world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().equals(Material.field_151575_d) || this.world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().equals(Material.field_151588_w)) continue;
            return y;
        }
        return y;
    }

    protected int indirectDistanceBetween(BlockPos pos0, BlockPos pos1) {
        return MathHelper.func_76130_a((int)(pos1.func_177958_n() - pos0.func_177958_n())) + MathHelper.func_76130_a((int)(pos1.func_177956_o() - pos0.func_177956_o())) + MathHelper.func_76130_a((int)(pos1.func_177952_p() - pos0.func_177952_p()));
    }

    protected static enum BranchDirections {
        NORTH,
        NORTHEAST,
        EAST,
        SOUTHEAST,
        SOUTH,
        SOUTHWEST,
        WEST,
        NORTHWEST;

    }
}

