/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.world.gen.feature;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.block.BlockLectern;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.treasure.LootTableHandler;
import com.xcompwiz.mystcraft.world.agedata.AgeData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import thefloydman.moremystcraft.config.MoreMystcraftConfig;
import thefloydman.moremystcraft.util.Reference;

public class WorldGenLibraryReplacement
implements IWorldGenerator {
    List<String> changedLibraries = new ArrayList<String>();
    List<String> unchangedLibraries = new ArrayList<String>();
    boolean processing = false;
    int generationSetting;

    public WorldGenLibraryReplacement() {
        MoreMystcraftConfig config = new MoreMystcraftConfig();
        this.generationSetting = config.getLibrariesEnabled() ? (config.getLibrariesUpgraded() ? generationSettings.UPGRADED_LIBRARIES.ordinal() : generationSettings.DEFAULT.ordinal()) : generationSettings.NO_LIBRARIES.ordinal();
    }

    public WorldGenLibraryReplacement(int genSet) {
        this.generationSetting = genSet;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (this.processing) {
            return;
        }
        if (!world.field_73011_w.func_186058_p().equals((Object)Mystcraft.dimensionType)) {
            return;
        }
        int dimId = world.field_73011_w.getDimension();
        try {
            new AgeData("currentDim");
            AgeData data = AgeData.getAge((int)dimId, (boolean)false);
            List symbolList = data.getSymbols(false);
            ResourceLocation studyLoc = Reference.forMoreMystcraft("no_libraries");
            if (symbolList.contains(studyLoc)) {
                this.generationSetting = generationSettings.NO_LIBRARIES.ordinal();
            } else {
                new MoreMystcraftConfig();
                this.generationSetting = MoreMystcraftConfig.getLibrariesUpgraded() ? generationSettings.UPGRADED_LIBRARIES.ordinal() : generationSettings.DEFAULT.ordinal();
            }
        }
        catch (NullPointerException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Invalid Dimension ID: " + Integer.toString(dimId));
        }
        this.processing = true;
        NBTTagCompound libraries = this.loadLibraryFile(world);
        if (libraries == null) {
            this.processing = false;
            return;
        }
        this.unchangedLibraries.addAll(libraries.func_150296_c());
        for (int i = 0; i < this.unchangedLibraries.size(); ++i) {
            if (this.changedLibraries.contains(this.unchangedLibraries.get(i)) || this.unchangedLibraries.contains(this.unchangedLibraries.get(i))) {
                this.unchangedLibraries.remove(i);
                --i;
            }
            this.updateLibraries(world, libraries, new ChunkPos(chunkX, chunkZ));
        }
        this.processing = false;
    }

    private void updateLibraries(World world, NBTTagCompound libraries, ChunkPos chunkPos) {
        while (this.unchangedLibraries.size() > 0) {
            int separator = this.unchangedLibraries.get(0).indexOf(",");
            if (separator < 0) {
                return;
            }
            int listedX = Integer.valueOf(this.unchangedLibraries.get(0).substring(1, separator));
            int listedZ = Integer.valueOf(this.unchangedLibraries.get(0).substring(separator + 1, this.unchangedLibraries.get(0).length() - 1));
            int[] libraryBounds = libraries.func_74775_l("[" + listedX + "," + listedZ + "]").func_74759_k("BB");
            if (!this.isMystcraftLibraryGenerated(world, new BlockPos(libraryBounds[0], 64, libraryBounds[2]))) {
                this.unchangedLibraries.remove(0);
                continue;
            }
            this.updateLibrary(world, libraries, new ChunkPos(new BlockPos(libraryBounds[0], libraryBounds[1], libraryBounds[2])));
            this.changedLibraries.add(this.unchangedLibraries.get(0));
            this.unchangedLibraries.remove(0);
        }
    }

    protected boolean isMystcraftLibraryGenerated(World world, BlockPos pos) {
        while (pos.func_177956_o() <= 255) {
            if (world.func_180495_p(pos.func_177965_g(1).func_177970_e(4)).func_177230_c().equals(Blocks.field_150463_bK) && world.func_180495_p(pos.func_177965_g(10).func_177981_b(6).func_177970_e(10)).func_177230_c().equals(Blocks.field_150446_ar) && world.func_180495_p(pos.func_177965_g(10).func_177981_b(6)).func_177230_c().equals(Blocks.field_150446_ar) && world.func_180495_p(pos.func_177970_e(10).func_177981_b(6).func_177965_g(2)).func_177230_c().equals(Blocks.field_150446_ar)) {
                return true;
            }
            if (world.func_180495_p(pos.func_177965_g(4).func_177970_e(1)).func_177230_c().equals(Blocks.field_150463_bK) && world.func_180495_p(pos.func_177965_g(10).func_177981_b(6).func_177970_e(10)).func_177230_c().equals(Blocks.field_150446_ar) && world.func_180495_p(pos.func_177965_g(10).func_177981_b(6).func_177970_e(2)).func_177230_c().equals(Blocks.field_150446_ar) && world.func_180495_p(pos.func_177970_e(10).func_177981_b(6)).func_177230_c().equals(Blocks.field_150446_ar)) {
                return true;
            }
            pos = pos.func_177984_a();
        }
        return false;
    }

    protected void updateLibrary(World world, NBTTagCompound libraries, ChunkPos chunkPos) {
        int[] libraryBounds = libraries.func_74775_l("[" + chunkPos.field_77276_a + "," + chunkPos.field_77275_b + "]").func_74759_k("BB");
        BlockPos pos = new BlockPos(libraryBounds[0], 64, libraryBounds[2]);
        EnumFacing facing = EnumFacing.NORTH;
        while (pos.func_177956_o() <= 255) {
            if (world.func_180495_p(pos.func_177965_g(1).func_177970_e(4)).func_177230_c().equals(Blocks.field_150463_bK)) {
                facing = EnumFacing.WEST;
                break;
            }
            if (world.func_180495_p(pos.func_177965_g(4).func_177970_e(1)).func_177230_c().equals(Blocks.field_150463_bK)) {
                facing = EnumFacing.NORTH;
                break;
            }
            pos = pos.func_177984_a();
        }
        if (this.generationSetting == generationSettings.NO_LIBRARIES.ordinal()) {
            this.removeLibrary(world, pos.func_177979_c(2), facing);
            this.removePedestal(world, pos.func_177979_c(2), facing);
        } else if (this.generationSetting == generationSettings.UPGRADED_LIBRARIES.ordinal()) {
            new MoreMystcraftConfig();
            if (new Random().nextInt(100) < MoreMystcraftConfig.getGreatLibraryPercentage()) {
                this.removeLibrary(world, pos.func_177979_c(2), facing);
                if (facing.equals((Object)EnumFacing.WEST)) {
                    pos = pos.func_177970_e(15);
                }
                this.generateGreatLibrary(world, pos.func_177977_b(), facing);
            } else {
                this.generateUpgradedLibrary(world, pos.func_177979_c(2), facing);
            }
        }
    }

    protected void generateUpgradedLibrary(World world, BlockPos pos, EnumFacing facing) {
        int i;
        int z;
        IBlockState walls = Blocks.field_150417_aV.func_176223_P();
        IBlockState stairs = Blocks.field_150390_bg.func_176223_P();
        IBlockState slabs = Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SMOOTHBRICK);
        IBlockState carpet = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.RED);
        for (int y = pos.func_177956_o() + 1; y < pos.func_177956_o() + 12; ++y) {
            for (int x = pos.func_177958_n(); x < pos.func_177958_n() + 16; ++x) {
                for (z = pos.func_177952_p(); z < pos.func_177952_p() + 16; ++z) {
                    if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().equals(Blocks.field_150347_e)) {
                        world.func_175656_a(new BlockPos(x, y, z), walls);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().equals(Blocks.field_150446_ar)) {
                        EnumFacing propFacing = (EnumFacing)world.func_180495_p(new BlockPos(x, y, z)).func_177228_b().get((Object)BlockStairs.field_176309_a);
                        BlockStairs.EnumHalf propHalf = (BlockStairs.EnumHalf)world.func_180495_p(new BlockPos(x, y, z)).func_177228_b().get((Object)BlockStairs.field_176308_b);
                        BlockStairs.EnumShape propShape = (BlockStairs.EnumShape)world.func_180495_p(new BlockPos(x, y, z)).func_177228_b().get((Object)BlockStairs.field_176310_M);
                        world.func_175656_a(new BlockPos(x, y, z), stairs.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)propFacing).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)propHalf).func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)propShape));
                        continue;
                    }
                    if (!world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().equals(Blocks.field_150333_U)) continue;
                    BlockSlab.EnumBlockHalf propHalf = (BlockSlab.EnumBlockHalf)world.func_180495_p(new BlockPos(x, y, z)).func_177228_b().get((Object)BlockStoneSlab.field_176554_a);
                    world.func_175656_a(new BlockPos(x, y, z), slabs.func_177226_a((IProperty)BlockStoneSlab.field_176554_a, (Comparable)propHalf));
                }
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        z = pos.func_177952_p();
        int[] xArray = new int[14];
        for (int i2 = 0; i2 < xArray.length; ++i2) {
            xArray[i2] = x;
        }
        int[] yArray = new int[14];
        for (int i3 = 0; i3 < yArray.length; ++i3) {
            yArray[i3] = y + 2;
        }
        int[] zArray = new int[14];
        for (i = 0; i < zArray.length; ++i) {
            zArray[i] = z;
        }
        if (facing.equals((Object)EnumFacing.WEST)) {
            xArray[0] = xArray[0] + 2;
            xArray[1] = xArray[1] + 2;
            xArray[2] = xArray[2] + 3;
            xArray[3] = xArray[3] + 4;
            xArray[4] = xArray[4] + 4;
            xArray[5] = xArray[5] + 5;
            xArray[6] = xArray[6] + 5;
            xArray[7] = xArray[7] + 5;
            xArray[8] = xArray[8] + 5;
            xArray[9] = xArray[9] + 6;
            xArray[10] = xArray[10] + 6;
            xArray[11] = xArray[11] + 7;
            xArray[12] = xArray[12] + 7;
            xArray[13] = xArray[13] + 7;
            zArray[0] = zArray[0] + 4;
            zArray[1] = zArray[1] + 6;
            zArray[2] = zArray[2] + 5;
            zArray[3] = zArray[3] + 5;
            zArray[4] = zArray[4] + 6;
            zArray[5] = zArray[5] + 7;
            zArray[6] = zArray[6] + 6;
            zArray[7] = zArray[7] + 4;
            zArray[8] = zArray[8] + 3;
            zArray[9] = zArray[9] + 5;
            zArray[10] = zArray[10] + 7;
            zArray[11] = zArray[11] + 6;
            zArray[12] = zArray[12] + 4;
            zArray[13] = zArray[13] + 3;
        } else {
            xArray[0] = xArray[0] + 4;
            xArray[1] = xArray[1] + 6;
            xArray[2] = xArray[2] + 5;
            xArray[3] = xArray[3] + 5;
            xArray[4] = xArray[4] + 6;
            xArray[5] = xArray[5] + 7;
            xArray[6] = xArray[6] + 6;
            xArray[7] = xArray[7] + 4;
            xArray[8] = xArray[8] + 3;
            xArray[9] = xArray[9] + 5;
            xArray[10] = xArray[10] + 7;
            xArray[11] = xArray[11] + 6;
            xArray[12] = xArray[12] + 4;
            xArray[13] = xArray[13] + 3;
            zArray[0] = zArray[0] + 2;
            zArray[1] = zArray[1] + 2;
            zArray[2] = zArray[2] + 3;
            zArray[3] = zArray[3] + 4;
            zArray[4] = zArray[4] + 4;
            zArray[5] = zArray[5] + 5;
            zArray[6] = zArray[6] + 5;
            zArray[7] = zArray[7] + 5;
            zArray[8] = zArray[8] + 5;
            zArray[9] = zArray[9] + 6;
            zArray[10] = zArray[10] + 6;
            zArray[11] = zArray[11] + 7;
            zArray[12] = zArray[12] + 7;
            zArray[13] = zArray[13] + 7;
        }
        for (i = 0; i < xArray.length; ++i) {
            world.func_175656_a(new BlockPos(xArray[i], yArray[i], zArray[i]), carpet);
        }
    }

    protected void generateGreatLibrary(World world, BlockPos pos, EnumFacing facing) {
        WorldServer worldserver = (WorldServer)world;
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = worldserver.func_184163_y();
        Template template = templatemanager.func_186237_a(minecraftserver, new ResourceLocation("moremystcraft", "great_library"));
        PlacementSettings placementsettings = facing.equals((Object)EnumFacing.NORTH) ? new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(true).func_186218_a(null).func_186225_a(null).func_186226_b(false) : new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186222_a(true).func_186218_a(null).func_186225_a(null).func_186226_b(false);
        template.func_186253_b(world, pos, placementsettings);
        Map map = template.func_186258_a(pos, placementsettings);
        for (Map.Entry entry : map.entrySet()) {
            ItemStack item;
            TileEntityLectern tileEntityLectern;
            BlockPos dataPos;
            if (((String)entry.getValue()).equals("lectern_right")) {
                dataPos = (BlockPos)entry.getKey();
                if (facing.equals((Object)EnumFacing.NORTH)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.WEST));
                }
                if (facing.equals((Object)EnumFacing.WEST)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.SOUTH));
                }
                if ((tileEntityLectern = (TileEntityLectern)world.func_175625_s(dataPos)) == null || (item = LootTableHandler.generateLecternItem((InventoryFilter)tileEntityLectern, (Random)new Random(), (LootTable)world.func_184146_ak().func_186521_a(LootTableHandler.MYST_TREASURE), (LootContext)new LootContext.Builder((WorldServer)world).func_186471_a())) == null) continue;
                tileEntityLectern.setBook(item);
                continue;
            }
            if (((String)entry.getValue()).equals("lectern_front")) {
                dataPos = (BlockPos)entry.getKey();
                if (facing.equals((Object)EnumFacing.NORTH)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.NORTH));
                }
                if (facing.equals((Object)EnumFacing.WEST)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.WEST));
                }
                if ((tileEntityLectern = (TileEntityLectern)world.func_175625_s(dataPos)) == null || (item = LootTableHandler.generateLecternItem((InventoryFilter)tileEntityLectern, (Random)new Random(), (LootTable)world.func_184146_ak().func_186521_a(LootTableHandler.MYST_TREASURE), (LootContext)new LootContext.Builder((WorldServer)world).func_186471_a())) == null) continue;
                tileEntityLectern.setBook(item);
                continue;
            }
            if (((String)entry.getValue()).equals("lectern_left")) {
                dataPos = (BlockPos)entry.getKey();
                if (facing.equals((Object)EnumFacing.NORTH)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.EAST));
                }
                if (facing.equals((Object)EnumFacing.WEST)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.NORTH));
                }
                if ((tileEntityLectern = (TileEntityLectern)world.func_175625_s(dataPos)) == null || (item = LootTableHandler.generateLecternItem((InventoryFilter)tileEntityLectern, (Random)new Random(), (LootTable)world.func_184146_ak().func_186521_a(LootTableHandler.MYST_TREASURE), (LootContext)new LootContext.Builder((WorldServer)world).func_186471_a())) == null) continue;
                tileEntityLectern.setBook(item);
                continue;
            }
            if (((String)entry.getValue()).equals("lectern_back")) {
                dataPos = (BlockPos)entry.getKey();
                if (facing.equals((Object)EnumFacing.NORTH)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.SOUTH));
                }
                if (facing.equals((Object)EnumFacing.WEST)) {
                    world.func_175656_a(dataPos, ModBlocks.lectern.func_176223_P().func_177226_a((IProperty)BlockLectern.ROTATION, (Comparable)EnumFacing.EAST));
                }
                if ((tileEntityLectern = (TileEntityLectern)world.func_175625_s(dataPos)) == null || (item = LootTableHandler.generateLecternItem((InventoryFilter)tileEntityLectern, (Random)new Random(), (LootTable)world.func_184146_ak().func_186521_a(LootTableHandler.MYST_TREASURE), (LootContext)new LootContext.Builder((WorldServer)world).func_186471_a())) == null) continue;
                tileEntityLectern.setBook(item);
                continue;
            }
            if (!((String)entry.getValue()).equals("chest")) continue;
            dataPos = (BlockPos)entry.getKey();
            world.func_175698_g(dataPos);
            TileEntityChest tileentity = (TileEntityChest)world.func_175625_s(dataPos.func_177977_b());
            tileentity.func_189404_a(new ResourceLocation("mystcraft", "mystcraft_treasure"), new Random().nextLong());
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos currentPos = pos;
                if (facing.equals((Object)EnumFacing.WEST)) {
                    currentPos = currentPos.func_177964_d(15);
                }
                while (currentPos.func_177956_o() > 0 && !world.func_180495_p(currentPos.func_177965_g(x).func_177970_e(z).func_177977_b()).func_185904_a().func_76220_a()) {
                    world.func_175656_a(currentPos.func_177965_g(x).func_177970_e(z).func_177977_b(), Blocks.field_150347_e.func_176223_P());
                    currentPos = currentPos.func_177977_b();
                }
            }
        }
    }

    protected void removeLibrary(World world, BlockPos pos, EnumFacing facing) {
        for (int y = pos.func_177956_o() + 1; y < pos.func_177956_o() + 12; ++y) {
            for (int x = pos.func_177958_n(); x < pos.func_177958_n() + 16; ++x) {
                for (int z = pos.func_177952_p(); z < pos.func_177952_p() + 16; ++z) {
                    world.func_175713_t(new BlockPos(x, y, z));
                    world.func_175698_g(new BlockPos(x, y, z));
                }
            }
        }
    }

    protected void removePedestal(World world, BlockPos pos, EnumFacing facing) {
        int y = pos.func_177956_o();
        int x = pos.func_177958_n() - 1;
        int z = pos.func_177952_p() - 1;
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 13; ++j) {
                y = pos.func_177956_o();
                int k = 0;
                while (y > 0 && world.func_180495_p(new BlockPos(x + i, y + k, z + j)).func_177230_c().equals(Blocks.field_150347_e)) {
                    world.func_175698_g(new BlockPos(x + i, y + k, z + j));
                    --k;
                }
            }
        }
    }

    protected NBTTagCompound loadLibraryFile(World world) {
        File rootdir = null;
        NBTTagCompound libraries = null;
        try {
            rootdir = DimensionManager.getCurrentSaveRootDirectory().getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File dimensionfolder = new File(rootdir, "/" + world.field_73011_w.getSaveFolder());
        File libraryFile = new File(dimensionfolder, "/data/MystLibrary.dat");
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(libraryFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            libraries = CompressedStreamTools.func_74796_a((InputStream)inputStream).func_74775_l("data").func_74775_l("Features");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return libraries;
    }

    static enum generationSettings {
        DEFAULT,
        NO_LIBRARIES,
        UPGRADED_LIBRARIES;

    }
}

