/*
 * Decompiled with CFR 0.152.
 */
package thefloydman.moremystcraft.world.gen.feature;

import com.xcompwiz.mystcraft.world.gen.feature.WorldGeneratorAdv;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenPyramids
extends WorldGeneratorAdv {
    private List<IBlockState> blocks;

    public WorldGenPyramids(List<IBlockState> blockList) {
        this.blocks = blockList;
    }

    public boolean doGeneration(World world, Random rand, BlockPos base) {
        if (base.func_177956_o() == 0 || world.func_180495_p(new BlockPos(base.func_177958_n(), base.func_177956_o() - 1, base.func_177952_p())).func_185904_a().equals(Material.field_151575_d) || world.func_180495_p(new BlockPos(base.func_177958_n(), base.func_177956_o() - 1, base.func_177952_p())).func_185904_a().equals(Material.field_151584_j) || world.func_180495_p(new BlockPos(base.func_177958_n(), base.func_177956_o() - 1, base.func_177952_p())).func_185904_a().func_76224_d()) {
            return false;
        }
        int height = rand.nextInt(7) + 2;
        int curY = base.func_177956_o();
        int width = height;
        while (curY <= base.func_177956_o() + height) {
            this.fillSquareLayer(new BlockPos(base.func_177958_n(), curY, base.func_177952_p()), width, world, rand);
            this.cleanupPyramidLayer(new BlockPos(base.func_177958_n(), curY, base.func_177952_p()), width, width, world, rand);
            ++curY;
            --width;
        }
        return true;
    }

    private void fillRecLayer(BlockPos center, int widthX, int widthZ, World world, Random rand) {
        for (int curX = center.func_177958_n() - widthX; curX <= center.func_177958_n() + widthX; ++curX) {
            for (int curZ = center.func_177952_p() - widthZ; curZ <= center.func_177952_p() + widthZ; ++curZ) {
                this.placeBlock(world, new BlockPos(curX, center.func_177956_o(), curZ), this.blocks.get(rand.nextInt(this.blocks.size())), 2);
            }
        }
    }

    private void fillSquareLayer(BlockPos center, int width, World world, Random rand) {
        this.fillRecLayer(center, width, width, world, rand);
    }

    private void cleanupPyramidLayer(BlockPos center, int widthX, int widthZ, World world, Random rand) {
        for (int curX = center.func_177958_n() - widthX; curX <= center.func_177958_n() + widthX; ++curX) {
            for (int curZ = center.func_177952_p() - widthZ; curZ <= center.func_177952_p() + widthZ; ++curZ) {
                int groundY;
                if (world.func_180495_p(new BlockPos(curX, center.func_177956_o() - 1, curZ)).func_185904_a().func_76220_a()) continue;
                this.placeBlock(world, new BlockPos(curX, center.func_177956_o(), curZ), Blocks.field_150350_a.func_176223_P(), 2);
                if ((int)(Math.random() * 2.0) != 0 || (groundY = this.findGround(world, curX, center.func_177956_o(), curZ)) <= 0) continue;
                this.placeBlock(world, new BlockPos(curX, groundY + 1, curZ), this.blocks.get(rand.nextInt(this.blocks.size())), 2);
            }
        }
    }

    private int findGround(World world, int x, int y, int z) {
        while (y > 0) {
            if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().func_76220_a()) {
                if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().equals(Material.field_151584_j) || world.func_180495_p(new BlockPos(x, y, z)).func_185904_a().equals(Material.field_151575_d)) {
                    return 0;
                }
                return y;
            }
            --y;
        }
        return y;
    }
}

